/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support.observer;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ljy.devring.http.support.body.ProgressListener;
import com.ljy.devring.http.support.throwable.HttpThrowable;
import com.ljy.devring.http.support.throwable.ThrowableHandler;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public abstract class UploadObserver<T>
implements Observer<T>,
ProgressListener {
    private String mUploadUrl;
    private String mQualifier;

    public UploadObserver() {
    }

    public UploadObserver(@NonNull String uploadUrl) {
        this.mUploadUrl = uploadUrl;
    }

    public UploadObserver(@NonNull String uploadUrl, @Nullable String qualifier) {
        this.mUploadUrl = uploadUrl;
        this.mQualifier = qualifier;
    }

    public String getUploadUrl() {
        return this.mUploadUrl;
    }

    public String getQualifier() {
        return this.mQualifier;
    }

    public void onSubscribe(Disposable d) {
    }

    public void onComplete() {
    }

    public void onNext(T t) {
        this.onResult(t);
    }

    public void onError(Throwable throwable) {
        if (throwable instanceof Exception) {
            this.onError(0L, ThrowableHandler.handleThrowable(throwable));
        } else {
            this.onError(0L, new HttpThrowable(1000, "\u672a\u77e5\u9519\u8bef", throwable));
        }
    }

    @Override
    public void onProgressError(long id, Exception e) {
        this.onError(id, ThrowableHandler.handleThrowable(e));
    }

    public abstract void onResult(T var1);

    public abstract void onError(long var1, HttpThrowable var3);
}

