/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support.interceptor;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.collection.SimpleArrayMap;
import com.ljy.devring.http.support.body.ProgressListener;
import com.ljy.devring.http.support.body.ProgressRequestBody;
import com.ljy.devring.http.support.body.ProgressResponseBody;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

@Singleton
public class HttpProgressInterceptor
implements Interceptor {
    public static final int DEFAULT_REFRESH_TIME = 150;
    public static final String IDENTIFICATION_NUMBER = "?DevRing=";
    public static final String IDENTIFICATION_HEADER = "DevRing";
    public static final String LOCATION_HEADER = "Location";
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    @Inject
    SimpleArrayMap<String, List<WeakReference<ProgressListener>>> mRequestListeners;
    @Inject
    SimpleArrayMap<String, List<WeakReference<ProgressListener>>> mResponseListeners;
    String location;

    @Inject
    public HttpProgressInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.wrapResponseBody(chain.proceed(this.wrapRequestBody(chain.request())));
    }

    public Request wrapRequestBody(Request request) {
        if (request == null) {
            return request;
        }
        String key = request.url().toString();
        if ((request = this.pruneIdentification(key, request)).body() == null) {
            return request;
        }
        if (this.mRequestListeners.containsKey((Object)key)) {
            List listeners = (List)this.mRequestListeners.get((Object)key);
            return request.newBuilder().method(request.method(), (RequestBody)new ProgressRequestBody(this.mHandler, request.body(), listeners, 150)).build();
        }
        return request;
    }

    private Request pruneIdentification(String url, Request request) {
        boolean needPrune = url.contains(IDENTIFICATION_NUMBER);
        if (!needPrune) {
            return request;
        }
        return request.newBuilder().url(url.substring(0, url.indexOf(IDENTIFICATION_NUMBER))).header(IDENTIFICATION_HEADER, url).build();
    }

    public Response wrapResponseBody(Response response) {
        if (response == null) {
            return response;
        }
        String key = response.request().url().toString();
        if (!TextUtils.isEmpty((CharSequence)response.request().header(IDENTIFICATION_HEADER))) {
            key = response.request().header(IDENTIFICATION_HEADER);
        }
        if (response.isRedirect()) {
            this.resolveRedirect(this.mRequestListeners, response, key);
            String location = this.resolveRedirect(this.mResponseListeners, response, key);
            response = this.modifyLocation(response, location);
            return response;
        }
        if (response.body() == null) {
            return response;
        }
        if (this.mResponseListeners.containsKey((Object)(key = this.removePort(key)))) {
            List listeners = (List)this.mResponseListeners.get((Object)key);
            return response.newBuilder().body((ResponseBody)new ProgressResponseBody(this.mHandler, response.body(), listeners, 150)).build();
        }
        return response;
    }

    private String removePort(String target) {
        Pattern pattern = Pattern.compile("(\\d+\\.\\d+\\.\\d+\\.\\d+)\\:(\\d+)");
        Matcher matcher = pattern.matcher(target);
        if (matcher.find()) {
            target = target.replace(":" + matcher.group(2), "");
        }
        return target;
    }

    private Response modifyLocation(Response response, String location) {
        if (!TextUtils.isEmpty((CharSequence)location) && location.contains(IDENTIFICATION_NUMBER)) {
            response = response.newBuilder().header(LOCATION_HEADER, location).build();
        }
        return response;
    }

    private String resolveRedirect(SimpleArrayMap<String, List<WeakReference<ProgressListener>>> map, Response response, String url) {
        this.location = null;
        List progressListeners = (List)map.get((Object)url);
        if (progressListeners != null && progressListeners.size() > 0) {
            this.location = response.header(LOCATION_HEADER);
            this.location = this.removePort(this.location);
            if (!TextUtils.isEmpty((CharSequence)this.location)) {
                if (url.contains(IDENTIFICATION_NUMBER) && !this.location.contains(IDENTIFICATION_NUMBER)) {
                    this.location = this.location + url.substring(url.indexOf(IDENTIFICATION_NUMBER), url.length());
                }
                if (!map.containsKey((Object)this.location)) {
                    map.put((Object)this.location, (Object)progressListeners);
                } else {
                    List locationListener = (List)map.get((Object)this.location);
                    for (WeakReference listener : progressListeners) {
                        if (locationListener.contains(listener)) continue;
                        locationListener.add(listener);
                    }
                }
            }
        }
        return this.location;
    }

    public SimpleArrayMap<String, List<WeakReference<ProgressListener>>> getRequestListeners() {
        return this.mRequestListeners;
    }

    public SimpleArrayMap<String, List<WeakReference<ProgressListener>>> getResponseListeners() {
        return this.mResponseListeners;
    }
}

