/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.cache.support;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONObject;

public final class DiskCache {
    public static final int SEC = 1;
    public static final int MIN = 60;
    public static final int HOUR = 3600;
    public static final int DAY = 86400;
    private DiskCacheManager mDiskCacheManager;
    private Context mContext;

    public DiskCache(Context context, @NonNull File cacheDir, long maxSize, int maxCount) {
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new RuntimeException("can't make dirs in " + cacheDir.getAbsolutePath());
        }
        this.mContext = context;
        this.mDiskCacheManager = new DiskCacheManager(cacheDir, maxSize, maxCount);
    }

    public void put(@NonNull String key, @NonNull byte[] value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, @NonNull byte[] value, int saveTime) {
        if (value.length <= 0) {
            return;
        }
        if (saveTime >= 0) {
            value = CacheHelper.newByteArrayWithTime(saveTime, value);
        }
        File file = this.mDiskCacheManager.getFileBeforePut(key);
        CacheHelper.writeFileFromBytes(file, value);
        this.mDiskCacheManager.updateModify(file);
        this.mDiskCacheManager.put(file);
    }

    public byte[] getBytes(@NonNull String key) {
        return this.getBytes(key, null);
    }

    public byte[] getBytes(@NonNull String key, byte[] defaultValue) {
        File file = this.mDiskCacheManager.getFileIfExists(key);
        if (file == null) {
            return defaultValue;
        }
        byte[] data = CacheHelper.readFile2Bytes(file);
        if (CacheHelper.isDue(data)) {
            this.mDiskCacheManager.removeByKey(key);
            return defaultValue;
        }
        this.mDiskCacheManager.updateModify(file);
        return CacheHelper.getDataWithoutDueTime(data);
    }

    public void put(@NonNull String key, @NonNull String value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, @NonNull String value, int saveTime) {
        this.put(key, CacheHelper.string2Bytes(value), saveTime);
    }

    public String getString(@NonNull String key) {
        return this.getString(key, null);
    }

    public String getString(@NonNull String key, String defaultValue) {
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheHelper.bytes2String(bytes);
    }

    public void put(@NonNull String key, @NonNull JSONObject value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, @NonNull JSONObject value, int saveTime) {
        this.put(key, CacheHelper.jsonObject2Bytes(value), saveTime);
    }

    public JSONObject getJSONObject(@NonNull String key) {
        return this.getJSONObject(key, null);
    }

    public JSONObject getJSONObject(@NonNull String key, JSONObject defaultValue) {
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheHelper.bytes2JSONObject(bytes);
    }

    public void put(@NonNull String key, @NonNull JSONArray value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, @NonNull JSONArray value, int saveTime) {
        this.put(key, CacheHelper.jsonArray2Bytes(value), saveTime);
    }

    public JSONArray getJSONArray(@NonNull String key) {
        return this.getJSONArray(key, null);
    }

    public JSONArray getJSONArray(@NonNull String key, JSONArray defaultValue) {
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheHelper.bytes2JSONArray(bytes);
    }

    public void put(@NonNull String key, @NonNull Bitmap value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, @NonNull Bitmap value, int saveTime) {
        this.put(key, CacheHelper.bitmap2Bytes(value), saveTime);
    }

    public Bitmap getBitmap(@NonNull String key) {
        return this.getBitmap(key, null);
    }

    public Bitmap getBitmap(@NonNull String key, Bitmap defaultValue) {
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheHelper.bytes2Bitmap(bytes);
    }

    public void put(@NonNull String key, @NonNull Drawable value) {
        this.put(key, CacheHelper.drawable2Bytes(value));
    }

    public void put(@NonNull String key, @NonNull Drawable value, int saveTime) {
        this.put(key, CacheHelper.drawable2Bytes(value), saveTime);
    }

    public Drawable getDrawable(@NonNull String key) {
        return this.getDrawable(key, null);
    }

    public Drawable getDrawable(@NonNull String key, Drawable defaultValue) {
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheHelper.bytes2Drawable(this.mContext, bytes);
    }

    public void put(@NonNull String key, @NonNull Parcelable value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, @NonNull Parcelable value, int saveTime) {
        this.put(key, CacheHelper.parcelable2Bytes(value), saveTime);
    }

    public <T> T getParcelable(@NonNull String key, @NonNull Parcelable.Creator<T> creator) {
        return this.getParcelable(key, creator, null);
    }

    public <T> T getParcelable(@NonNull String key, @NonNull Parcelable.Creator<T> creator, T defaultValue) {
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return (T)CacheHelper.bytes2Parcelable(bytes, creator);
    }

    public void put(@NonNull String key, @NonNull Serializable value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, @NonNull Serializable value, int saveTime) {
        this.put(key, CacheHelper.serializable2Bytes(value), saveTime);
    }

    public Object getSerializable(@NonNull String key) {
        return this.getSerializable(key, null);
    }

    public Object getSerializable(@NonNull String key, Object defaultValue) {
        byte[] bytes = this.getBytes(key);
        if (bytes == null) {
            return defaultValue;
        }
        return CacheHelper.bytes2Object(this.getBytes(key));
    }

    public long getCacheSize() {
        return this.mDiskCacheManager.getCacheSize();
    }

    public int getCacheCount() {
        return this.mDiskCacheManager.getCacheCount();
    }

    public boolean remove(@NonNull String key) {
        return this.mDiskCacheManager.removeByKey(key);
    }

    public boolean clear() {
        return this.mDiskCacheManager.clear();
    }

    private static class CacheHelper {
        static final int timeInfoLen = 14;

        private CacheHelper() {
        }

        private static byte[] newByteArrayWithTime(int second, byte[] data) {
            byte[] time = CacheHelper.createDueTime(second).getBytes();
            byte[] content = new byte[time.length + data.length];
            System.arraycopy(time, 0, content, 0, time.length);
            System.arraycopy(data, 0, content, time.length, data.length);
            return content;
        }

        private static String createDueTime(int seconds) {
            return String.format(Locale.getDefault(), "_$%010d$_", System.currentTimeMillis() / 1000L + (long)seconds);
        }

        private static boolean isDue(byte[] data) {
            long millis = CacheHelper.getDueTime(data);
            return millis != -1L && System.currentTimeMillis() > millis;
        }

        private static long getDueTime(byte[] data) {
            if (CacheHelper.hasTimeInfo(data)) {
                String millis = new String(CacheHelper.copyOfRange(data, 2, 12));
                try {
                    return Long.parseLong(millis) * 1000L;
                }
                catch (NumberFormatException e) {
                    return -1L;
                }
            }
            return -1L;
        }

        private static byte[] getDataWithoutDueTime(byte[] data) {
            if (CacheHelper.hasTimeInfo(data)) {
                return CacheHelper.copyOfRange(data, 14, data.length);
            }
            return data;
        }

        private static byte[] copyOfRange(byte[] original, int from, int to) {
            int newLength = to - from;
            if (newLength < 0) {
                throw new IllegalArgumentException(from + " > " + to);
            }
            byte[] copy = new byte[newLength];
            System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
            return copy;
        }

        private static boolean hasTimeInfo(byte[] data) {
            return data != null && data.length >= 14 && data[0] == 95 && data[1] == 36 && data[12] == 36 && data[13] == 95;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeFileFromBytes(File file, byte[] bytes) {
            FileChannel fc = null;
            try {
                fc = new FileOutputStream(file, false).getChannel();
                fc.write(ByteBuffer.wrap(bytes));
                fc.force(true);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    CacheHelper.closeIO(fc);
                    throw throwable;
                }
                CacheHelper.closeIO(fc);
            }
            CacheHelper.closeIO(fc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] readFile2Bytes(File file) {
            byte[] byArray;
            FileChannel fc = null;
            try {
                fc = new RandomAccessFile(file, "r").getChannel();
                int size = (int)fc.size();
                MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size).load();
                byte[] data = new byte[size];
                mbb.get(data, 0, size);
                byArray = data;
            }
            catch (IOException e) {
                byte[] byArray2;
                try {
                    e.printStackTrace();
                    byArray2 = null;
                }
                catch (Throwable throwable) {
                    CacheHelper.closeIO(fc);
                    throw throwable;
                }
                CacheHelper.closeIO(fc);
                return byArray2;
            }
            CacheHelper.closeIO(fc);
            return byArray;
        }

        private static byte[] string2Bytes(String string) {
            if (string == null) {
                return null;
            }
            return string.getBytes();
        }

        private static String bytes2String(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            return new String(bytes);
        }

        private static byte[] jsonObject2Bytes(JSONObject jsonObject) {
            if (jsonObject == null) {
                return null;
            }
            return jsonObject.toString().getBytes();
        }

        private static JSONObject bytes2JSONObject(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            try {
                return new JSONObject(new String(bytes));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private static byte[] jsonArray2Bytes(JSONArray jsonArray) {
            if (jsonArray == null) {
                return null;
            }
            return jsonArray.toString().getBytes();
        }

        private static JSONArray bytes2JSONArray(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            try {
                return new JSONArray(new String(bytes));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private static byte[] parcelable2Bytes(Parcelable parcelable) {
            if (parcelable == null) {
                return null;
            }
            Parcel parcel = Parcel.obtain();
            parcelable.writeToParcel(parcel, 0);
            byte[] bytes = parcel.marshall();
            parcel.recycle();
            return bytes;
        }

        private static <T> T bytes2Parcelable(byte[] bytes, Parcelable.Creator<T> creator) {
            if (bytes == null) {
                return null;
            }
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(bytes, 0, bytes.length);
            parcel.setDataPosition(0);
            Object result = creator.createFromParcel(parcel);
            parcel.recycle();
            return (T)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] serializable2Bytes(Serializable serializable) {
            byte[] byArray;
            if (serializable == null) {
                return null;
            }
            ObjectOutputStream oos = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(serializable);
                byArray = baos.toByteArray();
            }
            catch (Exception e) {
                byte[] byArray2;
                try {
                    e.printStackTrace();
                    byArray2 = null;
                }
                catch (Throwable throwable) {
                    CacheHelper.closeIO(oos);
                    throw throwable;
                }
                CacheHelper.closeIO(oos);
                return byArray2;
            }
            CacheHelper.closeIO(oos);
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object bytes2Object(byte[] bytes) {
            Object object;
            if (bytes == null) {
                return null;
            }
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
                object = ois.readObject();
            }
            catch (Exception e) {
                Object var3_4;
                try {
                    e.printStackTrace();
                    var3_4 = null;
                }
                catch (Throwable throwable) {
                    CacheHelper.closeIO(ois);
                    throw throwable;
                }
                CacheHelper.closeIO(ois);
                return var3_4;
            }
            CacheHelper.closeIO(ois);
            return object;
        }

        private static byte[] bitmap2Bytes(Bitmap bitmap) {
            if (bitmap == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
            return baos.toByteArray();
        }

        private static Bitmap bytes2Bitmap(byte[] bytes) {
            return bytes == null || bytes.length == 0 ? null : BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        }

        private static byte[] drawable2Bytes(Drawable drawable) {
            return drawable == null ? null : CacheHelper.bitmap2Bytes(CacheHelper.drawable2Bitmap(drawable));
        }

        private static Drawable bytes2Drawable(Context context, byte[] bytes) {
            return bytes == null ? null : CacheHelper.bitmap2Drawable(context, CacheHelper.bytes2Bitmap(bytes));
        }

        private static Bitmap drawable2Bitmap(Drawable drawable) {
            BitmapDrawable bitmapDrawable;
            if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
                return bitmapDrawable.getBitmap();
            }
            Bitmap bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap;
        }

        private static Drawable bitmap2Drawable(Context context, Bitmap bitmap) {
            return bitmap == null ? null : new BitmapDrawable(context.getResources(), bitmap);
        }

        public static void closeIO(Closeable ... closeables) {
            if (closeables == null) {
                return;
            }
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class DiskCacheManager {
        private final AtomicLong cacheSize;
        private final AtomicInteger cacheCount;
        private final long sizeLimit;
        private final int countLimit;
        private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());
        private final File cacheDir;
        private final Thread mThread;

        private DiskCacheManager(final File cacheDir, long sizeLimit, int countLimit) {
            this.cacheDir = cacheDir;
            this.sizeLimit = sizeLimit;
            this.countLimit = countLimit;
            this.cacheSize = new AtomicLong();
            this.cacheCount = new AtomicInteger();
            this.mThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int size = 0;
                    int count = 0;
                    File[] cachedFiles = cacheDir.listFiles();
                    if (cachedFiles != null) {
                        for (File cachedFile : cachedFiles) {
                            size = (int)((long)size + cachedFile.length());
                            ++count;
                            DiskCacheManager.this.lastUsageDates.put(cachedFile, cachedFile.lastModified());
                        }
                        DiskCacheManager.this.cacheSize.getAndAdd(size);
                        DiskCacheManager.this.cacheCount.getAndAdd(count);
                    }
                }
            });
            this.mThread.start();
        }

        private long getCacheSize() {
            try {
                this.mThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.cacheSize.get();
        }

        private int getCacheCount() {
            try {
                this.mThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.cacheCount.get();
        }

        private File getFileBeforePut(String key) {
            File file = new File(this.cacheDir, String.valueOf(key.hashCode()));
            if (file.exists()) {
                this.cacheCount.addAndGet(-1);
                this.cacheSize.addAndGet(-file.length());
            }
            return file;
        }

        private File getFileIfExists(String key) {
            File file = new File(this.cacheDir, String.valueOf(key.hashCode()));
            if (!file.exists()) {
                return null;
            }
            return file;
        }

        private void put(File file) {
            this.cacheCount.addAndGet(1);
            this.cacheSize.addAndGet(file.length());
            while (this.cacheCount.get() > this.countLimit || this.cacheSize.get() > this.sizeLimit) {
                this.cacheSize.addAndGet(-this.removeOldest());
                this.cacheCount.addAndGet(-1);
            }
        }

        private void updateModify(File file) {
            Long millis = System.currentTimeMillis();
            file.setLastModified(millis);
            this.lastUsageDates.put(file, millis);
        }

        private boolean removeByKey(String key) {
            File file = this.getFileIfExists(key);
            if (file == null) {
                return true;
            }
            if (!file.delete()) {
                return false;
            }
            this.cacheSize.addAndGet(-file.length());
            this.cacheCount.addAndGet(-1);
            this.lastUsageDates.remove(file);
            return true;
        }

        private boolean clear() {
            File[] files = this.cacheDir.listFiles();
            if (files == null || files.length <= 0) {
                return true;
            }
            boolean flag = true;
            for (File file : files) {
                if (!file.delete()) {
                    flag = false;
                    continue;
                }
                this.cacheSize.addAndGet(-file.length());
                this.cacheCount.addAndGet(-1);
                this.lastUsageDates.remove(file);
            }
            if (flag) {
                this.lastUsageDates.clear();
                this.cacheSize.set(0L);
                this.cacheCount.set(0);
            }
            return flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long removeOldest() {
            if (this.lastUsageDates.isEmpty()) {
                return 0L;
            }
            Long oldestUsage = Long.MAX_VALUE;
            File oldestFile = null;
            Set<Map.Entry<File, Long>> entries = this.lastUsageDates.entrySet();
            Map<File, Long> map = this.lastUsageDates;
            synchronized (map) {
                for (Map.Entry<File, Long> entry : entries) {
                    Long lastValueUsage = entry.getValue();
                    if (lastValueUsage >= oldestUsage) continue;
                    oldestUsage = lastValueUsage;
                    oldestFile = entry.getKey();
                }
            }
            if (oldestFile == null) {
                return 0L;
            }
            long fileSize = oldestFile.length();
            if (oldestFile.delete()) {
                this.lastUsageDates.remove(oldestFile);
                return fileSize;
            }
            return 0L;
        }
    }
}

