/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.bus;

import com.ljy.devring.bus.BusConfig;
import com.ljy.devring.bus.support.IBusManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.greenrobot.eventbus.EventBus;

@Singleton
public class EventBusManager
implements IBusManager {
    @Inject
    BusConfig mBusConfig;

    @Inject
    public EventBusManager() {
    }

    @Override
    public void register(Object subscriber) {
        if (!EventBus.getDefault().isRegistered(subscriber)) {
            EventBus.getDefault().register(subscriber);
        }
    }

    @Override
    public void unregister(Object subscriber) {
        if (EventBus.getDefault().isRegistered(subscriber)) {
            EventBus.getDefault().unregister(subscriber);
        }
    }

    @Override
    public void postEvent(Object event) {
        EventBus.getDefault().post(event);
    }

    @Override
    public void postStickyEvent(Object event) {
        EventBus.getDefault().postSticky(event);
    }

    public void openIndex() {
        if (this.mBusConfig.isUseIndex() && this.mBusConfig.getIndex() != null) {
            EventBus.builder().addIndex(this.mBusConfig.getIndex()).installDefaultEventBus();
        }
    }

    public void cancelDelivery(Object event) {
        EventBus.getDefault().cancelEventDelivery(event);
    }

    public <T> T getStickyEvent(Class<T> classType) {
        return (T)EventBus.getDefault().getStickyEvent(classType);
    }

    public void removeStickyEvent(Object event) {
        EventBus.getDefault().removeStickyEvent(event);
    }
}

