/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.base.activity;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.collection.SimpleArrayMap;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.ljy.devring.base.activity.ActivityLife;
import com.ljy.devring.base.activity.IActivityLife;
import com.ljy.devring.base.activity.IBaseActivity;
import com.ljy.devring.base.fragment.FragmentLifeCallback;
import dagger.Lazy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ActivityLifeCallback
implements Application.ActivityLifecycleCallbacks {
    @Inject
    SimpleArrayMap<String, IActivityLife> mMapActivityLife;
    @Inject
    Provider<IActivityLife> mActivityLifeProvider;
    @Inject
    Lazy<FragmentLifeCallback> mFragmentLifeCallbackProvider;

    @Inject
    public ActivityLifeCallback() {
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        boolean isUseFragment;
        if (activity instanceof IBaseActivity) {
            IActivityLife iActivityLife = (IActivityLife)this.mMapActivityLife.get((Object)activity.toString());
            if (iActivityLife == null) {
                iActivityLife = (IActivityLife)this.mActivityLifeProvider.get();
                this.mMapActivityLife.put((Object)activity.toString(), (Object)iActivityLife);
            }
            iActivityLife.onCreate(activity, bundle);
        }
        boolean bl = isUseFragment = activity instanceof IBaseActivity ? ((IBaseActivity)activity).isUseFragment() : true;
        if (activity instanceof FragmentActivity && isUseFragment) {
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this.mFragmentLifeCallbackProvider.get(), true);
        }
    }

    public void onActivityStarted(Activity activity) {
        IActivityLife iActivityLife = (IActivityLife)this.mMapActivityLife.get((Object)activity.toString());
        if (iActivityLife != null) {
            iActivityLife.onStart();
        }
    }

    public void onActivityResumed(Activity activity) {
        IActivityLife iActivityLife = (IActivityLife)this.mMapActivityLife.get((Object)activity.toString());
        if (iActivityLife != null) {
            iActivityLife.onResume();
        }
    }

    public void onActivityPaused(Activity activity) {
        IActivityLife iActivityLife = (IActivityLife)this.mMapActivityLife.get((Object)activity.toString());
        if (iActivityLife != null) {
            iActivityLife.onPause();
        }
    }

    public void onActivityStopped(Activity activity) {
        IActivityLife iActivityLife = (IActivityLife)this.mMapActivityLife.get((Object)activity.toString());
        if (iActivityLife != null) {
            iActivityLife.onStop();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        IActivityLife iActivityLife = (IActivityLife)this.mMapActivityLife.get((Object)activity.toString());
        if (iActivityLife != null) {
            iActivityLife.onSaveInstanceState(bundle);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        IActivityLife iActivityLife = (IActivityLife)this.mMapActivityLife.get((Object)activity.toString());
        if (iActivityLife != null) {
            iActivityLife.onDestroy();
        }
        this.mMapActivityLife.remove((Object)activity.toString());
    }

    public ActivityLife getActivityLife(String key) {
        return (ActivityLife)this.mMapActivityLife.get((Object)key);
    }
}

