/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.image.support;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.support.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import java.security.MessageDigest;
import jp.wasabeef.glide.transformations.BitmapTransformation;

public class CircleBorderTransformation
extends BitmapTransformation {
    private static final int VERSION = 1;
    private static final String ID = "com.ljy.ring.devring.CircleBorderTransformation.1";
    private static final byte[] ID_BYTES = "com.ljy.ring.devring.CircleBorderTransformation.1".getBytes(CHARSET);
    private Paint mBorderPaint;
    private float mBorderWidth;

    public CircleBorderTransformation() {
    }

    public CircleBorderTransformation(int borderWidth, int borderColor) {
        float density = Resources.getSystem().getDisplayMetrics().density;
        this.mBorderWidth = (int)((float)borderWidth * density + 0.5f);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setDither(true);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(borderColor);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
    }

    protected Bitmap transform(@NonNull Context context, @NonNull BitmapPool pool, @NonNull Bitmap source, int outWidth, int outHeight) {
        if (source == null) {
            return null;
        }
        int size = (int)((float)Math.min(source.getWidth(), source.getHeight()) - this.mBorderWidth / 2.0f);
        int x = (source.getWidth() - size) / 2;
        int y = (source.getHeight() - size) / 2;
        Bitmap squared = Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)size, (int)size);
        Bitmap result = pool.get(size, size, Bitmap.Config.ARGB_8888);
        if (result == null) {
            result = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint();
        paint.setShader((Shader)new BitmapShader(squared, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        paint.setAntiAlias(true);
        float r = (float)size / 2.0f;
        canvas.drawCircle(r, r, r, paint);
        if (this.mBorderPaint != null) {
            float borderRadius = r - this.mBorderWidth / 2.0f;
            canvas.drawCircle(r, r, borderRadius, this.mBorderPaint);
        }
        return result;
    }

    public String toString() {
        return "CircleBorderTransformation()";
    }

    public boolean equals(Object o) {
        return o instanceof CircleBorderTransformation;
    }

    public int hashCode() {
        return ID.hashCode();
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        messageDigest.update(ID_BYTES);
    }
}

