/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.db.support;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.EncryptedDatabase;
import org.greenrobot.greendao.database.StandardDatabase;

public abstract class DatabaseOpenHelperFixed
extends SQLiteOpenHelper {
    private final Context context;
    private final String name;
    private final int version;
    private EncryptedHelper encryptedHelper;
    private boolean loadSQLCipherNativeLibs = true;

    public DatabaseOpenHelperFixed(Context context, String name, int version) {
        this(context, name, null, version);
    }

    public DatabaseOpenHelperFixed(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.context = context;
        this.name = name;
        this.version = version;
    }

    public void setLoadSQLCipherNativeLibs(boolean loadSQLCipherNativeLibs) {
        this.loadSQLCipherNativeLibs = loadSQLCipherNativeLibs;
    }

    public Database getWritableDb() {
        return this.wrap(this.getWritableDatabase());
    }

    public Database getReadableDb() {
        return this.wrap(this.getReadableDatabase());
    }

    protected Database wrap(SQLiteDatabase sqLiteDatabase) {
        return new StandardDatabase(sqLiteDatabase);
    }

    public void onCreate(SQLiteDatabase db) {
        this.onCreate(this.wrap(db));
    }

    public void onCreate(Database db) {
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(this.wrap(db), oldVersion, newVersion);
    }

    public void onUpgrade(Database db, int oldVersion, int newVersion) {
    }

    public void onOpen(SQLiteDatabase db) {
        this.onOpen(this.wrap(db));
    }

    public void onOpen(Database db) {
    }

    private EncryptedHelper checkEncryptedHelper() {
        if (this.encryptedHelper == null) {
            this.encryptedHelper = new EncryptedHelperImpl(this.context, this.name, this.version, this.loadSQLCipherNativeLibs, this);
        }
        return this.encryptedHelper;
    }

    public Database getEncryptedWritableDb(String password) {
        EncryptedHelper encryptedHelper = this.checkEncryptedHelper();
        return encryptedHelper.getEncryptedWritableDb(password);
    }

    public Database getEncryptedWritableDb(char[] password) {
        EncryptedHelper encryptedHelper = this.checkEncryptedHelper();
        return encryptedHelper.getEncryptedWritableDb(password);
    }

    public Database getEncryptedReadableDb(String password) {
        EncryptedHelper encryptedHelper = this.checkEncryptedHelper();
        return encryptedHelper.getEncryptedReadableDb(password);
    }

    public Database getEncryptedReadableDb(char[] password) {
        EncryptedHelper encryptedHelper = this.checkEncryptedHelper();
        return encryptedHelper.getEncryptedReadableDb(password);
    }

    static final class EncryptedHelperImpl
    extends net.sqlcipher.database.SQLiteOpenHelper
    implements EncryptedHelper {
        private final DatabaseOpenHelperFixed delegate;

        EncryptedHelperImpl(Context context, String name, int version, boolean loadLibs, DatabaseOpenHelperFixed delegate) {
            super(context, name, null, version);
            this.delegate = delegate;
            if (loadLibs) {
                net.sqlcipher.database.SQLiteDatabase.loadLibs((Context)context);
            }
        }

        public void onCreate(net.sqlcipher.database.SQLiteDatabase db) {
            this.delegate.onCreate(this.wrap(db));
        }

        public void onUpgrade(net.sqlcipher.database.SQLiteDatabase db, int oldVersion, int newVersion) {
            this.delegate.onUpgrade(this.wrap(db), oldVersion, newVersion);
        }

        public void onOpen(net.sqlcipher.database.SQLiteDatabase db) {
            this.delegate.onOpen(this.wrap(db));
        }

        @Override
        public Database getEncryptedReadableDb(String password) {
            return this.wrap(this.getReadableDatabase(password));
        }

        @Override
        public Database getEncryptedReadableDb(char[] password) {
            return this.wrap(this.getReadableDatabase(password));
        }

        @Override
        public Database getEncryptedWritableDb(String password) {
            return this.wrap(this.getWritableDatabase(password));
        }

        @Override
        public Database getEncryptedWritableDb(char[] password) {
            return this.wrap(this.getWritableDatabase(password));
        }

        private Database wrap(net.sqlcipher.database.SQLiteDatabase sqLiteDatabase) {
            return new EncryptedDatabase(sqLiteDatabase);
        }
    }

    static interface EncryptedHelper {
        public Database getEncryptedReadableDb(String var1);

        public Database getEncryptedReadableDb(char[] var1);

        public Database getEncryptedWritableDb(String var1);

        public Database getEncryptedWritableDb(char[] var1);
    }
}

