/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;

public class ConfigUtil {
    public static int[] getScreenSize(Context context) {
        int[] size = new int[2];
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics dm = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getRealMetrics(dm);
            size[0] = dm.widthPixels;
            size[1] = dm.heightPixels;
        } else {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics dm = new DisplayMetrics();
            try {
                Class<?> c = Class.forName("android.view.Display");
                Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
                method.invoke((Object)display, dm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            size[0] = dm.widthPixels;
            size[1] = dm.heightPixels;
        }
        return size;
    }

    public static int getScreenLongSide(Context context) {
        int[] screenSize = ConfigUtil.getScreenSize(context);
        return Math.max(screenSize[0], screenSize[1]);
    }

    public static int getScreenShortSide(Context context) {
        int[] screenSize = ConfigUtil.getScreenSize(context);
        return Math.min(screenSize[0], screenSize[1]);
    }

    public static int getStatusBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static int getNavigationBarHeight(Context context) {
        if (ConfigUtil.hasNavigationBar(context)) {
            Resources resources = context.getResources();
            int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static boolean hasNavigationBar(Context context) {
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        boolean hasNavBarFun = false;
        if (id2 > 0) {
            hasNavBarFun = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String)m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                hasNavBarFun = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavBarFun = true;
            }
        }
        catch (Exception e) {
            hasNavBarFun = false;
        }
        return hasNavBarFun;
    }

    public static boolean isApkInDebug(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

