/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http;

import android.text.TextUtils;
import com.ljy.devring.cache.support.MemoryCache;
import com.ljy.devring.http.HttpConfig;
import com.ljy.devring.http.support.RetryFunction;
import com.ljy.devring.http.support.body.ProgressListener;
import com.ljy.devring.http.support.interceptor.HttpProgressInterceptor;
import com.ljy.devring.http.support.observer.DownloadObserver;
import com.ljy.devring.http.support.observer.UploadObserver;
import com.ljy.devring.util.FileUtil;
import com.ljy.devring.util.RxLifecycleUtil;
import com.trello.rxlifecycle2.LifecycleTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Retrofit;

@Singleton
public class HttpManager {
    @Inject
    HttpProgressInterceptor mProgressInterceptor;
    @Inject
    Provider<Retrofit> mProviderRetrofit;
    @Inject
    MemoryCache mMemoryCache;
    @Inject
    HttpConfig mHttpConfig;
    Retrofit mRetrofit;
    List<String> mListCacheKey = new ArrayList<String>();
    PublishSubject<String> mTagEmitter = PublishSubject.create();

    @Inject
    public HttpManager() {
    }

    public <T> T getService(Class<T> serviceClass) {
        String cacheKey;
        Object service;
        if (this.mRetrofit == null) {
            this.mRetrofit = (Retrofit)this.mProviderRetrofit.get();
        }
        if ((service = this.mMemoryCache.get(cacheKey = serviceClass.getCanonicalName())) == null) {
            service = this.mRetrofit.create(serviceClass);
            this.mMemoryCache.put(cacheKey, service);
            if (!this.mListCacheKey.contains(cacheKey)) {
                this.mListCacheKey.add(cacheKey);
            }
        }
        return (T)service;
    }

    public void commonRequest(Observable observable, Observer observer, LifecycleTransformer transformer) {
        this.handleRetry(this.handleLife(this.handleThread(observable), transformer), this.mHttpConfig.isUseRetryWhenError(), this.mHttpConfig.getTimeRetryDelay(), this.mHttpConfig.getMaxRetryCount()).subscribe(observer);
    }

    public void commonRequest(Observable observable, Observer observer, String lifeTag) {
        this.commonRequest(observable, observer, lifeTag != null ? RxLifecycleUtil.RxBindUntilEvent(this.mTagEmitter, lifeTag) : null);
    }

    public void uploadRequest(Observable observable, UploadObserver uploadObserver, LifecycleTransformer transformer) {
        if (!TextUtils.isEmpty((CharSequence)uploadObserver.getUploadUrl())) {
            if (TextUtils.isEmpty((CharSequence)uploadObserver.getQualifier())) {
                this.addRequestListener(uploadObserver.getUploadUrl(), uploadObserver);
            } else {
                this.addDiffRequestListenerOnSameUrl(uploadObserver.getUploadUrl(), uploadObserver.getQualifier(), uploadObserver);
            }
        }
        this.handleRetry(this.handleLife(this.handleThread(observable), transformer), this.mHttpConfig.isUseRetryWhenError(), this.mHttpConfig.getTimeRetryDelay(), this.mHttpConfig.getMaxRetryCount()).subscribe((Observer)uploadObserver);
    }

    public void uploadRequest(Observable observable, UploadObserver uploadObserver, String lifeTag) {
        this.uploadRequest(observable, uploadObserver, lifeTag != null ? RxLifecycleUtil.RxBindUntilEvent(this.mTagEmitter, lifeTag) : null);
    }

    public void downloadRequest(File fileSave, Observable observable, DownloadObserver downloadObserver, LifecycleTransformer transformer) {
        if (!TextUtils.isEmpty((CharSequence)downloadObserver.getDownloadUrl())) {
            if (TextUtils.isEmpty((CharSequence)downloadObserver.getQualifier())) {
                this.addResponseListener(downloadObserver.getDownloadUrl(), downloadObserver);
            } else {
                this.addDiffResponseListenerOnSameUrl(downloadObserver.getDownloadUrl(), downloadObserver.getQualifier(), downloadObserver);
            }
        }
        this.handleRetry(this.handleLife(this.handleThreadForDownload(fileSave, observable, downloadObserver), transformer), this.mHttpConfig.isUseRetryWhenError(), this.mHttpConfig.getTimeRetryDelay(), this.mHttpConfig.getMaxRetryCount()).subscribe((Observer)downloadObserver);
    }

    public void downloadRequest(File fileSave, Observable observable, DownloadObserver downloadObserver, String lifeTag) {
        this.downloadRequest(fileSave, observable, downloadObserver, lifeTag != null ? RxLifecycleUtil.RxBindUntilEvent(this.mTagEmitter, lifeTag) : null);
    }

    public void stopRequestByTag(String tag) {
        this.mTagEmitter.onNext((Object)tag);
    }

    private Observable handleLife(Observable observable, LifecycleTransformer transformer) {
        if (transformer != null) {
            return observable.compose((ObservableTransformer)transformer);
        }
        return observable;
    }

    private Observable handleThread(Observable observable) {
        return observable.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Observable handleThreadForDownload(final File fileSave, Observable observable, final DownloadObserver downloadObserver) {
        return observable.observeOn(Schedulers.io()).doOnNext((Consumer)new Consumer<ResponseBody>(){

            public void accept(ResponseBody body) throws Exception {
                boolean isSuccess = FileUtil.saveFile(body.byteStream(), new FileOutputStream(fileSave));
                downloadObserver.setResult(isSuccess, fileSave.getAbsolutePath());
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Observable handleRetry(Observable observable, boolean isUseRetry, int timeRetryDelay, int maxRetryCount) {
        if (isUseRetry) {
            return observable.retryWhen((Function)new RetryFunction(timeRetryDelay >= 0 ? timeRetryDelay : 3, maxRetryCount > 0 ? maxRetryCount : 3));
        }
        return observable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestListener(String url, ProgressListener listener) {
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            LinkedList<WeakReference<ProgressListener>> progressListeners = (LinkedList<WeakReference<ProgressListener>>)this.mProgressInterceptor.getRequestListeners().get((Object)url);
            if (progressListeners == null) {
                progressListeners = new LinkedList<WeakReference<ProgressListener>>();
                this.mProgressInterceptor.getRequestListeners().put((Object)url, progressListeners);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (!this.isListenerExist(progressListeners, listener)) {
                progressListeners.add(new WeakReference<ProgressListener>(listener));
            }
            return;
        }
    }

    public String addDiffRequestListenerOnSameUrl(String originUrl, String qualifier, ProgressListener listener) {
        String newUrl = originUrl + "?DevRing=" + qualifier;
        this.addRequestListener(newUrl, listener);
        return newUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseListener(String url, ProgressListener listener) {
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            LinkedList<WeakReference<ProgressListener>> progressListeners = (LinkedList<WeakReference<ProgressListener>>)this.mProgressInterceptor.getResponseListeners().get((Object)url);
            if (progressListeners == null) {
                progressListeners = new LinkedList<WeakReference<ProgressListener>>();
                this.mProgressInterceptor.getResponseListeners().put((Object)url, progressListeners);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (!this.isListenerExist(progressListeners, listener)) {
                progressListeners.add(new WeakReference<ProgressListener>(listener));
            }
            return;
        }
    }

    public String addDiffResponseListenerOnSameUrl(String originUrl, String qualifier, ProgressListener listener) {
        String newUrl = originUrl + "?DevRing=" + qualifier;
        this.addResponseListener(newUrl, listener);
        return newUrl;
    }

    private boolean isListenerExist(List<WeakReference<ProgressListener>> progressListeners, ProgressListener listener) {
        Iterator<WeakReference<ProgressListener>> iterator = progressListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<ProgressListener> progressListener = iterator.next();
            if (progressListener.get() == null) {
                iterator.remove();
                continue;
            }
            if (!((ProgressListener)progressListener.get()).equals(listener)) continue;
            return true;
        }
        return false;
    }

    public Map<String, RequestBody> getRequestBodyMap(Map<String, File> map, MediaType mediaType) {
        HashMap<String, RequestBody> bodyMap = new HashMap<String, RequestBody>();
        for (Map.Entry<String, File> entry : map.entrySet()) {
            bodyMap.put(entry.getKey() + "\"; filename=\"" + entry.getValue().getName(), RequestBody.create((MediaType)mediaType, (File)entry.getValue()));
        }
        return bodyMap;
    }

    public void refreshInstance() {
        this.mRetrofit = null;
        this.mRetrofit = (Retrofit)this.mProviderRetrofit.get();
        for (String key : this.mListCacheKey) {
            this.mMemoryCache.remove(key);
        }
        this.mListCacheKey.clear();
    }
}

