package com.ljy.devring.other.toast;

import android.view.Gravity;
import android.view.View;

/**
 *    author : HJQ
 *    github : https://github.com/getActivity/ToastUtils
 *    time   : 2018/09/01
 *    desc   : 默认黑色样式实现
 *    modify : ljy
 */
public class ToastBlackStyle implements IToastStyle {

    @Override
    public int getGravity() {
        return Gravity.CENTER;
    }

    @Override
    public int getXOffset() {
        return 0;
    }

    @Override
    public int getYOffset() {
        return 0;
    }

    @Override
    public int getCornerRadius() {
        return 7;
    }

    @Override
    public int getBackgroundColor() {
        return 0XAA000000;
    }

    @Override
    public int getTextColor() {
        return 0XEEFFFFFF;
    }

    @Override
    public float getTextSize() {
        return 16;
    }

    @Override
    public int getMaxLines() {
        return 3;
    }

    @Override
    public int getPaddingLeft() {
        return 15;
    }

    @Override
    public int getPaddingTop() {
        return 10;
    }

    @Override
    public int getPaddingRight() {
        return getPaddingLeft();
    }

    @Override
    public int getPaddingBottom() {
        return getPaddingTop();
    }

    @Override
    public View getCustomToastView() {
        return null;
    }
}