/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.di.module;

import android.app.Application;
import android.content.Context;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.ljy.devring.bus.EventBusManager;
import com.ljy.devring.bus.support.IBusManager;
import com.ljy.devring.cache.support.DiskCache;
import com.ljy.devring.cache.support.MemoryCache;
import com.ljy.devring.cache.support.SpCache;
import com.ljy.devring.db.support.ITableManger;
import com.ljy.devring.http.HttpConfig;
import com.ljy.devring.http.support.body.ProgressListener;
import com.ljy.devring.http.support.interceptor.HttpCacheInterceptor;
import com.ljy.devring.http.support.interceptor.HttpHeaderInterceptor;
import com.ljy.devring.http.support.interceptor.HttpLoggingInterceptor;
import com.ljy.devring.http.support.interceptor.HttpProgressInterceptor;
import com.ljy.devring.http.support.persistentcookiejar.PersistentCookieJar;
import com.ljy.devring.http.support.persistentcookiejar.cache.SetCookieCache;
import com.ljy.devring.http.support.persistentcookiejar.persistence.SharedPrefsCookiePersistor;
import com.ljy.devring.image.GlideManager;
import com.ljy.devring.image.support.IImageManager;
import com.ljy.devring.util.FileUtil;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import okhttp3.Cache;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class RingModule {
    @Singleton
    @Provides
    IImageManager imageManager() {
        return new GlideManager();
    }

    @Singleton
    @Provides
    IBusManager busManager(EventBusManager eventBusManager) {
        return eventBusManager;
    }

    @Singleton
    @Provides
    SimpleArrayMap<Object, ITableManger> mapTableManager() {
        return new SimpleArrayMap();
    }

    @Provides
    Retrofit retrofit(Retrofit.Builder builder, OkHttpClient okHttpClient, HttpConfig httpConfig) {
        if (!TextUtils.isEmpty((CharSequence)httpConfig.getBaseUrl())) {
            builder.baseUrl(httpConfig.getBaseUrl());
        }
        builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        builder.client(okHttpClient);
        return builder.build();
    }

    @Singleton
    @Provides
    Retrofit.Builder retrofitBuilder() {
        return new Retrofit.Builder();
    }

    @Provides
    OkHttpClient okHttpClient(Application application, OkHttpClient.Builder builder, HttpConfig httpConfig, HttpLoggingInterceptor loggingInterceptor, HttpCacheInterceptor cacheInterceptor, HttpHeaderInterceptor headerInterceptor, HttpProgressInterceptor progressInterceptor) {
        if (httpConfig.getConnectTimeout() > 0) {
            builder.connectTimeout((long)httpConfig.getConnectTimeout(), TimeUnit.SECONDS);
        }
        if (httpConfig.isUseLog() && !builder.interceptors().contains(loggingInterceptor)) {
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)loggingInterceptor);
        }
        if (httpConfig.isUseCache() && !builder.interceptors().contains(cacheInterceptor)) {
            File cacheFile = httpConfig.getCacheFolder() != null && httpConfig.getCacheFolder().isDirectory() ? httpConfig.getCacheFolder() : FileUtil.getDirectory(FileUtil.getExternalCacheDir((Context)application), "retrofit_http_cache");
            Cache cache = new Cache(cacheFile, httpConfig.getCacheSize() > 0 ? (long)httpConfig.getCacheSize() : 0x1400000L);
            builder.addInterceptor((Interceptor)cacheInterceptor);
            builder.addNetworkInterceptor((Interceptor)cacheInterceptor);
            builder.cache(cache);
        }
        if (httpConfig.isUseCookie()) {
            if (httpConfig.isCookiePersistent()) {
                PersistentCookieJar cookieJar = new PersistentCookieJar(new SetCookieCache(), new SharedPrefsCookiePersistor((Context)application));
                builder.cookieJar((CookieJar)cookieJar);
            } else {
                CookieManager cookieManager = new CookieManager();
                cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
                builder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager));
            }
        }
        headerInterceptor.setMapHeader(httpConfig.getMapHeader());
        if (!builder.interceptors().contains(headerInterceptor)) {
            builder.addInterceptor((Interceptor)headerInterceptor);
        }
        if (!builder.interceptors().contains(progressInterceptor)) {
            builder.addNetworkInterceptor((Interceptor)progressInterceptor);
        }
        return builder.build();
    }

    @Singleton
    @Provides
    OkHttpClient.Builder okClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Singleton
    @Provides
    HttpCacheInterceptor httpCacheInterceptor(Application application, HttpConfig httpConfig) {
        return new HttpCacheInterceptor((Context)application, httpConfig.getCacheTimeWithNet(), httpConfig.getCacheTimeWithoutNet());
    }

    @Provides
    SimpleArrayMap<String, List<WeakReference<ProgressListener>>> listeners() {
        return new SimpleArrayMap();
    }

    @Singleton
    @Provides
    SimpleArrayMap<String, SpCache> spCaches() {
        return new SimpleArrayMap();
    }

    @Singleton
    @Provides
    SimpleArrayMap<String, DiskCache> diskCaches() {
        return new SimpleArrayMap();
    }

    @Singleton
    @Provides
    MemoryCache memoryCache() {
        return new MemoryCache();
    }
}

