/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http;

import dagger.Lazy;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

@Singleton
public class HttpConfig {
    @Inject
    Lazy<OkHttpClient.Builder> mOkHttpClientBuilder;
    @Inject
    Lazy<Retrofit.Builder> mRetrofitBuilder;
    private String mBaseUrl;
    private int mConnectTimeout;
    private boolean mIsUseLog;
    private boolean mIsUseCache;
    private File mCacheFolder;
    private int mCacheSize;
    private int mCacheTimeWithNet;
    private int mCacheTimeWithoutNet;
    private Map<String, String> mMapHeader;
    private boolean mIsUseRetryWhenError;
    private int mTimeRetryDelay = -1;
    private int mMaxRetryCount;
    private boolean mIsCookiePersistent;
    private boolean mIsUseCookie;

    @Inject
    public HttpConfig() {
    }

    public String getBaseUrl() {
        return this.mBaseUrl == null ? "" : this.mBaseUrl;
    }

    public HttpConfig setBaseUrl(String baseUrl) {
        this.mBaseUrl = baseUrl;
        return this;
    }

    public int getConnectTimeout() {
        return this.mConnectTimeout;
    }

    public HttpConfig setConnectTimeout(int connectTimeout) {
        this.mConnectTimeout = connectTimeout;
        return this;
    }

    public boolean isUseLog() {
        return this.mIsUseLog;
    }

    public HttpConfig setIsUseLog(boolean useLog) {
        this.mIsUseLog = useLog;
        return this;
    }

    public boolean isUseCache() {
        return this.mIsUseCache;
    }

    public HttpConfig setIsUseCache(boolean useCache) {
        this.mIsUseCache = useCache;
        return this;
    }

    public File getCacheFolder() {
        return this.mCacheFolder;
    }

    public HttpConfig setCacheFolder(File cacheFolder) {
        this.mCacheFolder = cacheFolder;
        return this;
    }

    public int getCacheSize() {
        return this.mCacheSize;
    }

    public HttpConfig setCacheSize(int cacheSize) {
        this.mCacheSize = cacheSize;
        return this;
    }

    public int getCacheTimeWithNet() {
        return this.mCacheTimeWithNet;
    }

    public HttpConfig setCacheTimeWithNet(int cacheTimeWithNet) {
        this.mCacheTimeWithNet = cacheTimeWithNet;
        return this;
    }

    public int getCacheTimeWithoutNet() {
        return this.mCacheTimeWithoutNet;
    }

    public HttpConfig setCacheTimeWithoutNet(int cacheTimeWithoutNet) {
        this.mCacheTimeWithoutNet = cacheTimeWithoutNet;
        return this;
    }

    public Map<String, String> getMapHeader() {
        return this.mMapHeader;
    }

    public HttpConfig setMapHeader(Map<String, String> mapHeader) {
        this.mMapHeader = mapHeader;
        return this;
    }

    public boolean isUseRetryWhenError() {
        return this.mIsUseRetryWhenError;
    }

    public HttpConfig setIsUseRetryWhenError(boolean useRetryWhenError) {
        this.mIsUseRetryWhenError = useRetryWhenError;
        return this;
    }

    public int getTimeRetryDelay() {
        return this.mTimeRetryDelay;
    }

    public HttpConfig setTimeRetryDelay(int timeRetryDelay) {
        this.mTimeRetryDelay = timeRetryDelay;
        return this;
    }

    public int getMaxRetryCount() {
        return this.mMaxRetryCount;
    }

    public HttpConfig setMaxRetryCount(int maxRetryCount) {
        this.mMaxRetryCount = maxRetryCount;
        return this;
    }

    public boolean isCookiePersistent() {
        return this.mIsCookiePersistent;
    }

    public HttpConfig setIsCookiePersistent(boolean isCookiePersistent) {
        this.mIsCookiePersistent = isCookiePersistent;
        return this;
    }

    public boolean isUseCookie() {
        return this.mIsUseCookie;
    }

    public HttpConfig setIsUseCookie(boolean mIsUseCookie) {
        this.mIsUseCookie = mIsUseCookie;
        return this;
    }

    public OkHttpClient.Builder getOkHttpClientBuilder() {
        return (OkHttpClient.Builder)this.mOkHttpClientBuilder.get();
    }

    public Retrofit.Builder getRetrofitBuilder() {
        return (Retrofit.Builder)this.mRetrofitBuilder.get();
    }
}

