/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.github.zackratos.ultimatebar.UltimateBar;
import com.ljy.devring.util.ConfigUtil;

public class KeyboardUtil {
    public static void fixInput(final Activity activity, final boolean isFullScreen) {
        final boolean[] isKeyboardShowed = new boolean[]{false};
        final View viewRoot = ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        final Rect rectRootView = new Rect();
        final int[] location = new int[2];
        int screenHeight = 0;
        if (activity.getResources().getConfiguration().orientation == 2) {
            screenHeight = ConfigUtil.getScreenShortSide((Context)activity);
        } else if (activity.getResources().getConfiguration().orientation == 1) {
            screenHeight = ConfigUtil.getScreenLongSide((Context)activity);
        }
        final int finalScreenHeight = screenHeight;
        final int statusbarHeight = ConfigUtil.getStatusBarHeight((Context)activity);
        final int navigationBarHeight = ConfigUtil.getNavigationBarHeight((Context)activity);
        viewRoot.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                viewRoot.getWindowVisibleDisplayFrame(rectRootView);
                View view = activity.getCurrentFocus();
                if (view != null) {
                    view.getLocationInWindow(location);
                }
                int invisibleHeight = viewRoot.getHeight() - rectRootView.bottom;
                if (!isKeyboardShowed[0] && invisibleHeight > finalScreenHeight / 3) {
                    isKeyboardShowed[0] = true;
                    int editTextBottom = location[1];
                    if (view != null) {
                        editTextBottom = location[1] + view.getHeight();
                    }
                    if (rectRootView.bottom < editTextBottom) {
                        int scrollHeight = editTextBottom + 10 - rectRootView.bottom;
                        viewRoot.setTranslationY(viewRoot.getTranslationY() - (float)scrollHeight);
                    }
                } else if (isKeyboardShowed[0] && invisibleHeight <= navigationBarHeight + statusbarHeight) {
                    isKeyboardShowed[0] = false;
                    viewRoot.setTranslationY(0.0f);
                    if (isFullScreen) {
                        UltimateBar.Companion.with(activity).applyNavigation(true).create().hideBar();
                    }
                }
            }
        });
    }

    public static void toggleKeyboard(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.toggleSoftInput(0, 2);
    }

    public static void showKeyboard(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm != null) {
            view.requestFocus();
            imm.showSoftInput(view, 0);
        }
    }

    public static void hideKeyboard(View view) {
        InputMethodManager inputmanger = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (inputmanger != null) {
            inputmanger.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static boolean handleKeyboardHide(Activity activity, MotionEvent event, View ... viewNotHide) {
        if (event.getAction() == 1) {
            for (int i = 0; i < viewNotHide.length; ++i) {
                View viewCheck = viewNotHide[i];
                if (!viewCheck.isClickable() || !KeyboardUtil.isViewTouch(viewCheck, event)) continue;
                return false;
            }
            View viewFocus = activity.getCurrentFocus();
            if (viewFocus != null && viewFocus instanceof EditText) {
                if (KeyboardUtil.isViewTouch(viewFocus, event)) {
                    return false;
                }
                KeyboardUtil.hideKeyboard(viewFocus);
                return true;
            }
        }
        return false;
    }

    public static boolean isViewTouch(View view, MotionEvent event) {
        int x = (int)event.getRawX();
        int y = (int)event.getRawY();
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getMeasuredWidth();
        int bottom = top + view.getMeasuredHeight();
        return y >= top && y <= bottom && x >= left && x <= right;
    }
}

