/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.other;

import android.app.Activity;
import com.ljy.devring.other.permission.PermissionListener;
import com.tbruyelle.rxpermissions2.Permission;
import com.tbruyelle.rxpermissions2.RxPermissions;
import io.reactivex.functions.Consumer;

public class PermissionManager {
    public void requestEach(Activity activity, final PermissionListener listener, String ... permissions) {
        if (activity != null) {
            RxPermissions rxPermissions = new RxPermissions(activity);
            rxPermissions.requestEach(permissions).subscribe((Consumer)new Consumer<Permission>(){

                public void accept(Permission permission) throws Exception {
                    if (permission.granted) {
                        if (listener != null) {
                            listener.onGranted(permission.name);
                        }
                    } else if (permission.shouldShowRequestPermissionRationale) {
                        if (listener != null) {
                            listener.onDenied(permission.name);
                        }
                    } else if (listener != null) {
                        listener.onDeniedWithNeverAsk(permission.name);
                    }
                }
            });
        }
    }

    public void requestEachCombined(Activity activity, final PermissionListener listener, String ... permissions) {
        if (activity != null) {
            RxPermissions rxPermissions = new RxPermissions(activity);
            rxPermissions.requestEachCombined(permissions).subscribe((Consumer)new Consumer<Permission>(){

                public void accept(Permission permission) throws Exception {
                    if (permission.granted) {
                        if (listener != null) {
                            listener.onGranted(permission.name);
                        }
                    } else if (permission.shouldShowRequestPermissionRationale) {
                        if (listener != null) {
                            listener.onDenied(permission.name);
                        }
                    } else if (listener != null) {
                        listener.onDeniedWithNeverAsk(permission.name);
                    }
                }
            });
        }
    }
}

