/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http;

import android.text.TextUtils;
import com.ljy.devring.cache.support.MemoryCache;
import com.ljy.devring.http.HttpConfig;
import com.ljy.devring.http.support.RetryFunction;
import com.ljy.devring.http.support.body.ProgressListener;
import com.ljy.devring.http.support.interceptor.HttpProgressInterceptor;
import com.ljy.devring.http.support.observer.DownloadObserver;
import com.ljy.devring.http.support.observer.UploadObserver;
import com.ljy.devring.util.FileUtil;
import com.trello.rxlifecycle2.LifecycleTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Retrofit;

@Singleton
public class HttpManager {
    @Inject
    HttpProgressInterceptor mProgressInterceptor;
    @Inject
    Retrofit mRetrofit;
    @Inject
    MemoryCache mMemoryCache;
    @Inject
    HttpConfig mHttpConfig;

    @Inject
    public HttpManager() {
    }

    public <T> T getService(Class<T> serviceClass) {
        Object service = this.mMemoryCache.get(serviceClass.getCanonicalName());
        if (service == null) {
            service = this.mRetrofit.create(serviceClass);
            this.mMemoryCache.put(serviceClass.getCanonicalName(), service);
        }
        return (T)service;
    }

    public void commonRequest(Observable observable, Observer observer, LifecycleTransformer transformer) {
        this.handleRetry(this.handleThread(this.handleLife(observable, transformer)), this.mHttpConfig.isUseRetryWhenError(), this.mHttpConfig.getTimeRetryDelay(), this.mHttpConfig.getMaxRetryCount()).subscribe(observer);
    }

    public void commonRequest(Observable observable, Observer observer, LifecycleTransformer transformer, int timeRetryDelay, int maxRetryCount) {
        this.handleRetry(this.handleThread(this.handleLife(observable, transformer)), true, timeRetryDelay, maxRetryCount).subscribe(observer);
    }

    public void uploadRequest(Observable observable, UploadObserver uploadObserver, LifecycleTransformer transformer) {
        if (!TextUtils.isEmpty((CharSequence)uploadObserver.getUploadUrl())) {
            if (TextUtils.isEmpty((CharSequence)uploadObserver.getQualifier())) {
                this.addRequestListener(uploadObserver.getUploadUrl(), uploadObserver);
            } else {
                this.addDiffRequestListenerOnSameUrl(uploadObserver.getUploadUrl(), uploadObserver.getQualifier(), uploadObserver);
            }
        }
        this.handleThread(this.handleLife(observable, transformer)).subscribe((Observer)uploadObserver);
    }

    public void downloadRequest(File fileSave, Observable observable, DownloadObserver downloadObserver, LifecycleTransformer transformer) {
        if (!TextUtils.isEmpty((CharSequence)downloadObserver.getDownloadUrl())) {
            if (TextUtils.isEmpty((CharSequence)downloadObserver.getQualifier())) {
                this.addResponseListener(downloadObserver.getDownloadUrl(), downloadObserver);
            } else {
                this.addDiffResponseListenerOnSameUrl(downloadObserver.getDownloadUrl(), downloadObserver.getQualifier(), downloadObserver);
            }
        }
        this.handleThreadForDownload(fileSave, this.handleLife(observable, transformer), downloadObserver).subscribe((Observer)downloadObserver);
    }

    private Observable handleLife(Observable observable, LifecycleTransformer transformer) {
        if (transformer != null) {
            observable.compose((ObservableTransformer)transformer);
        }
        return observable;
    }

    private Observable handleThread(Observable observable) {
        return observable.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Observable handleThreadForDownload(final File fileSave, Observable observable, final DownloadObserver downloadObserver) {
        return observable.observeOn(Schedulers.io()).doOnNext((Consumer)new Consumer<ResponseBody>(){

            public void accept(ResponseBody body) throws Exception {
                boolean isSuccess = FileUtil.saveFile(body.byteStream(), new FileOutputStream(fileSave));
                downloadObserver.setResult(isSuccess, fileSave.getAbsolutePath());
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Observable handleRetry(Observable observable, boolean isUseRetry, int timeRetryDelay, int maxRetryCount) {
        if (isUseRetry) {
            return observable.retryWhen((Function)new RetryFunction(timeRetryDelay >= 0 ? timeRetryDelay : 3, maxRetryCount > 0 ? maxRetryCount : 3));
        }
        return observable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestListener(String url, ProgressListener listener) {
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            LinkedList<WeakReference<ProgressListener>> progressListeners = (LinkedList<WeakReference<ProgressListener>>)this.mProgressInterceptor.getRequestListeners().get((Object)url);
            if (progressListeners == null) {
                progressListeners = new LinkedList<WeakReference<ProgressListener>>();
                this.mProgressInterceptor.getRequestListeners().put((Object)url, progressListeners);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (!this.isListenerExist(progressListeners, listener)) {
                progressListeners.add(new WeakReference<ProgressListener>(listener));
            }
            return;
        }
    }

    public String addDiffRequestListenerOnSameUrl(String originUrl, String qualifier, ProgressListener listener) {
        String newUrl = originUrl + "?DevRing=" + qualifier;
        this.addRequestListener(newUrl, listener);
        return newUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseListener(String url, ProgressListener listener) {
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            LinkedList<WeakReference<ProgressListener>> progressListeners = (LinkedList<WeakReference<ProgressListener>>)this.mProgressInterceptor.getResponseListeners().get((Object)url);
            if (progressListeners == null) {
                progressListeners = new LinkedList<WeakReference<ProgressListener>>();
                this.mProgressInterceptor.getResponseListeners().put((Object)url, progressListeners);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (!this.isListenerExist(progressListeners, listener)) {
                progressListeners.add(new WeakReference<ProgressListener>(listener));
            }
            return;
        }
    }

    public String addDiffResponseListenerOnSameUrl(String originUrl, String qualifier, ProgressListener listener) {
        String newUrl = originUrl + "?DevRing=" + qualifier;
        this.addResponseListener(newUrl, listener);
        return newUrl;
    }

    private boolean isListenerExist(List<WeakReference<ProgressListener>> progressListeners, ProgressListener listener) {
        Iterator<WeakReference<ProgressListener>> iterator = progressListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<ProgressListener> progressListener = iterator.next();
            if (progressListener.get() == null) {
                iterator.remove();
                continue;
            }
            if (!((ProgressListener)progressListener.get()).equals(listener)) continue;
            return true;
        }
        return false;
    }

    public Map<String, RequestBody> getRequestBodyMap(Map<String, File> map, MediaType mediaType) {
        HashMap<String, RequestBody> bodyMap = new HashMap<String, RequestBody>();
        for (Map.Entry<String, File> entry : map.entrySet()) {
            bodyMap.put(entry.getKey() + "\"; filename=\"" + entry.getValue().getName(), RequestBody.create((MediaType)mediaType, (File)entry.getValue()));
        }
        return bodyMap;
    }
}

