/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.other;

import android.app.Activity;
import com.ljy.devring.util.CollectionUtil;
import java.util.Stack;

public class ActivityStackManager {
    private Stack<Activity> mActivityStack;

    public void pushOneActivity(Activity activity) {
        if (activity == null) {
            return;
        }
        if (this.mActivityStack == null) {
            this.mActivityStack = new Stack();
        }
        this.mActivityStack.push(activity);
    }

    public void popOneActivity(Activity activity) {
        if (activity == null || CollectionUtil.isEmpty(this.mActivityStack)) {
            return;
        }
        this.mActivityStack.removeElementAt(this.mActivityStack.lastIndexOf(activity));
    }

    public Activity currentActivity() {
        Activity activity = null;
        if (!CollectionUtil.isEmpty(this.mActivityStack)) {
            activity = this.mActivityStack.peek();
        }
        return activity;
    }

    public Activity firstActivity() {
        Activity activity = null;
        if (!CollectionUtil.isEmpty(this.mActivityStack)) {
            activity = (Activity)this.mActivityStack.firstElement();
        }
        return activity;
    }

    public int getStackSize() {
        if (this.mActivityStack != null) {
            return this.mActivityStack.size();
        }
        return 0;
    }

    public void exitActivity(Activity activity) {
        activity.finish();
    }

    public void exitActivity(Class cls) {
        if (CollectionUtil.isEmpty(this.mActivityStack)) {
            return;
        }
        for (Activity activity : this.mActivityStack) {
            if (activity == null || !activity.getClass().equals(cls)) continue;
            this.exitActivity(activity);
        }
    }

    public void exitActivityFirstIn(Class cls) {
        if (CollectionUtil.isEmpty(this.mActivityStack)) {
            return;
        }
        for (Activity activity : this.mActivityStack) {
            if (activity == null || !activity.getClass().equals(cls)) continue;
            this.exitActivity(activity);
            break;
        }
    }

    public void exitActivityLastIn(Class cls) {
        if (CollectionUtil.isEmpty(this.mActivityStack)) {
            return;
        }
        int size = this.mActivityStack.size();
        for (int i = size - 1; i >= 0; --i) {
            Activity activity = (Activity)this.mActivityStack.get(i);
            if (activity == null || !activity.getClass().equals(cls)) continue;
            this.exitActivity(activity);
            break;
        }
    }

    public void exitAllActivityExceptThis(Class cls) {
        Activity activity;
        while ((activity = this.firstActivity()) != null) {
            if (activity.getClass().equals(cls)) {
                if (this.getStackSize() > 1) continue;
                break;
            }
            this.exitActivity(activity);
        }
    }

    public void exitApplication() {
        Activity activity;
        while ((activity = this.firstActivity()) != null) {
            this.exitActivity(activity);
        }
    }
}

