/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support.body;

import android.os.Handler;
import android.os.SystemClock;
import com.ljy.devring.http.support.body.ProgressInfo;
import com.ljy.devring.http.support.body.ProgressListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProgressRequestBody
extends RequestBody {
    protected Handler mHandler;
    protected int mRefreshTime;
    protected final RequestBody mDelegate;
    protected final WeakReference<ProgressListener>[] mListeners;
    protected final ProgressInfo mProgressInfo;
    private BufferedSink mBufferedSink;

    public ProgressRequestBody(Handler handler, RequestBody delegate, List<WeakReference<ProgressListener>> listeners, int refreshTime) {
        this.mDelegate = delegate;
        this.mListeners = listeners.toArray(new WeakReference[listeners.size()]);
        this.mHandler = handler;
        this.mRefreshTime = refreshTime;
        this.mProgressInfo = new ProgressInfo(System.currentTimeMillis());
    }

    public MediaType contentType() {
        return this.mDelegate.contentType();
    }

    public long contentLength() {
        try {
            return this.mDelegate.contentLength();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.mBufferedSink == null) {
            this.mBufferedSink = Okio.buffer((Sink)new CountingSink((Sink)sink));
        }
        try {
            this.mDelegate.writeTo(this.mBufferedSink);
            this.mBufferedSink.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            for (int i = 0; i < this.mListeners.length; ++i) {
                if (this.mListeners[i].get() == null) continue;
                ((ProgressListener)this.mListeners[i].get()).onProgressError(this.mProgressInfo.getId(), e);
            }
            throw e;
        }
    }

    protected final class CountingSink
    extends ForwardingSink {
        private long totalBytesRead;
        private long lastRefreshTime;
        private long tempSize;

        public CountingSink(Sink delegate) {
            super(delegate);
            this.totalBytesRead = 0L;
            this.lastRefreshTime = 0L;
            this.tempSize = 0L;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            long curTime;
            try {
                super.write(source, byteCount);
            }
            catch (IOException e) {
                e.printStackTrace();
                for (int i = 0; i < ProgressRequestBody.this.mListeners.length; ++i) {
                    if (ProgressRequestBody.this.mListeners[i].get() == null) continue;
                    ((ProgressListener)ProgressRequestBody.this.mListeners[i].get()).onProgressError(ProgressRequestBody.this.mProgressInfo.getId(), e);
                }
                throw e;
            }
            if (ProgressRequestBody.this.mProgressInfo.getContentLength() == 0L) {
                ProgressRequestBody.this.mProgressInfo.setContentLength(ProgressRequestBody.this.contentLength());
            }
            this.totalBytesRead += byteCount;
            this.tempSize += byteCount;
            if (ProgressRequestBody.this.mListeners != null && ((curTime = SystemClock.elapsedRealtime()) - this.lastRefreshTime >= (long)ProgressRequestBody.this.mRefreshTime || this.totalBytesRead == ProgressRequestBody.this.mProgressInfo.getContentLength())) {
                final long finalTempSize = this.tempSize;
                final long finalTotalBytesRead = this.totalBytesRead;
                final long finalIntervalTime = curTime - this.lastRefreshTime;
                for (int i = 0; i < ProgressRequestBody.this.mListeners.length; ++i) {
                    final ProgressListener listener = (ProgressListener)ProgressRequestBody.this.mListeners[i].get();
                    ProgressRequestBody.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ProgressRequestBody.this.mProgressInfo.setEachBytes(finalTempSize);
                            ProgressRequestBody.this.mProgressInfo.setCurrentbytes(finalTotalBytesRead);
                            ProgressRequestBody.this.mProgressInfo.setIntervalTime(finalIntervalTime);
                            ProgressRequestBody.this.mProgressInfo.setFinish(finalTotalBytesRead == ProgressRequestBody.this.mProgressInfo.getContentLength());
                            if (listener != null) {
                                listener.onProgress(ProgressRequestBody.this.mProgressInfo);
                            }
                        }
                    });
                }
                this.lastRefreshTime = curTime;
                this.tempSize = 0L;
            }
        }
    }
}

