/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support.body;

import android.os.Parcel;
import android.os.Parcelable;

public class ProgressInfo
implements Parcelable {
    private long currentBytes;
    private long contentLength;
    private long intervalTime;
    private long eachBytes;
    private long id;
    private boolean finish;
    public static final Parcelable.Creator<ProgressInfo> CREATOR = new Parcelable.Creator<ProgressInfo>(){

        public ProgressInfo createFromParcel(Parcel source) {
            return new ProgressInfo(source);
        }

        public ProgressInfo[] newArray(int size) {
            return new ProgressInfo[size];
        }
    };

    public ProgressInfo(long id) {
        this.id = id;
    }

    void setCurrentbytes(long currentbytes) {
        this.currentBytes = currentbytes;
    }

    void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    void setIntervalTime(long intervalTime) {
        this.intervalTime = intervalTime;
    }

    void setEachBytes(long eachBytes) {
        this.eachBytes = eachBytes;
    }

    void setFinish(boolean finish) {
        this.finish = finish;
    }

    public long getCurrentbytes() {
        return this.currentBytes;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getIntervalTime() {
        return this.intervalTime;
    }

    public long getEachBytes() {
        return this.eachBytes;
    }

    public long getId() {
        return this.id;
    }

    public boolean isFinish() {
        return this.finish;
    }

    public int getPercent() {
        if (this.getCurrentbytes() <= 0L || this.getContentLength() <= 0L) {
            return 0;
        }
        return (int)(100L * this.getCurrentbytes() / this.getContentLength());
    }

    public long getSpeed() {
        if (this.getEachBytes() <= 0L || this.getIntervalTime() <= 0L) {
            return 0L;
        }
        return this.getEachBytes() * 1000L / this.getIntervalTime();
    }

    public String toString() {
        return "ProgressInfo{id=" + this.id + ", currentBytes=" + this.currentBytes + ", contentLength=" + this.contentLength + ", eachBytes=" + this.eachBytes + ", intervalTime=" + this.intervalTime + ", finish=" + this.finish + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.currentBytes);
        dest.writeLong(this.contentLength);
        dest.writeLong(this.intervalTime);
        dest.writeLong(this.eachBytes);
        dest.writeLong(this.id);
        dest.writeByte(this.finish ? (byte)1 : 0);
    }

    protected ProgressInfo(Parcel in) {
        this.currentBytes = in.readLong();
        this.contentLength = in.readLong();
        this.intervalTime = in.readLong();
        this.eachBytes = in.readLong();
        this.id = in.readLong();
        this.finish = in.readByte() != 0;
    }
}

