/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.base.activity;

import android.app.Activity;
import android.os.Bundle;
import com.ljy.devring.DevRing;
import com.ljy.devring.base.activity.IActivityLife;
import com.ljy.devring.base.activity.IBaseActivity;
import com.trello.rxlifecycle2.android.ActivityEvent;
import io.reactivex.subjects.PublishSubject;

public class ActivityLife
implements IActivityLife {
    private Activity mActivity;
    private final PublishSubject<ActivityEvent> mLifecycleSubject = PublishSubject.create();

    @Override
    public void onCreate(Activity activity, Bundle savedInstanceState) {
        this.mActivity = activity;
        this.mLifecycleSubject.onNext((Object)ActivityEvent.CREATE);
        DevRing.activityStackManager().pushOneActivity(this.mActivity);
        if (((IBaseActivity)this.mActivity).isUseEventBus()) {
            DevRing.busManager().register(this.mActivity);
        }
    }

    @Override
    public void onStart() {
        this.mLifecycleSubject.onNext((Object)ActivityEvent.START);
    }

    @Override
    public void onResume() {
        this.mLifecycleSubject.onNext((Object)ActivityEvent.RESUME);
    }

    @Override
    public void onPause() {
        this.mLifecycleSubject.onNext((Object)ActivityEvent.PAUSE);
    }

    @Override
    public void onStop() {
        this.mLifecycleSubject.onNext((Object)ActivityEvent.STOP);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    }

    @Override
    public void onDestroy() {
        this.mLifecycleSubject.onNext((Object)ActivityEvent.DESTROY);
        DevRing.activityStackManager().popOneActivity(this.mActivity);
        if (((IBaseActivity)this.mActivity).isUseEventBus()) {
            DevRing.busManager().unregister(this.mActivity);
        }
        this.mActivity = null;
    }

    public PublishSubject<ActivityEvent> getLifecycleSubject() {
        return this.mLifecycleSubject;
    }
}

