/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support.observer;

import com.ljy.devring.http.support.ExceptionHandler;
import com.ljy.devring.http.support.body.ProgressListener;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import okhttp3.ResponseBody;

public abstract class DownloadObserver
implements Observer<ResponseBody>,
ProgressListener {
    private boolean mIsFileSaveSuccess;
    private String mFilePath;
    private String mDownloadUrl;
    private String mQualifier;

    public DownloadObserver() {
    }

    public DownloadObserver(String downloadUrl) {
        this.mDownloadUrl = downloadUrl;
    }

    public DownloadObserver(String downloadUrl, String qualifier) {
        this.mDownloadUrl = downloadUrl;
        this.mQualifier = qualifier;
    }

    public String getDownloadUrl() {
        return this.mDownloadUrl;
    }

    public String getQualifier() {
        return this.mQualifier;
    }

    public void onSubscribe(Disposable d) {
    }

    public void onComplete() {
    }

    public void onError(Throwable e) {
        if (e instanceof Exception) {
            ExceptionHandler.ResponseThrowable responseThrowable = ExceptionHandler.handleException(e);
            this.onError(0L, responseThrowable.message);
        } else {
            ExceptionHandler.ResponseThrowable responseThrowable = new ExceptionHandler.ResponseThrowable(e, 1000);
            this.onError(0L, responseThrowable.message);
        }
    }

    @Override
    public void onProgressError(long id, Exception e) {
        ExceptionHandler.ResponseThrowable responseThrowable = ExceptionHandler.handleException(e);
        this.onError(id, responseThrowable.message);
    }

    public void onNext(ResponseBody responseBody) {
        this.onResult(this.mIsFileSaveSuccess, this.mFilePath);
    }

    public void setResult(boolean isFileSaveSuccess, String filePath) {
        this.mIsFileSaveSuccess = isFileSaveSuccess;
        this.mFilePath = filePath;
    }

    public abstract void onResult(boolean var1, String var2);

    public abstract void onError(long var1, String var3);
}

