/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support.observer;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.ljy.devring.http.support.ExceptionHandler;
import com.ljy.devring.http.support.body.ProgressListener;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public abstract class UploadObserver<T>
implements Observer<T>,
ProgressListener {
    private String mUploadUrl;
    private String mQualifier;

    public UploadObserver() {
    }

    public UploadObserver(@NonNull String uploadUrl) {
        this.mUploadUrl = uploadUrl;
    }

    public UploadObserver(@NonNull String uploadUrl, @Nullable String qualifier) {
        this.mUploadUrl = uploadUrl;
        this.mQualifier = qualifier;
    }

    public String getUploadUrl() {
        return this.mUploadUrl;
    }

    public String getQualifier() {
        return this.mQualifier;
    }

    public void onSubscribe(Disposable d) {
    }

    public void onComplete() {
    }

    public void onNext(T t) {
        this.onResult(t);
    }

    public void onError(Throwable e) {
        if (e instanceof Exception) {
            ExceptionHandler.ResponseThrowable responseThrowable = ExceptionHandler.handleException(e);
            this.onError(0L, responseThrowable.message);
        } else {
            ExceptionHandler.ResponseThrowable responseThrowable = new ExceptionHandler.ResponseThrowable(e, 1000);
            this.onError(0L, responseThrowable.message);
        }
    }

    @Override
    public void onProgressError(long id, Exception e) {
        ExceptionHandler.ResponseThrowable responseThrowable = ExceptionHandler.handleException(e);
        this.onError(id, responseThrowable.message);
    }

    public abstract void onResult(T var1);

    public abstract void onError(long var1, String var3);
}

