/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support.interceptor;

import android.content.Context;
import com.ljy.devring.util.NetworkUtil;
import java.io.IOException;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HttpCacheInterceptor
implements Interceptor {
    private Context mContext;
    private int mCacheTimeWithNet;
    private int mCacheTimeWithoutNet;

    public HttpCacheInterceptor(Context context, int cacheTimeWithNet, int cacheTimeWithoutNet) {
        this.mContext = context;
        this.mCacheTimeWithNet = cacheTimeWithNet;
        this.mCacheTimeWithoutNet = cacheTimeWithoutNet;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (!NetworkUtil.isNetWorkAvailable(this.mContext)) {
            request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
        }
        Response response = chain.proceed(request);
        if (NetworkUtil.isNetWorkAvailable(this.mContext)) {
            int maxAge = this.mCacheTimeWithNet > 0 ? this.mCacheTimeWithNet : 60;
            String cacheControl = "public,max-age=" + maxAge;
            return response.newBuilder().header("Cache-Control", cacheControl).removeHeader("Pragma").build();
        }
        int maxStale = this.mCacheTimeWithoutNet > 0 ? this.mCacheTimeWithoutNet : 604800;
        return response.newBuilder().header("Cache-Control", "public,only-if-cached,max-stale=" + maxStale).removeHeader("Pragma").build();
    }
}

