/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.ljy.devring.other.RingLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    private static final String TAG = FileUtil.class.getSimpleName();

    public static boolean isSDCardAvailable() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception e) {
            RingLog.e(TAG, "isSDCardAvailable : SD\u5361\u4e0d\u53ef\u7528!", e);
            return false;
        }
    }

    public static File getDirectory(String parentDirectory, String directory) {
        if (TextUtils.isEmpty((CharSequence)parentDirectory) || TextUtils.isEmpty((CharSequence)directory)) {
            return null;
        }
        File file = new File(parentDirectory, directory);
        boolean flag = !file.exists() ? file.mkdir() : true;
        return flag ? file : null;
    }

    public static File getDirectory(File parentDirectory, String directory) {
        if (parentDirectory == null || TextUtils.isEmpty((CharSequence)directory)) {
            return null;
        }
        File file = new File(parentDirectory, directory);
        boolean flag = !file.exists() ? file.mkdir() : true;
        return flag ? file : null;
    }

    public static File getFile(String catalogPath, String name) {
        boolean flag;
        if (TextUtils.isEmpty((CharSequence)catalogPath) || TextUtils.isEmpty((CharSequence)name)) {
            Log.e((String)TAG, (String)"getFile : \u521b\u5efa\u5931\u8d25, \u6587\u4ef6\u76ee\u5f55\u6216\u6587\u4ef6\u540d\u4e3a\u7a7a, \u8bf7\u68c0\u67e5!");
            return null;
        }
        File file = new File(catalogPath, name);
        if (!file.exists()) {
            try {
                flag = file.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("getFile : \u521b\u5efa" + catalogPath + "\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6" + name + "\u6587\u4ef6\u5931\u8d25!"), (Throwable)e);
                flag = false;
            }
        } else {
            flag = true;
        }
        return flag ? file : null;
    }

    public static File getFile(File catalog, String name) {
        boolean flag;
        if (catalog == null || TextUtils.isEmpty((CharSequence)name)) {
            Log.e((String)TAG, (String)"getFile : \u521b\u5efa\u5931\u8d25, \u6587\u4ef6\u76ee\u5f55\u6216\u6587\u4ef6\u540d\u4e3a\u7a7a, \u8bf7\u68c0\u67e5!");
            return null;
        }
        File file = new File(catalog, name);
        if (!file.exists()) {
            try {
                flag = file.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("getFile : \u521b\u5efa" + catalog + "\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6" + name + "\u6587\u4ef6\u5931\u8d25!"), (Throwable)e);
                flag = false;
            }
        } else {
            flag = true;
        }
        return flag ? file : null;
    }

    public static File getFile(String filePath) {
        boolean flag;
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            Log.e((String)TAG, (String)"getFile : \u521b\u5efa\u5931\u8d25, \u6587\u4ef6\u76ee\u5f55\u6216\u6587\u4ef6\u540d\u4e3a\u7a7a, \u8bf7\u68c0\u67e5!");
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                flag = file.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("getFile : \u521b\u5efa" + file.getName() + "\u6587\u4ef6\u5931\u8d25!"), (Throwable)e);
                flag = false;
            }
        } else {
            flag = true;
        }
        return flag ? file : null;
    }

    public static long calculateFileSize(File file) {
        File[] files;
        if (file == null) {
            return 0L;
        }
        if (!file.exists()) {
            return 0L;
        }
        long result = 0L;
        if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                if (subFile.isDirectory()) {
                    result += FileUtil.calculateFileSize(subFile);
                    continue;
                }
                result += subFile.length();
            }
        }
        return result += file.length();
    }

    public static boolean deleteFile(File file) {
        File[] files;
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        boolean result = true;
        if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                if (subFile.isDirectory()) {
                    if (FileUtil.deleteFile(subFile)) continue;
                    result = false;
                    continue;
                }
                if (subFile.delete()) continue;
                result = false;
            }
        }
        if (!file.delete()) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File source, File target) {
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            int read;
            inputStream = new FileInputStream(source);
            outputStream = new FileOutputStream(target);
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
            outputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                outputStream.close();
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(InputStream inputStream, OutputStream outputStream) {
        boolean bl;
        if (inputStream == null || outputStream == null) {
            return false;
        }
        try {
            int read;
            byte[] buffer = new byte[4096];
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            outputStream.flush();
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    return false;
                }
            }
            inputStream.close();
            outputStream.close();
            return bl2;
        }
        inputStream.close();
        outputStream.close();
        return bl;
    }

    public static String getDataDirectory() {
        return Environment.getDataDirectory().getAbsolutePath();
    }

    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static String getRootDirectory() {
        return Environment.getRootDirectory().getAbsolutePath();
    }

    public static String getDownloadCacheDirectory() {
        return Environment.getDownloadCacheDirectory().getAbsolutePath();
    }

    public static String getExternalStoragePublicDirectory(String type) {
        File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_ALARMS);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    public static String getCacheDir(Context context) {
        return context.getCacheDir().getAbsolutePath();
    }

    public static String getFilesDir(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    public static String getExternalCacheDir(Context context) {
        return context.getExternalCacheDir().getAbsolutePath();
    }

    public static String getExternalFilesDir(Context context, String type) {
        File file = context.getExternalFilesDir(Environment.DIRECTORY_ALARMS);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }
}

