/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support;

import android.net.ParseException;
import com.google.gson.JsonParseException;
import java.net.ConnectException;
import javax.net.ssl.SSLHandshakeException;
import org.json.JSONException;
import retrofit2.HttpException;

public class ExceptionHandler {
    private static final int UNAUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int REQUEST_TIMEOUT = 408;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final int GATEWAY_TIMEOUT = 504;

    public static ResponseThrowable handleException(Throwable e) {
        if (e instanceof HttpException) {
            HttpException httpException = (HttpException)e;
            ResponseThrowable responseThrowable = new ResponseThrowable(e, 1003);
            switch (httpException.code()) {
                default: 
            }
            responseThrowable.code = httpException.code();
            responseThrowable.message = "\u7f51\u7edc\u9519\u8bef";
            return responseThrowable;
        }
        if (e instanceof ServerException) {
            ServerException resultException = (ServerException)e;
            ResponseThrowable responseThrowable = new ResponseThrowable(resultException, resultException.code);
            responseThrowable.message = resultException.message;
            return responseThrowable;
        }
        if (e instanceof JsonParseException || e instanceof JSONException || e instanceof ParseException) {
            ResponseThrowable responseThrowable = new ResponseThrowable(e, 1001);
            responseThrowable.message = "\u89e3\u6790\u9519\u8bef";
            return responseThrowable;
        }
        if (e instanceof ConnectException) {
            ResponseThrowable responseThrowable = new ResponseThrowable(e, 1002);
            responseThrowable.message = "\u8fde\u63a5\u5931\u8d25";
            return responseThrowable;
        }
        if (e instanceof SSLHandshakeException) {
            ResponseThrowable responseThrowable = new ResponseThrowable(e, 1005);
            responseThrowable.message = "\u8bc1\u4e66\u9a8c\u8bc1\u5931\u8d25";
            return responseThrowable;
        }
        ResponseThrowable responseThrowable = new ResponseThrowable(e, 1000);
        responseThrowable.message = "\u672a\u77e5\u9519\u8bef";
        return responseThrowable;
    }

    class ServerException
    extends RuntimeException {
        int code;
        String message;

        ServerException() {
        }
    }

    public static class ResponseThrowable
    extends Exception {
        public int code;
        public String message;

        public ResponseThrowable(Throwable throwable, int code) {
            super(throwable);
            this.code = code;
        }
    }

    public class ERROR {
        public static final int UNKNOWN = 1000;
        public static final int PARSE_ERROR = 1001;
        public static final int CONNECT_ERROR = 1002;
        public static final int HTTP_ERROR = 1003;
        public static final int SSL_ERROR = 1005;
    }
}

