/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.http.support.throwable;

import android.net.ParseException;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.ljy.devring.http.support.throwable.HttpThrowable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import org.json.JSONException;
import retrofit2.HttpException;

public class ThrowableHandler {
    public static HttpThrowable handleThrowable(Throwable throwable) {
        if (throwable instanceof HttpException) {
            return new HttpThrowable(1005, "\u7f51\u7edc(\u534f\u8bae)\u9519\u8bef", throwable);
        }
        if (throwable instanceof JsonParseException || throwable instanceof JSONException || throwable instanceof ParseException) {
            return new HttpThrowable(1001, "\u89e3\u6790\u9519\u8bef", throwable);
        }
        if (throwable instanceof UnknownHostException) {
            return new HttpThrowable(1003, "DNS\u89e3\u6790\u9519\u8bef(\u65e0\u7f51\u7edc)", throwable);
        }
        if (throwable instanceof SocketTimeoutException) {
            return new HttpThrowable(1004, "\u8fde\u63a5\u8d85\u65f6\u9519\u8bef", throwable);
        }
        if (throwable instanceof ConnectException) {
            return new HttpThrowable(1002, "\u8fde\u63a5\u9519\u8bef", throwable);
        }
        if (throwable instanceof SSLHandshakeException) {
            return new HttpThrowable(1006, "\u8bc1\u4e66\u9a8c\u8bc1\u9519\u8bef", throwable);
        }
        return new HttpThrowable(1000, throwable.getMessage(), throwable);
    }

    public static <T> T fromJson(Throwable throwable, Class<T> clazz) {
        HttpException httpException = (HttpException)throwable;
        Gson gson = new Gson();
        Object t = null;
        try {
            t = gson.fromJson(httpException.response().errorBody().string(), clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)t;
    }
}

