/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkUtil {
    public static final int INVALID_NETWORK_TYPE = -1;
    public static final int MOBILE_NETWORK_TYPE = 0;
    public static final int WIFI_NETWORK_TYPE = 1;

    public static boolean isNetWorkAvailable(Context context) {
        NetworkInfo[] netInfos;
        boolean hasWifoCon = false;
        boolean hasMobileCon = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        for (NetworkInfo net : netInfos = cm.getAllNetworkInfo()) {
            String type = net.getTypeName();
            if (type.equalsIgnoreCase("WIFI") && net.isConnected()) {
                hasWifoCon = true;
            }
            if (!type.equalsIgnoreCase("MOBILE") || !net.isConnected()) continue;
            hasMobileCon = true;
        }
        return hasWifoCon || hasMobileCon;
    }

    public static int getNetWorkType(Context context) {
        NetworkInfo mNetworkInfo = null;
        if (context != null) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
        }
        return mNetworkInfo != null && mNetworkInfo.isAvailable() ? mNetworkInfo.getType() : -1;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
    }

    public static boolean isMobileConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 0;
    }

    public static String getAPNType(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return null;
        }
        if (networkInfo.getExtraInfo() == null) {
            return null;
        }
        return networkInfo.getExtraInfo().toLowerCase();
    }
}

