/*
 * Decompiled with CFR 0.152.
 */
package com.ljy.devring.cache;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Process;
import android.support.v4.util.SimpleArrayMap;
import com.ljy.devring.cache.CacheConfig;
import com.ljy.devring.cache.support.DiskCache;
import com.ljy.devring.cache.support.MemoryCache;
import com.ljy.devring.cache.support.SpCache;
import com.ljy.devring.util.FileUtil;
import dagger.Lazy;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CacheManager {
    private static final long DEFAULT_DISK_CACHE_MAX_SIZE = Long.MAX_VALUE;
    private static final int DEFAULT_DISK_CACHE_MAX_COUNT = Integer.MAX_VALUE;
    private static final String DEFAULT_SP_NAME = "default_sp_name_";
    @Inject
    Application mContext;
    @Inject
    CacheConfig mCacheConfig;
    @Inject
    SimpleArrayMap<String, SpCache> mMapSpCache;
    @Inject
    SimpleArrayMap<String, DiskCache> mMapDiskCache;
    @Inject
    Lazy<MemoryCache> mMemoryCache;

    @Inject
    public CacheManager() {
    }

    public DiskCache diskCache(String cacheName) {
        File cacheDir;
        String cacheKey;
        DiskCache cache;
        if (this.isSpace(cacheName)) {
            cacheName = "cache_default";
        }
        if ((cache = (DiskCache)this.mMapDiskCache.get((Object)(cacheKey = (cacheDir = this.mCacheConfig.getDiskCacheFolder() != null && this.mCacheConfig.getDiskCacheFolder().isDirectory() ? new File(this.mCacheConfig.getDiskCacheFolder(), cacheName) : new File(FileUtil.getCacheDir((Context)this.mContext), cacheName)).getAbsoluteFile() + "_" + Process.myPid()))) == null) {
            long maxSize = this.mCacheConfig.getDiskCacheMaxSize() > 0 ? (long)this.mCacheConfig.getDiskCacheMaxSize() : Long.MAX_VALUE;
            int maxCount = this.mCacheConfig.getDiskCacheMaxCount() > 0 ? this.mCacheConfig.getDiskCacheMaxCount() : Integer.MAX_VALUE;
            cache = new DiskCache((Context)this.mContext, cacheDir, maxSize, maxCount);
            this.mMapDiskCache.put((Object)cacheKey, (Object)cache);
        }
        return cache;
    }

    private boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public MemoryCache memoryCache() {
        return (MemoryCache)this.mMemoryCache.get();
    }

    public SpCache spCache() {
        return this.spCache(DEFAULT_SP_NAME, 0);
    }

    public SpCache spCache(int mode) {
        return this.spCache(DEFAULT_SP_NAME, mode);
    }

    public SpCache spCache(String spName) {
        return this.spCache(spName, 0);
    }

    public SpCache spCache(String spName, int mode) {
        SpCache spCache = (SpCache)this.mMapSpCache.get((Object)(DEFAULT_SP_NAME + mode));
        if (spCache == null) {
            SharedPreferences defaultSp = this.mContext.getSharedPreferences(spName, mode);
            spCache = new SpCache(defaultSp);
            this.mMapSpCache.put((Object)(spName + mode), (Object)spCache);
        }
        return spCache;
    }
}

