/*
 * Decompiled with CFR 0.152.
 */
package com.ljx.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.ljx.view.R;

public class FontResizeView
extends View {
    private static final int DEFAULT_LINE_COLOR = Color.parseColor((String)"#222222");
    private boolean isCoincide;
    private int width;
    private int height;
    private float minSize;
    private float maxSize;
    private float standardSize;
    private String leftText;
    private String middleText;
    private String rightText;
    private int leftTextColor;
    private int middleTextColor;
    private int rightTextColor;
    private int totalGrade;
    private int standardGrade;
    private int lineColor;
    private int horizontalLineLength;
    private int verticalLineLength;
    private int lineStrokeWidth;
    private int lineAverageWidth;
    private int sliderGrade;
    private int sliderColor;
    private int sliderShadowColor;
    private Point sliderPoint;
    private Paint mPaint;
    private Line mHorizontalLine;
    private Line[] mVerticalLines;
    private GestureDetector mGestureDetector;
    private OnFontChangeListener onFontChangeListener;
    GestureDetector.SimpleOnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            FontResizeView.this.isCoincide = FontResizeView.this.sliderPoint.coincide(e.getX(), e.getY());
            FontResizeView.this.getParent().requestDisallowInterceptTouchEvent(true);
            return super.onDown(e);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            Line horizontalLine = FontResizeView.this.mHorizontalLine;
            float x = e.getX();
            if (x > horizontalLine.stopX) {
                x = horizontalLine.stopX;
            } else if (x < horizontalLine.startX) {
                x = horizontalLine.startX;
            }
            FontResizeView.this.moveSlider(x - horizontalLine.startX, true);
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            FontResizeView.this.getParent().requestDisallowInterceptTouchEvent(true);
            if (FontResizeView.this.isCoincide) {
                float x = FontResizeView.this.sliderPoint.getX();
                FontResizeView.this.setSliderPointX(x - distanceX, false);
                FontResizeView.this.postInvalidate();
                return true;
            }
            return super.onScroll(e1, e2, distanceX, distanceY);
        }
    };

    public FontResizeView(Context context) {
        this(context, null);
    }

    public FontResizeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FontResizeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int padding = this.dp2px(35.0f);
        this.setPadding(padding, padding, padding, padding);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FontResizeView);
        this.minSize = ta.getDimension(R.styleable.FontResizeView_minSize, (float)this.dp2px(15.0f));
        this.maxSize = ta.getDimension(R.styleable.FontResizeView_maxSize, (float)this.dp2px(25.0f));
        this.totalGrade = ta.getInt(R.styleable.FontResizeView_totalGrade, 6);
        this.standardGrade = ta.getInt(R.styleable.FontResizeView_standardGrade, 2);
        if (this.standardGrade < 1 || this.standardGrade > 6) {
            this.standardGrade = 1;
        }
        this.sliderGrade = this.standardGrade;
        this.leftText = ta.getString(R.styleable.FontResizeView_leftText);
        if (TextUtils.isEmpty((CharSequence)this.leftText)) {
            this.leftText = "A";
        }
        this.middleText = ta.getString(R.styleable.FontResizeView_middleText);
        if (TextUtils.isEmpty((CharSequence)this.middleText)) {
            this.middleText = context.getString(R.string.font_resize_standard);
        }
        this.rightText = ta.getString(R.styleable.FontResizeView_rightText);
        if (TextUtils.isEmpty((CharSequence)this.rightText)) {
            this.rightText = "A";
        }
        this.leftTextColor = ta.getColor(R.styleable.FontResizeView_leftTextColor, -16777216);
        this.middleTextColor = ta.getColor(R.styleable.FontResizeView_middleTextColor, -16777216);
        this.rightTextColor = ta.getColor(R.styleable.FontResizeView_rightTextColor, -16777216);
        this.lineColor = ta.getColor(R.styleable.FontResizeView_lineColor, DEFAULT_LINE_COLOR);
        this.lineStrokeWidth = ta.getDimensionPixelOffset(R.styleable.FontResizeView_lineStrokeWidth, this.dp2px(0.5f));
        this.horizontalLineLength = ta.getDimensionPixelOffset(R.styleable.FontResizeView_horizontalLineLength, -1);
        this.verticalLineLength = ta.getDimensionPixelOffset(R.styleable.FontResizeView_verticalLineLength, -1);
        this.sliderColor = ta.getColor(R.styleable.FontResizeView_sliderColor, -1);
        this.sliderShadowColor = ta.getColor(R.styleable.FontResizeView_sliderShadowColor, -7829368);
        float sliderRadius = ta.getDimension(R.styleable.FontResizeView_sliderRadius, (float)this.dp2px(25.0f));
        ta.recycle();
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.width = this.getResources().getDisplayMetrics().widthPixels;
        this.height = this.dp2px(140.0f);
        this.standardSize = (this.maxSize - this.minSize) / (float)(this.totalGrade - 1) * (float)(this.standardGrade - 1) + this.minSize;
        this.mHorizontalLine = new Line();
        this.mVerticalLines = new Line[this.totalGrade];
        for (int i = 0; i < this.mVerticalLines.length; ++i) {
            this.mVerticalLines[i] = new Line();
        }
        this.sliderPoint = new Point(sliderRadius);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.gestureListener);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int specWidthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int specWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int specHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (specWidthMode) {
            case -2147483648: 
            case 0: {
                this.width = Math.min(this.width, specWidthSize);
                break;
            }
            case 0x40000000: {
                this.width = specWidthSize;
            }
        }
        switch (specHeightMode) {
            case -2147483648: 
            case 0: {
                this.height = Math.min(this.height, specHeightSize);
                break;
            }
            case 0x40000000: {
                this.height = specHeightSize;
            }
        }
        this.setMeasuredDimension(this.width, this.height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.horizontalLineLength == -1) {
            this.horizontalLineLength = w - this.getPaddingLeft() - this.getPaddingRight();
        }
        if (this.verticalLineLength == -1) {
            this.verticalLineLength = this.dp2px(10.0f);
        }
        this.lineAverageWidth = this.horizontalLineLength / (this.totalGrade - 1);
        int horizontalLineStartX = (this.width - this.horizontalLineLength) / 2;
        int horizontalLineStartY = (int)((double)this.height * 0.6);
        this.mHorizontalLine.set(horizontalLineStartX, horizontalLineStartY, horizontalLineStartX + this.horizontalLineLength, horizontalLineStartY);
        float lineAverageWidth = (float)this.horizontalLineLength * 1.0f / (float)(this.totalGrade - 1);
        Line[] verticalLines = this.mVerticalLines;
        for (int i = 0; i < verticalLines.length; ++i) {
            float startX = (float)horizontalLineStartX + lineAverageWidth * (float)i;
            verticalLines[i].set(startX, (float)horizontalLineStartY - (float)this.verticalLineLength / 2.0f, startX, (float)horizontalLineStartY + (float)this.verticalLineLength / 2.0f);
        }
        this.sliderPoint.setGrade(this.sliderGrade - 1);
        this.setSliderPointX(verticalLines[this.sliderGrade - 1].startX, true);
        this.sliderPoint.setY(verticalLines[this.sliderGrade - 1].startY + verticalLines[this.sliderGrade - 1].getHeight() / 2.0f);
    }

    protected void onDraw(Canvas canvas) {
        Line horizontalLine = this.mHorizontalLine;
        this.mPaint.setColor(this.lineColor);
        this.mPaint.setStrokeWidth((float)this.lineStrokeWidth);
        canvas.drawLine(horizontalLine.startX, horizontalLine.startY, horizontalLine.stopX, horizontalLine.stopY, this.mPaint);
        for (Line line : this.mVerticalLines) {
            canvas.drawLine(line.startX, line.startY, line.stopX, line.stopY, this.mPaint);
        }
        this.mPaint.setColor(this.leftTextColor);
        this.mPaint.setTextSize(this.minSize);
        float width = this.mPaint.measureText(this.leftText);
        float startY = horizontalLine.startY - (float)this.dp2px(20.0f);
        canvas.drawText(this.leftText, horizontalLine.startX - width / 2.0f, startY, this.mPaint);
        this.mPaint.setColor(this.rightTextColor);
        this.mPaint.setTextSize(this.maxSize);
        width = this.mPaint.measureText(this.rightText);
        canvas.drawText(this.rightText, horizontalLine.stopX - width / 2.0f, startY, this.mPaint);
        this.mPaint.setColor(this.middleTextColor);
        this.mPaint.setTextSize(this.standardSize);
        width = this.mPaint.measureText(this.middleText);
        float startX = this.mVerticalLines[this.standardGrade - 1].startX - width / 2.0f;
        if (this.standardGrade == 1 || this.standardGrade == this.totalGrade) {
            startY -= (float)this.dp2px(7.0f) + this.standardSize;
        }
        canvas.drawText(this.middleText, startX, startY, this.mPaint);
        this.mPaint.setColor(this.sliderColor);
        float radius = this.sliderPoint.getRadius();
        this.mPaint.setShadowLayer(10.0f, 2.0f, 2.0f, this.sliderShadowColor);
        canvas.drawCircle(this.sliderPoint.getX(), this.sliderPoint.getY(), radius, this.mPaint);
        this.mPaint.setShadowLayer(0.0f, 0.0f, 0.0f, this.sliderShadowColor);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        if (event.getAction() == 1 && this.isCoincide) {
            float x = this.sliderPoint.getX() - this.mHorizontalLine.startX;
            this.moveSlider(x, false);
        }
        return true;
    }

    private void moveSlider(float destX, final boolean isClick) {
        int grade = (int)destX / this.lineAverageWidth;
        float remainder = destX % (float)this.lineAverageWidth;
        if (remainder > (float)(this.lineAverageWidth / 2)) {
            ++grade;
        }
        final int tempGrade = grade;
        int gradeDiffer = Math.abs(this.sliderPoint.getGrade() - tempGrade);
        if (gradeDiffer == 0) {
            if (isClick) {
                return;
            }
            gradeDiffer = 1;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.sliderPoint.getX(), this.mVerticalLines[tempGrade].startX});
        animator.setDuration((long)(100 + gradeDiffer * 30));
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Float value = (Float)animation.getAnimatedValue();
                FontResizeView.this.setSliderPointX(value.floatValue(), isClick);
                FontResizeView.this.postInvalidate();
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FontResizeView.this.setSliderPointX(((FontResizeView)FontResizeView.this).mVerticalLines[tempGrade].startX, false);
            }
        });
        animator.start();
    }

    private void setSliderPointX(float x, boolean onlySetX) {
        int newGrade;
        float horizontalLineStartX = this.mHorizontalLine.startX;
        float horizontalLineStopX = this.mHorizontalLine.stopX;
        if (x < horizontalLineStartX) {
            x = horizontalLineStartX;
        } else if (x > horizontalLineStopX) {
            x = horizontalLineStopX;
        }
        this.sliderPoint.setX(x);
        if (onlySetX) {
            return;
        }
        int oldGrade = this.sliderPoint.getGrade();
        if (oldGrade == (newGrade = (int)(x - horizontalLineStartX) / this.lineAverageWidth)) {
            return;
        }
        this.sliderPoint.setGrade(newGrade);
        if (this.onFontChangeListener != null) {
            float size = (this.maxSize - this.minSize) / (float)(this.totalGrade - 1);
            float sp = (this.minSize + size * (float)newGrade) / this.getResources().getDisplayMetrics().scaledDensity;
            this.onFontChangeListener.onFontChange(sp);
        }
    }

    public float getFontSize() {
        float size = (this.maxSize - this.minSize) / (float)(this.totalGrade - 1);
        return (this.minSize + size * (float)(this.sliderGrade - 1)) / this.getResources().getDisplayMetrics().scaledDensity;
    }

    public void setFontSize(float fontSize) {
        int grade = (int)(((fontSize *= this.getResources().getDisplayMetrics().scaledDensity) - this.minSize) / ((this.maxSize - this.minSize) / (float)(this.totalGrade - 1))) + 1;
        this.setSliderGrade(grade);
    }

    public void setSliderGrade(int grade) {
        if (grade < 0) {
            grade = 1;
        }
        if (grade > this.totalGrade) {
            grade = this.totalGrade;
        }
        this.sliderGrade = grade;
    }

    private int dp2px(float dipValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public void setOnFontChangeListener(OnFontChangeListener onFontChangeListener) {
        this.onFontChangeListener = onFontChangeListener;
    }

    class Line {
        float startX;
        float startY;
        float stopX;
        float stopY;

        Line() {
        }

        void set(float startX, float startY, float stopX, float stopY) {
            this.startX = startX;
            this.startY = startY;
            this.stopX = stopX;
            this.stopY = stopY;
        }

        float getHeight() {
            return Math.abs(this.stopY - this.startY);
        }
    }

    class Point {
        float x;
        float y;
        float radius;
        int grade;

        Point(float radius) {
            this.radius = radius;
        }

        float getX() {
            return this.x;
        }

        void setX(float x) {
            this.x = x;
        }

        float getY() {
            return this.y;
        }

        void setY(float y) {
            this.y = y;
        }

        float getRadius() {
            return this.radius;
        }

        int getGrade() {
            return this.grade;
        }

        void setGrade(int grade) {
            this.grade = grade;
        }

        boolean coincide(float movingX, float movingY) {
            return Math.sqrt((this.x - movingX) * (this.x - movingX) + (this.y - movingY) * (this.y - movingY)) < (double)(this.radius + (float)FontResizeView.this.dp2px(20.0f));
        }
    }

    public static interface OnFontChangeListener {
        public void onFontChange(float var1);
    }
}

