/*
 * Decompiled with CFR 0.152.
 */
package com.liyu.sqlitetoexcel;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelToSQLite {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private Context mContext;
    private String dataBaseName;
    private SQLiteDatabase database;
    private String filePath;
    private String assetFileName;
    private String decryptKey;
    private String dateFormat;
    private SimpleDateFormat sdf;

    private ExcelToSQLite(Context context, String dataBaseName, String filePath, String assetFileName, String decryptKey, String dateFormat) {
        this.mContext = context;
        this.filePath = filePath;
        this.assetFileName = assetFileName;
        this.decryptKey = decryptKey;
        this.dataBaseName = dataBaseName;
        this.dateFormat = dateFormat;
        if (!TextUtils.isEmpty((CharSequence)dateFormat)) {
            this.sdf = new SimpleDateFormat(dateFormat);
        }
        try {
            this.database = SQLiteDatabase.openOrCreateDatabase((String)dataBaseName, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean start() {
        if (TextUtils.isEmpty((CharSequence)this.filePath) && TextUtils.isEmpty((CharSequence)this.assetFileName)) {
            throw new IllegalArgumentException("Asset file or external file name must not be null.");
        }
        try {
            if (TextUtils.isEmpty((CharSequence)this.filePath)) {
                return this.importTables(this.mContext.getAssets().open(this.assetFileName), this.assetFileName);
            }
            return this.importTables(new FileInputStream(this.filePath), this.filePath);
        }
        catch (Exception e) {
            if (this.database != null && this.database.isOpen()) {
                this.database.close();
            }
            return false;
        }
    }

    public void start(final ImportListener listener) {
        if (TextUtils.isEmpty((CharSequence)this.filePath) && TextUtils.isEmpty((CharSequence)this.assetFileName)) {
            throw new IllegalArgumentException("Asset file or external file name must not be null.");
        }
        if (listener != null) {
            listener.onStart();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        if (TextUtils.isEmpty((CharSequence)ExcelToSQLite.this.filePath)) {
                            ExcelToSQLite.this.importTables(ExcelToSQLite.this.mContext.getAssets().open(ExcelToSQLite.this.assetFileName), ExcelToSQLite.this.assetFileName);
                        } else {
                            ExcelToSQLite.this.importTables(new FileInputStream(ExcelToSQLite.this.filePath), ExcelToSQLite.this.filePath);
                        }
                        if (listener != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(ExcelToSQLite.this.dataBaseName);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (ExcelToSQLite.this.database != null && ExcelToSQLite.this.database.isOpen()) {
                            ExcelToSQLite.this.database.close();
                        }
                        if (listener == null) break block6;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onError(e);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    private boolean importTables(InputStream stream, String fileName) throws Exception {
        if (fileName.toLowerCase().endsWith(".xls")) {
            if (!TextUtils.isEmpty((CharSequence)this.decryptKey)) {
                Biff8EncryptionKey.setCurrentUserPassword((String)"1234567");
            }
        } else {
            throw new UnsupportedOperationException("Unsupported file format!");
        }
        HSSFWorkbook workbook = new HSSFWorkbook(stream);
        stream.close();
        int sheetNumber = workbook.getNumberOfSheets();
        for (int i = 0; i < sheetNumber; ++i) {
            this.createTable(workbook.getSheetAt(i));
        }
        this.database.close();
        return true;
    }

    private void createTable(Sheet sheet) {
        StringBuilder createTableSql = new StringBuilder("CREATE TABLE IF NOT EXISTS ");
        createTableSql.append(sheet.getSheetName());
        createTableSql.append("(");
        Iterator rit = sheet.rowIterator();
        Row rowHeader = (Row)rit.next();
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < rowHeader.getPhysicalNumberOfCells(); ++i) {
            createTableSql.append(rowHeader.getCell(i).getStringCellValue());
            if (i == rowHeader.getPhysicalNumberOfCells() - 1) {
                createTableSql.append(" TEXT");
            } else {
                createTableSql.append(" TEXT,");
            }
            columns.add(rowHeader.getCell(i).getStringCellValue());
        }
        createTableSql.append(")");
        this.database.execSQL(createTableSql.toString());
        while (rit.hasNext()) {
            long result;
            Row row = (Row)rit.next();
            ContentValues values = new ContentValues();
            for (int n = 0; n < row.getPhysicalNumberOfCells(); ++n) {
                if (row.getCell(n) == null) continue;
                if (row.getCell(n).getCellType() == 0) {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)row.getCell(n))) {
                        if (this.sdf == null) {
                            values.put((String)columns.get(n), DateFormat.getDateTimeInstance().format(row.getCell(n).getDateCellValue()));
                            continue;
                        }
                        values.put((String)columns.get(n), this.sdf.format(row.getCell(n).getDateCellValue()));
                        continue;
                    }
                    String value = ExcelToSQLite.getRealStringValueOfDouble(row.getCell(n).getNumericCellValue());
                    values.put((String)columns.get(n), value);
                    continue;
                }
                if (row.getCell(n).getCellType() != 1) continue;
                values.put((String)columns.get(n), row.getCell(n).getStringCellValue());
            }
            if (values.size() == 0 || (result = this.database.insert(sheet.getSheetName(), null, values)) >= 0L) continue;
            throw new RuntimeException("Insert value failed!");
        }
    }

    private static String getRealStringValueOfDouble(Double d) {
        String doubleStr = d.toString();
        boolean b = doubleStr.contains("E");
        int indexOfPoint = doubleStr.indexOf(46);
        if (b) {
            int indexOfE = doubleStr.indexOf(69);
            BigInteger xs = new BigInteger(doubleStr.substring(indexOfPoint + BigInteger.ONE.intValue(), indexOfE));
            int pow = Integer.valueOf(doubleStr.substring(indexOfE + BigInteger.ONE.intValue()));
            int xsLen = xs.toByteArray().length;
            int scale = xsLen - pow > 0 ? xsLen - pow : 0;
            doubleStr = String.format("%." + scale + "f", d);
        } else {
            Pattern p = Pattern.compile(".0$");
            Matcher m = p.matcher(doubleStr);
            if (m.find()) {
                doubleStr = doubleStr.replace(".0", "");
            }
        }
        return doubleStr;
    }

    public static interface ImportListener {
        public void onStart();

        public void onCompleted(String var1);

        public void onError(Exception var1);
    }

    public static class Builder {
        private Context context;
        private String dataBaseName;
        private String filePath;
        private String assetFileName;
        private String decryptKey;
        private String dateFormat;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        public ExcelToSQLite build() {
            if (TextUtils.isEmpty((CharSequence)this.dataBaseName)) {
                throw new IllegalArgumentException("Database name must not be null.");
            }
            return new ExcelToSQLite(this.context, this.dataBaseName, this.filePath, this.assetFileName, this.decryptKey, this.dateFormat);
        }

        public Builder setDataBase(String dataBaseName) {
            this.dataBaseName = dataBaseName;
            return this;
        }

        public Builder setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder setFilePath(String path) {
            this.filePath = path;
            this.assetFileName = null;
            if (TextUtils.isEmpty((CharSequence)this.dataBaseName)) {
                this.dataBaseName = this.context.getDatabasePath(new File(path).getName() + ".db").getAbsolutePath();
            }
            return this;
        }

        public Builder setDecryptKey(String decryptKey) {
            this.decryptKey = decryptKey;
            return this;
        }

        public Builder setAssetFileName(String name) {
            this.assetFileName = name;
            this.filePath = null;
            if (TextUtils.isEmpty((CharSequence)this.dataBaseName)) {
                this.dataBaseName = this.context.getDatabasePath(new File(name).getName() + ".db").getPath();
            }
            return this;
        }

        public void start() {
            ExcelToSQLite excelToSqlite = this.build();
            excelToSqlite.start();
        }

        public void start(ImportListener listener) {
            ExcelToSQLite excelToSqlite = this.build();
            excelToSqlite.start(listener);
        }
    }
}

