/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.async;

import com.fasterxml.aalto.AsyncInputFeeder;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.ByteBasedScanner;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.CharsetNames;
import com.fasterxml.aalto.util.DataUtil;
import java.io.IOException;
import org.apache.poi.javax.xml.stream.XMLStreamException;

public abstract class AsyncByteScanner
extends ByteBasedScanner
implements AsyncInputFeeder {
    protected static final int EVENT_INCOMPLETE = 257;
    protected static final int STATE_DEFAULT = 0;
    protected static final int STATE_PROLOG_INITIAL = 1;
    protected static final int STATE_PROLOG_SEEN_LT = 2;
    protected static final int STATE_PROLOG_DECL = 3;
    protected static final int STATE_TREE_SEEN_LT = 1;
    protected static final int STATE_TREE_SEEN_AMP = 2;
    protected static final int STATE_TREE_SEEN_EXCL = 3;
    protected static final int STATE_TREE_SEEN_SLASH = 4;
    protected static final int STATE_TREE_NUMERIC_ENTITY_START = 5;
    protected static final int STATE_TREE_NAMED_ENTITY_START = 6;
    protected static final int STATE_XMLDECL_AFTER_XML = 1;
    protected static final int STATE_XMLDECL_BEFORE_VERSION = 2;
    protected static final int STATE_XMLDECL_VERSION = 3;
    protected static final int STATE_XMLDECL_AFTER_VERSION = 4;
    protected static final int STATE_XMLDECL_VERSION_EQ = 5;
    protected static final int STATE_XMLDECL_VERSION_VALUE = 6;
    protected static final int STATE_XMLDECL_AFTER_VERSION_VALUE = 7;
    protected static final int STATE_XMLDECL_BEFORE_ENCODING = 8;
    protected static final int STATE_XMLDECL_ENCODING = 9;
    protected static final int STATE_XMLDECL_AFTER_ENCODING = 10;
    protected static final int STATE_XMLDECL_ENCODING_EQ = 11;
    protected static final int STATE_XMLDECL_ENCODING_VALUE = 12;
    protected static final int STATE_XMLDECL_AFTER_ENCODING_VALUE = 13;
    protected static final int STATE_XMLDECL_BEFORE_STANDALONE = 14;
    protected static final int STATE_XMLDECL_STANDALONE = 15;
    protected static final int STATE_XMLDECL_AFTER_STANDALONE = 16;
    protected static final int STATE_XMLDECL_STANDALONE_EQ = 17;
    protected static final int STATE_XMLDECL_STANDALONE_VALUE = 18;
    protected static final int STATE_XMLDECL_AFTER_STANDALONE_VALUE = 19;
    protected static final int STATE_XMLDECL_ENDQ = 20;
    protected static final int STATE_DTD_DOCTYPE = 1;
    protected static final int STATE_DTD_AFTER_DOCTYPE = 2;
    protected static final int STATE_DTD_BEFORE_ROOT_NAME = 3;
    protected static final int STATE_DTD_ROOT_NAME = 4;
    protected static final int STATE_DTD_AFTER_ROOT_NAME = 5;
    protected static final int STATE_DTD_BEFORE_IDS = 6;
    protected static final int STATE_DTD_PUBLIC_OR_SYSTEM = 7;
    protected static final int STATE_DTD_AFTER_PUBLIC = 8;
    protected static final int STATE_DTD_AFTER_SYSTEM = 9;
    protected static final int STATE_DTD_BEFORE_PUBLIC_ID = 10;
    protected static final int STATE_DTD_PUBLIC_ID = 11;
    protected static final int STATE_DTD_AFTER_PUBLIC_ID = 12;
    protected static final int STATE_DTD_BEFORE_SYSTEM_ID = 13;
    protected static final int STATE_DTD_SYSTEM_ID = 14;
    protected static final int STATE_DTD_AFTER_SYSTEM_ID = 15;
    protected static final int STATE_DTD_INT_SUBSET = 16;
    protected static final int STATE_DTD_EXPECT_CLOSING_GT = 50;
    protected static final int STATE_TEXT_AMP = 4;
    protected static final int STATE_TEXT_AMP_NAME = 6;
    protected static final int STATE_COMMENT_CONTENT = 1;
    protected static final int STATE_COMMENT_HYPHEN = 2;
    protected static final int STATE_COMMENT_HYPHEN2 = 3;
    protected static final int STATE_CDATA_CONTENT = 1;
    protected static final int STATE_CDATA_C = 2;
    protected static final int STATE_CDATA_CD = 3;
    protected static final int STATE_CDATA_CDA = 4;
    protected static final int STATE_CDATA_CDAT = 5;
    protected static final int STATE_CDATA_CDATA = 6;
    protected static final int STATE_PI_AFTER_TARGET = 1;
    protected static final int STATE_PI_AFTER_TARGET_WS = 2;
    protected static final int STATE_PI_AFTER_TARGET_QMARK = 3;
    protected static final int STATE_PI_IN_TARGET = 4;
    protected static final int STATE_PI_IN_DATA = 5;
    protected static final int STATE_SE_ELEM_NAME = 1;
    protected static final int STATE_SE_SPACE_OR_END = 2;
    protected static final int STATE_SE_SPACE_OR_ATTRNAME = 3;
    protected static final int STATE_SE_ATTR_NAME = 4;
    protected static final int STATE_SE_SPACE_OR_EQ = 5;
    protected static final int STATE_SE_SPACE_OR_ATTRVALUE = 6;
    protected static final int STATE_SE_ATTR_VALUE_NORMAL = 7;
    protected static final int STATE_SE_ATTR_VALUE_NSDECL = 8;
    protected static final int STATE_SE_SEEN_SLASH = 9;
    protected static final int STATE_EE_NEED_GT = 1;
    protected static final int PENDING_STATE_CR = -1;
    protected static final int PENDING_STATE_XMLDECL_LT = -5;
    protected static final int PENDING_STATE_XMLDECL_LTQ = -6;
    protected static final int PENDING_STATE_XMLDECL_TARGET = -7;
    protected static final int PENDING_STATE_PI_QMARK = -15;
    protected static final int PENDING_STATE_COMMENT_HYPHEN1 = -20;
    protected static final int PENDING_STATE_COMMENT_HYPHEN2 = -21;
    protected static final int PENDING_STATE_CDATA_BRACKET1 = -30;
    protected static final int PENDING_STATE_CDATA_BRACKET2 = -31;
    protected static final int PENDING_STATE_ENT_SEEN_HASH = -70;
    protected static final int PENDING_STATE_ENT_SEEN_HASH_X = -71;
    protected static final int PENDING_STATE_ENT_IN_DEC_DIGIT = -72;
    protected static final int PENDING_STATE_ENT_IN_HEX_DIGIT = -73;
    protected static final int PENDING_STATE_ATTR_VALUE_AMP = -60;
    protected static final int PENDING_STATE_ATTR_VALUE_AMP_HASH = -61;
    protected static final int PENDING_STATE_ATTR_VALUE_AMP_HASH_X = -62;
    protected static final int PENDING_STATE_ATTR_VALUE_ENTITY_NAME = -63;
    protected static final int PENDING_STATE_ATTR_VALUE_DEC_DIGIT = -64;
    protected static final int PENDING_STATE_ATTR_VALUE_HEX_DIGIT = -65;
    protected static final int PENDING_STATE_TEXT_AMP = -80;
    protected static final int PENDING_STATE_TEXT_AMP_HASH = -81;
    protected static final int PENDING_STATE_TEXT_DEC_ENTITY = -82;
    protected static final int PENDING_STATE_TEXT_HEX_ENTITY = -83;
    protected static final int PENDING_STATE_TEXT_IN_ENTITY = -84;
    protected static final int PENDING_STATE_TEXT_BRACKET1 = -85;
    protected static final int PENDING_STATE_TEXT_BRACKET2 = -86;
    protected int _nextEvent = 257;
    protected int _state;
    protected int _surroundingEvent = 257;
    protected int _pendingInput = 0;
    protected boolean _endOfInput = false;
    protected int _quadCount;
    protected int _currQuad;
    protected int _currQuadBytes = 0;
    protected int _entityValue = 0;
    protected boolean _elemAllNsBound;
    protected boolean _elemAttrCount;
    protected byte _elemAttrQuote;
    protected PName _elemAttrName;
    protected int _elemAttrPtr;
    protected int _elemNsPtr;
    protected boolean _inDtdDeclaration;

    protected AsyncByteScanner(ReaderConfig cfg) {
        super(cfg);
    }

    @Override
    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    protected void _closeSource() throws IOException {
        this._endOfInput = true;
    }

    protected void verifyAndSetXmlVersion() throws XMLStreamException {
        if (this._textBuilder.equalsString("1.0")) {
            this._config.setXmlVersion("1.0");
        } else if (this._textBuilder.equalsString("1.1")) {
            this._config.setXmlVersion("1.1");
        } else {
            this.reportInputProblem("Unrecognized XML version '" + this._textBuilder.contentsAsString() + "' (expected '1.0' or '1.1')");
        }
    }

    protected void verifyAndSetXmlEncoding() throws XMLStreamException {
        String enc = CharsetNames.normalize(this._textBuilder.contentsAsString());
        this._config.setXmlEncoding(enc);
        if ("UTF-8" != enc && "US-ASCII" != enc) {
            this.reportInputProblem("Unsupported encoding '" + enc + "': only UTF-8 and US-ASCII support by async parser");
        }
    }

    protected void verifyAndSetXmlStandalone() throws XMLStreamException {
        if (this._textBuilder.equalsString("yes")) {
            this._config.setXmlStandalone(Boolean.TRUE);
        } else if (this._textBuilder.equalsString("no")) {
            this._config.setXmlStandalone(Boolean.FALSE);
        } else {
            this.reportInputProblem("Invalid standalone value '" + this._textBuilder.contentsAsString() + "': can only use 'yes' and 'no'");
        }
    }

    protected void verifyAndSetPublicId() throws XMLStreamException {
        this._publicId = this._textBuilder.contentsAsString();
    }

    protected void verifyAndSetSystemId() throws XMLStreamException {
        this._systemId = this._textBuilder.contentsAsString();
    }

    @Override
    protected final void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                ErrorConsts.throwInternalError();
            }
        }
    }

    protected abstract int startCharacters(byte var1) throws XMLStreamException;

    protected abstract boolean handleAttrValue() throws XMLStreamException;

    protected abstract boolean handleNsDecl() throws XMLStreamException;

    @Override
    protected void finishCData() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishComment() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishDTD(boolean copyContents) throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishPI() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void finishSpace() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected abstract boolean skipCharacters() throws XMLStreamException;

    @Override
    protected void skipCData() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipComment() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipPI() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected void skipSpace() throws XMLStreamException {
        this.throwInternal();
    }

    @Override
    protected boolean loadMore() throws XMLStreamException {
        this.throwInternal();
        return false;
    }

    @Override
    protected abstract void finishCharacters() throws XMLStreamException;

    protected final PName findPName(int lastQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int qlen = this._quadCount;
        if (lastByteCount == 0) {
            lastQuad = this._quadBuffer[--qlen];
            lastByteCount = 4;
        }
        if (qlen <= 1) {
            if (qlen == 0) {
                int hash = ByteBasedPNameTable.calcHash(lastQuad);
                PName name = this._symbols.findSymbol(hash, lastQuad, 0);
                if (name == null) {
                    this._quadBuffer[0] = lastQuad;
                    name = this.addPName(hash, this._quadBuffer, 1, lastByteCount);
                }
                return name;
            }
            int firstQuad = this._quadBuffer[0];
            int hash = ByteBasedPNameTable.calcHash(firstQuad, lastQuad);
            PName name = this._symbols.findSymbol(hash, firstQuad, lastQuad);
            if (name == null) {
                this._quadBuffer[1] = lastQuad;
                name = this.addPName(hash, this._quadBuffer, 2, lastByteCount);
            }
            return name;
        }
        if (qlen >= this._quadBuffer.length) {
            this._quadBuffer = DataUtil.growArrayBy(this._quadBuffer, this._quadBuffer.length);
        }
        this._quadBuffer[qlen++] = lastQuad;
        int hash = ByteBasedPNameTable.calcHash(this._quadBuffer, qlen);
        PName name = this._symbols.findSymbol(hash, this._quadBuffer, qlen);
        if (name == null) {
            name = this.addPName(hash, this._quadBuffer, qlen, lastByteCount);
        }
        return name;
    }

    protected void verifyAndAppendEntityCharacter(int charFromEntity) throws XMLStreamException {
        this.verifyXmlChar(charFromEntity);
        if (charFromEntity >> 16 != 0) {
            this._textBuilder.append((char)(0xD800 | (charFromEntity -= 65536) >> 10));
            charFromEntity = 0xDC00 | charFromEntity & 0x3FF;
        }
        this._textBuilder.append((char)charFromEntity);
    }

    protected boolean validPublicIdChar(int c) {
        return c == 10 || c == 13 || c == 32 || c >= 64 && c <= 90 || c >= 97 && c <= 122 || c == 33 || c >= 35 && c <= 37 || c >= 39 && c <= 47 || c >= 58 && c <= 59 || c == 61 || c == 63 || c == 95;
    }

    @Override
    protected int decodeCharForError(byte b) throws XMLStreamException {
        return b;
    }

    protected void checkPITargetName(PName targetName) throws XMLStreamException {
        String ln = targetName.getLocalName();
        if (ln.length() == 3 && ln.equalsIgnoreCase("xml") && !targetName.hasPrefix()) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
    }

    protected int throwInternal() {
        throw new IllegalStateException("Internal error: should never execute this code path");
    }

    protected void reportInvalidOther(int mask, int ptr) throws XMLStreamException {
        this._inputPtr = ptr;
        this.reportInvalidOther(mask);
    }
}

