/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.widget.viewpager;

import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.liyi.viewer.widget.ImageViewerAttacher;
import com.liyi.viewer.widget.ScaleImageView;
import java.util.ArrayList;
import java.util.List;

public class PreviewAdapter
extends PagerAdapter {
    private final int INVALID_VALUE = -1;
    private int mStartPosition;
    private ScaleImageView mStartView;
    private List mImageDataList;
    private List<ScaleImageView> mActiveViews;
    private ImageViewerAttacher mAttacher;

    public PreviewAdapter(ImageViewerAttacher attacher) {
        this.mAttacher = attacher;
        this.mActiveViews = new ArrayList<ScaleImageView>();
    }

    public void setStartView(ScaleImageView itemView) {
        this.mStartPosition = itemView.getPosition();
        this.mStartView = itemView;
    }

    public void setImageData(List list) {
        this.mImageDataList = list;
    }

    public int getCount() {
        return this.mImageDataList != null ? this.mImageDataList.size() : 0;
    }

    public View instantiateItem(ViewGroup container, int position) {
        ScaleImageView itemView = null;
        if (this.mStartPosition == position) {
            itemView = this.mStartView;
            this.mActiveViews.add(itemView);
            this.mStartPosition = -1;
        } else if (this.mActiveViews != null && this.mActiveViews.size() > 0 && this.mActiveViews != null && this.mActiveViews.size() > 0) {
            int len = this.mActiveViews.size();
            for (int i = 0; i < len; ++i) {
                ScaleImageView scaleImageView = this.mActiveViews.get(i);
                if (scaleImageView.getParent() != null) continue;
                itemView = this.mAttacher.setupItemViewConfig(position, scaleImageView);
                break;
            }
        }
        if (itemView == null) {
            itemView = this.mAttacher.createItemView(position);
            this.mActiveViews.add(itemView);
        }
        container.addView((View)itemView);
        return itemView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (object != null) {
            ((ScaleImageView)((Object)object)).recycle();
        }
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public ScaleImageView getViewByPosition(int position) {
        ScaleImageView itemView = null;
        if (this.mStartPosition == -1) {
            int len = this.mActiveViews.size();
            for (int i = 0; i < len; ++i) {
                if (this.mActiveViews.get(i).getId() != position) continue;
                itemView = this.mActiveViews.get(i);
                break;
            }
        } else if (this.mStartPosition == position) {
            itemView = this.mStartView;
        }
        return itemView;
    }

    public void clear() {
        if (this.mActiveViews != null && this.mActiveViews.size() > 0) {
            int len = this.mActiveViews.size();
            for (int i = 0; i < len; ++i) {
                ScaleImageView itemView = this.mActiveViews.get(i);
                itemView.recycle();
                Object var3_3 = null;
            }
            this.mActiveViews.clear();
        }
        if (this.mStartView != null) {
            this.mStartView.recycle();
            this.mStartView = null;
        }
        this.mStartPosition = -1;
    }
}

