/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.FloatEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.github.chrisbanes.photoview.PhotoView;
import com.liyi.viewer.ImageViewerUtil;
import com.liyi.viewer.TransitionCallback;
import com.liyi.viewer.ViewData;
import com.liyi.viewer.dragger.DefaultImageDragger;
import com.liyi.viewer.dragger.ImageDragger;
import com.liyi.viewer.dragger.ImageDraggerStateListener;
import com.liyi.viewer.dragger.WxImageDragger;
import com.liyi.viewer.widget.ImageViewerAttacher;
import com.liyi.viewer.widget.progressbar.CircleProgressBar;

public class ScaleImageView
extends FrameLayout {
    private int mPosition;
    private ViewData mViewData;
    private int mDuration;
    private float mDefWidth;
    private float mDefHeight;
    private ImageDragger mImageDragger;
    private int mDragType;
    private boolean doBackgroundAlpha;
    private View progressView;
    private PhotoView imageView;
    private FrameLayout.LayoutParams mImageParams;
    private Drawable mBackground;
    private float mDownX;
    private float mDownY;
    private boolean isImageAnimRunning;
    private boolean isImageDragging;
    private boolean hasImageSize;
    private ImageDraggerStateListener mStateListener;

    public ScaleImageView(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public ScaleImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public ScaleImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mDuration = 300;
        this.isImageAnimRunning = false;
        this.isImageDragging = false;
        this.hasImageSize = false;
        this.doBackgroundAlpha = true;
        this.imageView = new PhotoView(context);
        this.imageView.setX(0.0f);
        this.imageView.setY(0.0f);
        this.mImageParams = new FrameLayout.LayoutParams(-1, -1);
        this.imageView.setLayoutParams((ViewGroup.LayoutParams)this.mImageParams);
        this.addView((View)this.imageView);
        this.initDragStateMonitor();
    }

    private void initDragStateMonitor() {
        this.mStateListener = new ImageDraggerStateListener(){

            @Override
            public void onImageDraggerState(int state) {
                switch (state) {
                    case 1: {
                        ScaleImageView.this.isImageDragging = true;
                        break;
                    }
                    case 2: {
                        ScaleImageView.this.isImageDragging = true;
                        break;
                    }
                    case 3: {
                        ScaleImageView.this.isImageAnimRunning = true;
                        ScaleImageView.this.isImageDragging = false;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        ScaleImageView.this.isImageAnimRunning = false;
                        break;
                    }
                    case 6: {
                        ScaleImageView.this.isImageAnimRunning = true;
                        ScaleImageView.this.isImageDragging = false;
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        ScaleImageView.this.isImageAnimRunning = false;
                        ScaleImageView.this.setVisibility(8);
                    }
                }
                if (ScaleImageView.this.isImageDragging || ScaleImageView.this.isImageAnimRunning) {
                    ScaleImageView.this.setScaleable(false);
                } else {
                    ScaleImageView.this.setScaleable(true);
                }
            }
        };
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean isIntercept = super.onInterceptTouchEvent(ev);
        switch (ev.getAction() & ev.getActionMasked()) {
            case 0: {
                this.mDownX = ev.getX();
                this.mDownY = ev.getY();
                break;
            }
            case 2: {
                if (ev.getPointerCount() != 1 || !(this.getScale() <= 1.0f) || this.mImageDragger == null) break;
                float diffX = ev.getX() - this.mDownX;
                float diffY = ev.getY() - this.mDownY;
                if (!(Math.abs(diffX) < Math.abs(diffY)) || this.mDragType != 1 && (this.mDragType != 2 || !(diffY > 0.0f))) break;
                this.mImageDragger.bindScaleImageView(this);
                this.mImageDragger.onReady(this.getWidth() != 0 ? (float)this.getWidth() : this.mDefWidth, this.getHeight() != 0 ? (float)this.getHeight() : this.mDefHeight);
                isIntercept = true;
            }
        }
        return isIntercept;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction() & event.getActionMasked()) {
            case 0: {
                this.onActionDown(event);
                break;
            }
            case 2: {
                this.onActionMove(event);
                break;
            }
            case 1: {
                this.onActionUp(event);
            }
        }
        return super.onTouchEvent(event);
    }

    private void onActionDown(MotionEvent event) {
        this.mDownX = event.getX();
        this.mDownY = event.getY();
    }

    private void onActionMove(MotionEvent event) {
        if (event.getPointerCount() == 1 && this.getScale() <= 1.0f && this.isImageDragging && this.mImageDragger != null) {
            this.mImageDragger.onDragging(this.mDownX, this.mDownY, event.getX(), event.getY());
        }
        this.mDownX = event.getX();
        this.mDownY = event.getY();
    }

    private void onActionUp(MotionEvent event) {
        if (this.getScale() <= 1.0f && this.isImageDragging && this.mImageDragger != null) {
            this.mImageDragger.onRelease();
        }
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
    }

    public void setDefSize(float width, float height) {
        this.mDefWidth = width;
        this.mDefHeight = height;
    }

    public void start() {
        this.start(null);
    }

    public void cancel() {
        this.cancel(null);
    }

    public void start(TransitionCallback callback) {
        this.performEnterAnim(callback);
    }

    public void cancel(TransitionCallback callback) {
        this.performExitAnim(callback);
    }

    public void setPosition(int position) {
        this.mPosition = position;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public void setViewData(ViewData data) {
        this.mViewData = data;
    }

    public ViewData getViewData() {
        return this.mViewData;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void setImageDraggerType(int type) {
        this.setImageDraggerType(type, null, this.getBackground());
    }

    public void setImageDraggerType(int type, ImageViewerAttacher attacher, Drawable background) {
        this.mDragType = type;
        if (this.mDragType == 1) {
            this.mImageDragger = new DefaultImageDragger();
        } else if (this.mDragType == 2) {
            this.mImageDragger = new WxImageDragger();
        }
        if (this.mImageDragger != null) {
            this.mImageDragger.setBackground(background);
            if (attacher != null) {
                this.mImageDragger.bindImageViewerAttacher(attacher);
            }
            this.mImageDragger.setImageDraggerStateListener(this.mStateListener);
        }
    }

    public void clearImageDragger() {
        if (this.mImageDragger != null) {
            this.mImageDragger = null;
        }
    }

    public boolean isImageDragging() {
        return this.isImageDragging;
    }

    public boolean isImageAnimRunning() {
        return this.isImageAnimRunning;
    }

    public void setScaleable(boolean scaleable) {
        this.imageView.setZoomable(scaleable);
    }

    public boolean isScaleable() {
        return this.imageView.isZoomable();
    }

    public void setScale(float scale) {
        this.imageView.setScale(scale);
    }

    public float getScale() {
        return this.imageView.getScale();
    }

    public void setMaxScale(float maxScale) {
        this.imageView.setMaximumScale(maxScale);
    }

    public float getMaxScale() {
        return this.imageView.getMaximumScale();
    }

    public void setMinScale(float minScale) {
        this.imageView.setMinimumScale(minScale);
    }

    public float getMinScale() {
        return this.imageView.getMinimumScale();
    }

    public void setDoBackgroundAlpha(boolean isDo) {
        this.doBackgroundAlpha = isDo;
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public void showProgess() {
        if (this.progressView == null) {
            CircleProgressBar progressBar = new CircleProgressBar(this.getContext(), 0x77FAFAFA);
            progressBar.setInnerRadius(ImageViewerUtil.dp2px(this.getContext(), 19.0f));
            int size = ImageViewerUtil.dp2px(this.getContext(), 60.0f);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
            lp.width = size;
            lp.height = size;
            lp.gravity = 17;
            progressBar.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.setProgressView((View)progressBar);
        }
        this.progressView.setVisibility(0);
    }

    public void hideProgress() {
        if (this.progressView != null) {
            this.progressView.setVisibility(8);
        }
    }

    public void setProgressView(View view) {
        if (this.progressView == null || this.progressView.getParent() == null) {
            this.progressView = view;
            this.progressView.setVisibility(8);
            this.addView(this.progressView);
        }
    }

    public void removeProgressView() {
        if (this.progressView != null && this.progressView.getParent() != null) {
            this.removeView(this.progressView);
            this.progressView = null;
        }
    }

    public void recycle() {
        if (this.imageView != null) {
            ImageViewerUtil.recycleImage((ImageView)this.imageView);
        }
        this.clearImageDragger();
    }

    public void setOnViewClickListener(final View.OnClickListener listener) {
        this.imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!ScaleImageView.this.isImageAnimRunning && !ScaleImageView.this.isImageDragging && listener != null) {
                    listener.onClick(v);
                }
            }
        });
    }

    public void setOnViewLongClickListener(final View.OnLongClickListener listener) {
        this.imageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (!ScaleImageView.this.isImageAnimRunning && !ScaleImageView.this.isImageDragging && listener != null) {
                    return listener.onLongClick(v);
                }
                return false;
            }
        });
    }

    private void setBackgroundAlpha(int alpha) {
        if (this.mBackground != null) {
            this.mBackground.setAlpha(alpha);
        }
    }

    private void performEnterAnim(final TransitionCallback callback) {
        float new_height;
        float new_width;
        this.isImageAnimRunning = true;
        final float previewW = this.getWidth() != 0 ? (float)this.getWidth() : this.mDefWidth;
        final float previewH = this.getHeight() != 0 ? (float)this.getHeight() : this.mDefHeight;
        final float old_width = this.mViewData.getTargetWidth();
        final float old_height = this.mViewData.getTargetHeight();
        if (this.mViewData.getImageWidth() != 0.0f && this.mViewData.getImageHeight() != 0.0f) {
            float scale = Math.min(previewW / this.mViewData.getImageWidth(), previewH / this.mViewData.getImageHeight());
            new_width = this.mViewData.getImageWidth() * scale;
            new_height = this.mViewData.getImageHeight() * scale;
            this.imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.hasImageSize = true;
        } else {
            new_width = previewW;
            new_height = previewH;
            this.hasImageSize = false;
        }
        final float from_x = this.mViewData.getTargetX();
        final float from_y = this.mViewData.getTargetY();
        final float to_x = (previewW - new_width) / 2.0f;
        final float to_y = (previewH - new_height) / 2.0f;
        if (this.doBackgroundAlpha && this.mBackground == null && this.getBackground() != null) {
            this.mBackground = this.getBackground().mutate();
        }
        this.setVisibility(0);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration((long)this.mDuration);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (callback != null) {
                    callback.onTransitionStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (ScaleImageView.this.hasImageSize) {
                    ScaleImageView.this.imageView.setX(0.0f);
                    ScaleImageView.this.imageView.setY(0.0f);
                    ((ScaleImageView)ScaleImageView.this).mImageParams.width = (int)previewW;
                    ((ScaleImageView)ScaleImageView.this).mImageParams.height = (int)previewH;
                    ScaleImageView.this.imageView.setLayoutParams((ViewGroup.LayoutParams)ScaleImageView.this.mImageParams);
                    ScaleImageView.this.imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                }
                ScaleImageView.this.isImageAnimRunning = false;
                if (callback != null) {
                    callback.onTransitionEnd();
                }
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            FloatEvaluator evaluator = new FloatEvaluator();

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = animation.getAnimatedFraction();
                float x = this.evaluator.evaluate(fraction, (Number)Float.valueOf(from_x), (Number)Float.valueOf(to_x)).floatValue();
                float y = this.evaluator.evaluate(fraction, (Number)Float.valueOf(from_y), (Number)Float.valueOf(to_y)).floatValue();
                float width = this.evaluator.evaluate(fraction, (Number)Float.valueOf(old_width), (Number)Float.valueOf(new_width)).floatValue();
                float height = this.evaluator.evaluate(fraction, (Number)Float.valueOf(old_height), (Number)Float.valueOf(new_height)).floatValue();
                ScaleImageView.this.imageView.setX(x);
                ScaleImageView.this.imageView.setY(y);
                ((ScaleImageView)ScaleImageView.this).mImageParams.width = (int)width;
                ((ScaleImageView)ScaleImageView.this).mImageParams.height = (int)height;
                ScaleImageView.this.imageView.setLayoutParams((ViewGroup.LayoutParams)ScaleImageView.this.mImageParams);
                if (ScaleImageView.this.doBackgroundAlpha) {
                    ScaleImageView.this.setBackgroundAlpha((int)(fraction * 255.0f));
                }
                if (callback != null) {
                    callback.onTransitionRunning(fraction);
                }
            }
        });
        animator.start();
    }

    private void performExitAnim(final TransitionCallback callback) {
        float previewH;
        this.isImageAnimRunning = true;
        float previewW = this.getWidth() != 0 ? (float)this.getWidth() : this.mDefWidth;
        float f = previewH = this.getHeight() != 0 ? (float)this.getHeight() : this.mDefHeight;
        if (this.imageView != null && this.imageView.getScale() > 1.0f) {
            this.imageView.setScale(1.0f);
        }
        float oriImg_width = 0.0f;
        float oriImg_height = 0.0f;
        Drawable drawable = this.imageView.getDrawable();
        if (drawable != null) {
            oriImg_width = drawable.getIntrinsicWidth();
            oriImg_height = drawable.getIntrinsicHeight();
        } else if (this.mViewData.getImageWidth() != 0.0f && this.mViewData.getImageHeight() != 0.0f) {
            oriImg_width = this.mViewData.getImageWidth();
            oriImg_height = this.mViewData.getImageHeight();
        }
        float scale = Math.min(previewW / oriImg_width, previewH / oriImg_height);
        float adjustImg_width = oriImg_width * scale;
        float adjustImg_height = oriImg_height * scale;
        this.imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        final float old_width = adjustImg_width != 0.0f ? adjustImg_width : (float)this.imageView.getWidth();
        final float old_height = adjustImg_height != 0.0f ? adjustImg_height : (float)this.imageView.getHeight();
        final float new_width = this.mViewData.getTargetWidth();
        final float new_height = this.mViewData.getTargetHeight();
        final float from_x = (previewW - old_width) / 2.0f;
        final float from_y = (previewH - old_height) / 2.0f;
        final float to_x = this.mViewData.getTargetX();
        final float to_y = this.mViewData.getTargetY();
        if (this.doBackgroundAlpha && this.mBackground == null && this.getBackground() != null) {
            this.mBackground = this.getBackground().mutate();
        }
        this.imageView.setX(from_x);
        this.imageView.setY(from_y);
        this.mImageParams.width = (int)old_width;
        this.mImageParams.height = (int)old_height;
        this.imageView.setLayoutParams((ViewGroup.LayoutParams)this.mImageParams);
        if (this.progressView != null && this.progressView.getVisibility() == 0) {
            this.removeProgressView();
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration((long)this.mDuration);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (callback != null) {
                    callback.onTransitionStart();
                }
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ScaleImageView.this.setVisibility(8);
                ScaleImageView.this.isImageAnimRunning = false;
                if (callback != null) {
                    callback.onTransitionEnd();
                }
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            FloatEvaluator evaluator = new FloatEvaluator();

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = animation.getAnimatedFraction();
                float x = this.evaluator.evaluate(fraction, (Number)Float.valueOf(from_x), (Number)Float.valueOf(to_x)).floatValue();
                float y = this.evaluator.evaluate(fraction, (Number)Float.valueOf(from_y), (Number)Float.valueOf(to_y)).floatValue();
                float width = this.evaluator.evaluate(fraction, (Number)Float.valueOf(old_width), (Number)Float.valueOf(new_width)).floatValue();
                float height = this.evaluator.evaluate(fraction, (Number)Float.valueOf(old_height), (Number)Float.valueOf(new_height)).floatValue();
                ScaleImageView.this.imageView.setX(x);
                ScaleImageView.this.imageView.setY(y);
                ((ScaleImageView)ScaleImageView.this).mImageParams.width = (int)width;
                ((ScaleImageView)ScaleImageView.this).mImageParams.height = (int)height;
                ScaleImageView.this.imageView.setLayoutParams((ViewGroup.LayoutParams)ScaleImageView.this.mImageParams);
                if (ScaleImageView.this.doBackgroundAlpha) {
                    ScaleImageView.this.setBackgroundAlpha((int)((1.0f - fraction) * 255.0f));
                }
                if (callback != null) {
                    callback.onTransitionRunning(fraction);
                }
            }
        });
        animator.start();
    }
}

