/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.widget;

import android.content.res.TypedArray;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.chrisbanes.photoview.PhotoView;
import com.liyi.viewer.ImageLoader;
import com.liyi.viewer.ImageViewerUtil;
import com.liyi.viewer.R;
import com.liyi.viewer.TransitionCallback;
import com.liyi.viewer.ViewData;
import com.liyi.viewer.listener.OnImageChangedListener;
import com.liyi.viewer.listener.OnItemClickListener;
import com.liyi.viewer.listener.OnItemLongClickListener;
import com.liyi.viewer.listener.OnPreviewStatusListener;
import com.liyi.viewer.widget.ScaleImageView;
import com.liyi.viewer.widget.viewpager.PreviewAdapter;
import com.liyi.viewer.widget.viewpager.PreviewPager;
import java.util.List;

public class ImageViewerAttacher
implements ViewPager.OnPageChangeListener {
    public static final int DEF_DURATION = 300;
    private FrameLayout container;
    private TextView indexView;
    private PreviewPager viewPager;
    private PreviewAdapter mPreviewAdapter;
    private Point mScreenSize;
    private List mImageDataList;
    private List<ViewData> mViewDataList;
    private int mStartPosition;
    private boolean showIndex;
    private boolean doDrag;
    private int mDragType;
    private boolean doEnterAnim;
    private boolean doExitAnim;
    private int mDuration;
    private boolean isImageScaleable;
    private float mImageMaxScale;
    private float mImageMinScale;
    private int mViewState;
    private ImageLoader mImageLoader;
    private OnImageChangedListener mImageChangedListener;
    private OnItemClickListener mItemClickListener;
    private OnItemLongClickListener mItemLongClickListener;
    private OnPreviewStatusListener mPreviewStatusListener;

    public ImageViewerAttacher(FrameLayout frameLayout, AttributeSet attrs) {
        this.container = frameLayout;
        this.initData();
        this.initAttr(attrs);
        this.initView();
    }

    private void initAttr(AttributeSet attrs) {
        TypedArray a;
        if (attrs != null && (a = this.container.getContext().obtainStyledAttributes(attrs, R.styleable.ImageViewer)) != null) {
            this.showIndex = a.getBoolean(R.styleable.ImageViewer_ivr_show_index, true);
            this.doDrag = a.getBoolean(R.styleable.ImageViewer_ivr_do_drag, true);
            this.mDragType = a.getInteger(R.styleable.ImageViewer_ivr_drag_type, 1);
            this.doEnterAnim = a.getBoolean(R.styleable.ImageViewer_ivr_do_enter, true);
            this.doExitAnim = a.getBoolean(R.styleable.ImageViewer_ivr_do_exit, true);
            this.mDuration = a.getInteger(R.styleable.ImageViewer_ivr_duration, 300);
            this.isImageScaleable = a.getBoolean(R.styleable.ImageViewer_ivr_scaleable, true);
            a.recycle();
        }
    }

    private void initData() {
        this.showIndex = true;
        this.doDrag = true;
        this.mDragType = 1;
        this.doEnterAnim = true;
        this.doExitAnim = true;
        this.mDuration = 300;
        this.isImageScaleable = true;
        this.mScreenSize = ImageViewerUtil.getScreenSize(this.container.getContext());
        this.mViewState = 8;
    }

    private void initView() {
        this.viewPager = new PreviewPager(this.container.getContext());
        this.viewPager.setOffscreenPageLimit(1);
        this.viewPager.addOnPageChangeListener(this);
        this.container.addView((View)this.viewPager, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.indexView = new TextView(this.container.getContext());
        FrameLayout.LayoutParams textParams = new FrameLayout.LayoutParams(-2, -2);
        textParams.setMargins(0, ImageViewerUtil.getStatusBarHeight(this.container.getContext()) + ImageViewerUtil.dp2px(this.container.getContext(), 5.0f), 0, 0);
        textParams.gravity = 49;
        this.indexView.setLayoutParams((ViewGroup.LayoutParams)textParams);
        this.indexView.setIncludeFontPadding(false);
        this.indexView.setTextSize(2, 16.0f);
        this.indexView.setTextColor(-1);
        this.indexView.setVisibility(8);
        this.container.addView((View)this.indexView);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        ScaleImageView scaleImageView;
        if (this.indexView.getVisibility() == 0) {
            this.indexView.setText((CharSequence)(position + 1 + "/" + this.mImageDataList.size()));
        }
        if ((scaleImageView = this.getCurrentView()) != null) {
            scaleImageView.setScale(1.0f);
            if (this.mImageChangedListener != null) {
                this.mImageChangedListener.onImageSelected(position, scaleImageView);
            }
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void setBackgroundAlpha(int alpha) {
        if (this.container != null && this.container.getBackground() != null) {
            this.container.getBackground().mutate().setAlpha(alpha);
        }
    }

    public void setViewPagerScrollable(boolean scrollable) {
        this.viewPager.setScrollable(scrollable);
    }

    private void handleImageIndex() {
        if (this.showIndex) {
            if (this.mImageDataList != null && this.mImageDataList.size() > 1) {
                this.indexView.setText((CharSequence)(this.mStartPosition + 1 + "/" + this.mImageDataList.size()));
                this.indexView.setVisibility(0);
            } else {
                this.indexView.setVisibility(8);
            }
        } else {
            this.indexView.setVisibility(8);
        }
    }

    public ScaleImageView createItemView(int position) {
        ScaleImageView itemView = new ScaleImageView(this.container.getContext());
        return this.setupItemViewConfig(position, itemView);
    }

    public ScaleImageView setupItemViewConfig(int position, ScaleImageView itemView) {
        itemView.setId(position);
        itemView.setPosition(position);
        itemView.setScaleable(this.isImageScaleable);
        itemView.setDefSize(this.mScreenSize.x, this.mScreenSize.y);
        if (this.mImageMaxScale > 0.0f) {
            itemView.setMaxScale(this.mImageMaxScale);
        }
        if (this.mImageMinScale > 0.0f) {
            itemView.setMinScale(this.mImageMinScale);
        }
        if (this.mViewDataList != null && this.mViewDataList.size() > position) {
            itemView.setViewData(this.mViewDataList.get(position));
        }
        PhotoView imageView = (PhotoView)itemView.getImageView();
        imageView.setX(0.0f);
        imageView.setY(0.0f);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        imageView.setScale(1.0f);
        ImageGestureListener imageGestureListener = new ImageGestureListener(itemView);
        itemView.setOnViewClickListener(imageGestureListener);
        itemView.setOnViewLongClickListener(imageGestureListener);
        if (this.doDrag) {
            itemView.setImageDraggerType(this.mDragType, this, this.container.getBackground());
        } else {
            itemView.clearImageDragger();
        }
        if (this.mImageLoader != null) {
            this.mImageLoader.displayImage(position, this.mImageDataList.get(position), (ImageView)imageView);
        }
        itemView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        return itemView;
    }

    public void watch() {
        this.viewPager.setScrollable(true);
        ScaleImageView scaleImageView = this.createItemView(this.mStartPosition);
        if (this.mPreviewAdapter == null) {
            this.mPreviewAdapter = new PreviewAdapter(this);
            this.mPreviewAdapter.setStartView(scaleImageView);
            this.mPreviewAdapter.setImageData(this.mImageDataList);
            this.viewPager.setAdapter(this.mPreviewAdapter);
        } else {
            this.mPreviewAdapter.setStartView(scaleImageView);
            this.mPreviewAdapter.setImageData(this.mImageDataList);
            this.mPreviewAdapter.notifyDataSetChanged();
        }
        this.viewPager.setCurrentItem(this.mStartPosition, false);
        this.setPreviewStatus(1, scaleImageView);
        this.container.setVisibility(0);
        if (this.doEnterAnim) {
            this.enterWithAnim(scaleImageView);
        } else {
            this.enter(scaleImageView);
        }
    }

    public void enterWithAnim(final ScaleImageView scaleImageView) {
        this.viewPager.setScrollable(false);
        scaleImageView.setPosition(this.mStartPosition);
        scaleImageView.setViewData(this.mViewDataList.get(this.mStartPosition));
        scaleImageView.setDuration(this.mDuration);
        scaleImageView.setDoBackgroundAlpha(false);
        scaleImageView.start(new TransitionCallback(){

            @Override
            public void onTransitionRunning(float progress) {
                super.onTransitionRunning(progress);
                ImageViewerAttacher.this.setBackgroundAlpha((int)(progress * 255.0f));
                ImageViewerAttacher.this.setPreviewStatus(2, scaleImageView);
            }

            @Override
            public void onTransitionEnd() {
                super.onTransitionEnd();
                ImageViewerAttacher.this.enter(scaleImageView);
            }
        });
    }

    private void enter(ScaleImageView scaleImageView) {
        this.setBackgroundAlpha(255);
        this.handleImageIndex();
        this.viewPager.setScrollable(true);
        this.setPreviewStatus(3, scaleImageView);
        this.setPreviewStatus(4, scaleImageView);
    }

    public void close() {
        this.viewPager.setScrollable(false);
        this.setPreviewStatus(5, this.getCurrentView());
        if (this.doExitAnim) {
            this.exitWithAnim();
        } else {
            this.exit();
        }
    }

    public void exitWithAnim() {
        this.viewPager.setScrollable(false);
        this.indexView.setVisibility(8);
        int position = this.getCurrentPosition();
        ViewData viewData = this.mViewDataList.get(position);
        final ScaleImageView scaleImageView = this.getCurrentView();
        scaleImageView.setPosition(position);
        scaleImageView.setViewData(viewData);
        scaleImageView.setDuration(this.mDuration);
        scaleImageView.setDoBackgroundAlpha(false);
        scaleImageView.cancel(new TransitionCallback(){

            @Override
            public void onTransitionRunning(float progress) {
                super.onTransitionRunning(progress);
                ImageViewerAttacher.this.setBackgroundAlpha((int)((1.0f - progress) * 255.0f));
                ImageViewerAttacher.this.setPreviewStatus(6, scaleImageView);
            }

            @Override
            public void onTransitionEnd() {
                super.onTransitionEnd();
                ImageViewerAttacher.this.exit();
            }
        });
    }

    public void exit() {
        this.container.setVisibility(8);
        this.recycle();
        this.setPreviewStatus(7, null);
        this.setPreviewStatus(8, null);
    }

    private void recycle() {
        if (this.mPreviewAdapter != null) {
            this.mPreviewAdapter.clear();
        }
    }

    public void clear() {
        this.exit();
        if (this.mImageDataList != null && this.mImageDataList.size() > 0) {
            this.mImageDataList.clear();
        }
        if (this.mViewDataList != null && this.mViewDataList.size() > 0) {
            this.mViewDataList.clear();
        }
        if (this.mPreviewAdapter != null) {
            this.mPreviewAdapter.clear();
        }
        this.mImageChangedListener = null;
        this.mItemClickListener = null;
        this.mItemLongClickListener = null;
        this.mPreviewStatusListener = null;
        this.mImageLoader = null;
        this.initData();
    }

    public void setImageData(List list) {
        this.mImageDataList = list;
    }

    public void setViewData(List<ViewData> list) {
        this.mViewDataList = list;
    }

    public void setStartPosition(int position) {
        this.mStartPosition = position;
    }

    public void showIndex(boolean show) {
        this.showIndex = show;
    }

    public void doDrag(boolean isDo) {
        this.doDrag = isDo;
    }

    public void setDragType(int type) {
        this.mDragType = type;
    }

    public void doEnterAnim(boolean isDo) {
        this.doEnterAnim = isDo;
    }

    public void doExitAnim(boolean isDo) {
        this.doExitAnim = isDo;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void setImageLoader(ImageLoader loader) {
        this.mImageLoader = loader;
    }

    public void setImageScaleable(boolean scaleable) {
        this.isImageScaleable = scaleable;
    }

    public boolean isImageScaleable() {
        return this.isImageScaleable;
    }

    public float getImageScale() {
        ScaleImageView scaleImageView = this.getCurrentView();
        return scaleImageView != null ? scaleImageView.getScale() : 1.0f;
    }

    public void setImageMaxScale(float maxScaleLevel) {
        this.mImageMaxScale = maxScaleLevel;
    }

    public float getImageMaxScale() {
        return this.mImageMaxScale;
    }

    public void setImageMinScale(float minScaleLevel) {
        this.mImageMinScale = minScaleLevel;
    }

    public float getImageMinScale() {
        return this.mImageMinScale;
    }

    public TextView getIndexView() {
        return this.indexView;
    }

    public int getCurrentPosition() {
        return this.viewPager != null ? this.viewPager.getCurrentItem() : 0;
    }

    public ScaleImageView getCurrentView() {
        return this.mPreviewAdapter != null ? this.mPreviewAdapter.getViewByPosition(this.getCurrentPosition()) : null;
    }

    public int getViewState() {
        return this.mViewState;
    }

    public boolean isImageAnimRunning() {
        ScaleImageView scaleImageView = this.getCurrentView();
        if (scaleImageView != null) {
            return scaleImageView.isImageAnimRunning();
        }
        return false;
    }

    public void setOnImageChangedListener(OnImageChangedListener listener) {
        this.mImageChangedListener = listener;
    }

    public void setOnViewClickListener(OnItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.mItemLongClickListener = listener;
    }

    public void setOnPreviewStatusListener(@NonNull OnPreviewStatusListener listener) {
        this.mPreviewStatusListener = listener;
    }

    public void setPreviewStatus(int state, ScaleImageView scaleImageView) {
        this.mViewState = state;
        if (this.mPreviewStatusListener != null) {
            this.mPreviewStatusListener.onPreviewStatus(state, scaleImageView);
        }
    }

    private class ImageGestureListener
    implements View.OnClickListener,
    View.OnLongClickListener {
        private ScaleImageView scaleImageView;

        public ImageGestureListener(ScaleImageView scaleImageView) {
            this.scaleImageView = scaleImageView;
        }

        public void onClick(View v) {
            if (!this.scaleImageView.isImageAnimRunning() && !this.scaleImageView.isImageDragging()) {
                boolean result;
                if (ImageViewerAttacher.this.mItemClickListener != null && (result = ImageViewerAttacher.this.mItemClickListener.onItemClick(this.scaleImageView.getPosition(), (View)this.scaleImageView.getImageView()))) {
                    return;
                }
                ImageViewerAttacher.this.close();
            }
        }

        public boolean onLongClick(View v) {
            if (!this.scaleImageView.isImageAnimRunning() && !this.scaleImageView.isImageDragging() && ImageViewerAttacher.this.mItemLongClickListener != null) {
                ImageViewerAttacher.this.mItemLongClickListener.onItemLongClick(this.scaleImageView.getPosition(), (View)this.scaleImageView.getImageView());
                return true;
            }
            return false;
        }
    }
}

