/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.liyi.viewer.ImageLoader;
import com.liyi.viewer.ViewData;
import com.liyi.viewer.listener.OnImageChangedListener;
import com.liyi.viewer.listener.OnItemClickListener;
import com.liyi.viewer.listener.OnItemLongClickListener;
import com.liyi.viewer.listener.OnPreviewStatusListener;
import com.liyi.viewer.widget.IImageViewer;
import com.liyi.viewer.widget.ImageViewerAttacher;
import java.util.List;

public class ImageViewer
extends FrameLayout
implements IImageViewer {
    private ImageViewerAttacher mAttacher;

    public ImageViewer(@NonNull Context context) {
        super(context);
        this.init(null);
    }

    public ImageViewer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ImageViewer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.mAttacher = new ImageViewerAttacher(this, attrs);
    }

    @Override
    public TextView getIndexView() {
        return this.mAttacher.getIndexView();
    }

    @Override
    public ImageViewer setStartPosition(int position) {
        this.mAttacher.setStartPosition(position);
        return this;
    }

    @Override
    public ImageViewer setImageData(List list) {
        this.mAttacher.setImageData(list);
        return this;
    }

    @Override
    public ImageViewer setViewData(List<ViewData> list) {
        this.mAttacher.setViewData(list);
        return this;
    }

    @Override
    public ImageViewer setImageLoader(ImageLoader loader) {
        this.mAttacher.setImageLoader(loader);
        return this;
    }

    @Override
    public ImageViewer showIndex(boolean show) {
        this.mAttacher.showIndex(show);
        return this;
    }

    @Override
    public ImageViewer doDrag(boolean isDo) {
        this.mAttacher.doDrag(isDo);
        return this;
    }

    @Override
    public ImageViewer setDragType(int type) {
        this.mAttacher.setDragType(type);
        return this;
    }

    @Override
    public ImageViewer doEnterAnim(boolean isDo) {
        this.mAttacher.doEnterAnim(isDo);
        return this;
    }

    @Override
    public ImageViewer doExitAnim(boolean isDo) {
        this.mAttacher.doExitAnim(isDo);
        return this;
    }

    @Override
    public ImageViewer setDuration(int duration) {
        this.mAttacher.setDuration(duration);
        return this;
    }

    @Override
    public ImageViewer setOnImageChangedListener(OnImageChangedListener listener) {
        this.mAttacher.setOnImageChangedListener(listener);
        return this;
    }

    @Override
    public ImageViewer setOnItemClickListener(OnItemClickListener listener) {
        this.mAttacher.setOnViewClickListener(listener);
        return this;
    }

    @Override
    public ImageViewer setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.mAttacher.setOnItemLongClickListener(listener);
        return this;
    }

    @Override
    public ImageViewer setOnPreviewStatusListener(OnPreviewStatusListener listener) {
        this.mAttacher.setOnPreviewStatusListener(listener);
        return this;
    }

    @Override
    public void watch() {
        this.mAttacher.watch();
    }

    @Override
    public void close() {
        this.mAttacher.close();
    }

    @Override
    public void clear() {
        this.mAttacher.clear();
    }

    @Override
    public int getViewState() {
        return this.mAttacher.getViewState();
    }

    @Override
    public ImageViewer setImageScaleable(boolean scaleable) {
        this.mAttacher.setImageScaleable(scaleable);
        return this;
    }

    @Override
    public boolean isImageScaleable() {
        return this.mAttacher.isImageScaleable();
    }

    @Override
    public float getImageScale() {
        return this.mAttacher.getImageScale();
    }

    @Override
    public ImageViewer setImageMaxScale(float maxScaleLevel) {
        this.mAttacher.setImageMaxScale(maxScaleLevel);
        return this;
    }

    @Override
    public float getImageMaxScale() {
        return this.mAttacher.getImageMaxScale();
    }

    @Override
    public ImageViewer setImageMinScale(float minScaleLevel) {
        this.mAttacher.setImageMinScale(minScaleLevel);
        return this;
    }

    @Override
    public float getImageMinScale() {
        return this.mAttacher.getImageMinScale();
    }

    @Override
    public int getCurrentPosition() {
        return this.mAttacher.getCurrentPosition();
    }

    @Override
    public View getCurrentView() {
        return this.mAttacher.getCurrentView();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && !this.mAttacher.isImageAnimRunning() && this.getViewState() == 4) {
            this.close();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear();
    }
}

