/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.dragger;

import android.graphics.drawable.Drawable;
import com.liyi.viewer.dragger.ImageDraggerStateListener;
import com.liyi.viewer.widget.ImageViewerAttacher;
import com.liyi.viewer.widget.ScaleImageView;

public class ImageDragger {
    protected final int DEF_BACKGROUND_ALPHA = 255;
    protected float mMaxDisOnY;
    protected float mAlphaBase;
    protected Drawable mBackground;
    protected float mBackgroundAlpha;
    protected float mPreviewWidth;
    protected float mPreviewHeight;
    protected ImageDraggerStateListener mStateListener;
    protected ScaleImageView scaleImageView;
    protected ImageViewerAttacher mAttacher;

    public void bindScaleImageView(ScaleImageView scaleImageView) {
        this.scaleImageView = scaleImageView;
    }

    public void bindImageViewerAttacher(ImageViewerAttacher attacher) {
        this.mAttacher = attacher;
    }

    public void setBackground(Drawable drawable) {
        this.mBackground = drawable != null ? drawable.mutate() : null;
    }

    public void calculateValue(float height) {
        this.mMaxDisOnY = height / 5.0f;
        this.mAlphaBase = this.mMaxDisOnY * 2.0f;
    }

    public void onReady(float width, float height) {
        this.mBackgroundAlpha = 255.0f;
        this.mPreviewWidth = width;
        this.mPreviewHeight = height;
        this.calculateValue(this.mPreviewHeight);
        if (this.checkAttacherNotNull()) {
            this.mAttacher.setViewPagerScrollable(false);
        }
        this.setImageDraggerState(1);
    }

    public void onDragging(float x1, float y1, float x2, float y2) {
        this.setImageDraggerState(2);
        this.setPreviewStatus(9, this.scaleImageView);
    }

    public void onRelease() {
    }

    public void setImageDraggerStateListener(ImageDraggerStateListener listener) {
        this.mStateListener = listener;
    }

    public void setImageDraggerState(int state) {
        if (this.mStateListener != null) {
            this.mStateListener.onImageDraggerState(state);
        }
    }

    public void setBackgroundAlpha(int alpha) {
        if (this.mBackground != null) {
            this.mBackground.setAlpha(alpha);
        }
    }

    public void setPreviewStatus(int state, ScaleImageView imagePager) {
        if (this.checkAttacherNotNull()) {
            this.mAttacher.setPreviewStatus(state, imagePager);
        }
    }

    public boolean checkAttacherNotNull() {
        return this.mAttacher != null;
    }
}

