/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.dragger;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.FloatEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.liyi.viewer.ViewData;
import com.liyi.viewer.dragger.ImageDragger;

public class DefaultImageDragger
extends ImageDragger {
    private final int BACK_ANIM_DURATION = 200;
    private final int EXIT_ANIM_DURATION = 200;

    @Override
    public void onDragging(float x1, float y1, float x2, float y2) {
        super.onDragging(x1, y1, x2, y2);
        ImageView imageView = this.scaleImageView.getImageView();
        float diff = y2 - y1;
        float viewY = imageView.getY() + diff;
        float value = Math.abs(viewY) / this.mAlphaBase;
        this.mBackgroundAlpha = (value < 0.8f ? 1.0f - value : 0.2f) * 255.0f;
        imageView.setY(viewY);
        this.setBackgroundAlpha((int)this.mBackgroundAlpha);
    }

    @Override
    public void onRelease() {
        super.onRelease();
        if (!this.scaleImageView.isImageAnimRunning()) {
            ImageView imageView = this.scaleImageView.getImageView();
            float imageViewY = imageView.getY();
            if (Math.abs(imageViewY) <= this.mMaxDisOnY) {
                this.reback();
            } else {
                this.exit();
            }
        }
    }

    private void reback() {
        this.setImageDraggerState(3);
        this.setPreviewStatus(10, this.scaleImageView);
        ImageView imageView = this.scaleImageView.getImageView();
        final float imageViewY = imageView.getY();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(200L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((View)imageView){
            FloatEvaluator evaluator = new FloatEvaluator();
            final /* synthetic */ View val$imageView;
            {
                this.val$imageView = view;
            }

            @SuppressLint(value={"WrongConstant"})
            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                float y = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(imageViewY), (Number)0).floatValue();
                float alpha = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(DefaultImageDragger.this.mBackgroundAlpha), (Number)255).floatValue();
                this.val$imageView.setY(y);
                DefaultImageDragger.this.setBackgroundAlpha((int)alpha);
                DefaultImageDragger.this.setImageDraggerState(4);
                DefaultImageDragger.this.setPreviewStatus(11, DefaultImageDragger.this.scaleImageView);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                DefaultImageDragger.this.mBackgroundAlpha = 255.0f;
                DefaultImageDragger.this.setImageDraggerState(5);
                if (DefaultImageDragger.this.checkAttacherNotNull()) {
                    DefaultImageDragger.this.mAttacher.setViewPagerScrollable(true);
                    DefaultImageDragger.this.setPreviewStatus(12, DefaultImageDragger.this.scaleImageView);
                    DefaultImageDragger.this.setPreviewStatus(4, DefaultImageDragger.this.scaleImageView);
                }
            }
        });
        animator.start();
    }

    private void exit() {
        this.setImageDraggerState(6);
        this.setPreviewStatus(5, this.scaleImageView);
        final ImageView imageView = this.scaleImageView.getImageView();
        ViewData viewData = this.scaleImageView.getViewData();
        final float imageViewY = imageView.getY();
        float oriImg_width = 0.0f;
        float oriImg_height = 0.0f;
        Drawable drawable = imageView.getDrawable();
        if (drawable != null) {
            oriImg_width = drawable.getIntrinsicWidth();
            oriImg_height = drawable.getIntrinsicHeight();
        } else if (viewData.getImageWidth() != 0.0f && viewData.getImageHeight() != 0.0f) {
            oriImg_width = viewData.getImageWidth();
            oriImg_height = viewData.getImageHeight();
        }
        float scale = Math.min(this.mPreviewWidth / oriImg_width, this.mPreviewHeight / oriImg_height);
        float adjustHeight = oriImg_height * scale;
        float adjustImgY = (this.mPreviewHeight - adjustHeight) / 2.0f;
        float currentImgY = imageViewY + adjustImgY;
        final float toY = currentImgY > adjustImgY ? imageViewY + (this.mPreviewHeight - currentImgY + 20.0f) : imageViewY - (currentImgY + adjustHeight + 20.0f);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(200L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            FloatEvaluator evaluator = new FloatEvaluator();

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                float y = this.evaluator.evaluate(progress, (Number)Float.valueOf(imageViewY), (Number)Float.valueOf(toY)).floatValue();
                float alpha = this.evaluator.evaluate(progress, (Number)Float.valueOf(DefaultImageDragger.this.mBackgroundAlpha), (Number)0).floatValue();
                imageView.setY(y);
                DefaultImageDragger.this.setBackgroundAlpha((int)alpha);
                DefaultImageDragger.this.setImageDraggerState(7);
                DefaultImageDragger.this.setPreviewStatus(6, DefaultImageDragger.this.scaleImageView);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (DefaultImageDragger.this.checkAttacherNotNull()) {
                    DefaultImageDragger.this.mAttacher.exit();
                }
                DefaultImageDragger.this.mBackgroundAlpha = 255.0f;
                DefaultImageDragger.this.setImageDraggerState(8);
                imageView.setY(0.0f);
                DefaultImageDragger.this.setBackgroundAlpha((int)DefaultImageDragger.this.mBackgroundAlpha);
                DefaultImageDragger.this.setPreviewStatus(7, DefaultImageDragger.this.scaleImageView);
                DefaultImageDragger.this.setPreviewStatus(8, null);
            }
        });
        animator.start();
    }
}

