/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.dragger;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.FloatEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.liyi.viewer.ViewData;
import com.liyi.viewer.dragger.ImageDragger;
import com.liyi.viewer.widget.ScaleImageView;

public class WxImageDragger
extends ImageDragger {
    protected final int BACK_ANIM_DURATION = 200;
    private final int EXIT_ANIM_DURATION = 280;
    private final float MIN_SCALE_WEIGHT = 0.25f;
    private float mCurScale;
    private float mCurImgX;
    private float mCurImgY;
    private float mAdjustScale;
    private float mAdjustImgWidth;
    private float mAdjustImgHeight;
    private float mOriImg_width = 0.0f;
    private float mOriImg_height = 0.0f;
    private FrameLayout.LayoutParams mImageParams;

    @Override
    public void bindScaleImageView(ScaleImageView scaleImageView) {
        super.bindScaleImageView(scaleImageView);
        ViewData viewData = scaleImageView.getViewData();
        ImageView imageView = scaleImageView.getImageView();
        this.mImageParams = (FrameLayout.LayoutParams)imageView.getLayoutParams();
        Drawable drawable = imageView.getDrawable();
        if (drawable != null) {
            this.mOriImg_width = drawable.getIntrinsicWidth();
            this.mOriImg_height = drawable.getIntrinsicHeight();
        } else if (viewData.getImageWidth() != 0.0f && viewData.getImageHeight() != 0.0f) {
            this.mOriImg_width = viewData.getImageWidth();
            this.mOriImg_height = viewData.getImageHeight();
        }
    }

    @Override
    public void onReady(float width, float height) {
        super.onReady(width, height);
        this.mAdjustScale = Math.min(this.mPreviewWidth / this.mOriImg_width, this.mPreviewHeight / this.mOriImg_height);
    }

    @Override
    public void onDragging(float x1, float y1, float x2, float y2) {
        super.onDragging(x1, y1, x2, y2);
        ImageView imageView = this.scaleImageView.getImageView();
        float diffX = x2 - x1;
        float diffY = y2 - y1;
        float viewX = imageView.getX() + diffX;
        float viewY = imageView.getY() + diffY;
        if (viewY <= 0.0f) {
            this.mBackgroundAlpha = 255.0f;
            this.mCurScale = 1.0f;
            if (imageView.getY() > 0.0f) {
                this.mImageParams.width = (int)(this.mPreviewWidth * this.mCurScale);
                this.mImageParams.height = (int)(this.mPreviewHeight * this.mCurScale);
                imageView.setLayoutParams((ViewGroup.LayoutParams)this.mImageParams);
                this.setBackgroundAlpha((int)this.mBackgroundAlpha);
            }
        } else {
            float value = Math.abs(viewY) / this.mAlphaBase;
            this.mBackgroundAlpha = (value <= 0.8f ? 1.0f - value : 0.2f) * 255.0f;
            this.mCurScale = Math.min(Math.max(viewY < 0.0f ? 1.0f : 1.0f - Math.abs(viewY) / this.mPreviewHeight, 0.25f), 1.0f);
            this.mImageParams.width = (int)(this.mPreviewWidth * this.mCurScale);
            this.mImageParams.height = (int)(this.mPreviewHeight * this.mCurScale);
            imageView.setLayoutParams((ViewGroup.LayoutParams)this.mImageParams);
            this.setBackgroundAlpha((int)this.mBackgroundAlpha);
        }
        imageView.setX(viewX);
        imageView.setY(viewY);
    }

    @Override
    public void onRelease() {
        super.onRelease();
        if (!this.scaleImageView.isImageAnimRunning()) {
            ImageView imageView = this.scaleImageView.getImageView();
            float viewX = imageView.getX();
            float viewY = imageView.getY();
            this.mAdjustImgWidth = this.mOriImg_width * this.mAdjustScale;
            this.mAdjustImgHeight = this.mOriImg_height * this.mAdjustScale;
            this.mCurImgX = viewX + (this.mPreviewWidth - this.mAdjustImgWidth) / 2.0f * this.mCurScale;
            this.mCurImgY = viewY + (this.mPreviewHeight - this.mAdjustImgHeight) / 2.0f * this.mCurScale;
            if (viewY <= this.mMaxDisOnY) {
                this.reback();
            } else {
                this.exit();
            }
        }
    }

    private void reback() {
        this.setImageDraggerState(3);
        this.setPreviewStatus(10, this.scaleImageView);
        ImageView imageView = this.scaleImageView.getImageView();
        final float from_x = imageView.getX();
        final float from_y = imageView.getY();
        float to_x = 0.0f;
        float to_y = 0.0f;
        final float old_width = imageView.getWidth();
        final float old_height = imageView.getHeight();
        final float new_width = this.mPreviewWidth;
        final float new_height = this.mPreviewHeight;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(200L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((View)imageView){
            FloatEvaluator evaluator = new FloatEvaluator();
            final /* synthetic */ View val$imageView;
            {
                this.val$imageView = view;
            }

            @SuppressLint(value={"WrongConstant"})
            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                float x = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(from_x), (Number)Float.valueOf(0.0f)).floatValue();
                float y = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(from_y), (Number)Float.valueOf(0.0f)).floatValue();
                float width = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(old_width), (Number)Float.valueOf(new_width)).floatValue();
                float height = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(old_height), (Number)Float.valueOf(new_height)).floatValue();
                float alpha = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(WxImageDragger.this.mBackgroundAlpha), (Number)255).floatValue();
                this.val$imageView.setX(x);
                this.val$imageView.setY(y);
                ((WxImageDragger)WxImageDragger.this).mImageParams.width = (int)width;
                ((WxImageDragger)WxImageDragger.this).mImageParams.height = (int)height;
                this.val$imageView.setLayoutParams((ViewGroup.LayoutParams)WxImageDragger.this.mImageParams);
                WxImageDragger.this.setBackgroundAlpha((int)alpha);
                WxImageDragger.this.setImageDraggerState(4);
                WxImageDragger.this.setPreviewStatus(11, WxImageDragger.this.scaleImageView);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                WxImageDragger.this.mBackgroundAlpha = 255.0f;
                WxImageDragger.this.setImageDraggerState(5);
                if (WxImageDragger.this.checkAttacherNotNull()) {
                    WxImageDragger.this.mAttacher.setViewPagerScrollable(true);
                    WxImageDragger.this.setPreviewStatus(12, WxImageDragger.this.scaleImageView);
                    WxImageDragger.this.setPreviewStatus(4, WxImageDragger.this.scaleImageView);
                }
            }
        });
        animator.start();
    }

    private void exit() {
        boolean needChangeImageSize;
        this.setImageDraggerState(6);
        this.setPreviewStatus(5, this.scaleImageView);
        final ImageView imageView = this.scaleImageView.getImageView();
        ViewData viewData = this.scaleImageView.getViewData();
        final float from_x = this.mCurImgX;
        final float from_y = this.mCurImgY;
        final float toX = viewData.getTargetX();
        final float toY = viewData.getTargetY();
        final float old_width = this.mAdjustImgWidth * this.mCurScale;
        final float old_height = this.mAdjustImgHeight * this.mCurScale;
        final float new_width = viewData.getTargetWidth();
        final float new_height = viewData.getTargetHeight();
        if (this.mCurImgX + this.mAdjustImgWidth * this.mCurScale <= 0.0f || this.mCurImgX >= this.mPreviewWidth || this.mCurImgY >= this.mPreviewHeight) {
            needChangeImageSize = false;
        } else {
            needChangeImageSize = true;
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration(280L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            FloatEvaluator evaluator = new FloatEvaluator();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)imageView.getLayoutParams();

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue()).floatValue();
                if (needChangeImageSize) {
                    float x = this.evaluator.evaluate(progress, (Number)Float.valueOf(from_x), (Number)Float.valueOf(toX)).floatValue();
                    float y = this.evaluator.evaluate(progress, (Number)Float.valueOf(from_y), (Number)Float.valueOf(toY)).floatValue();
                    float width = this.evaluator.evaluate(progress, (Number)Float.valueOf(old_width), (Number)Float.valueOf(new_width)).floatValue();
                    float height = this.evaluator.evaluate(progress, (Number)Float.valueOf(old_height), (Number)Float.valueOf(new_height)).floatValue();
                    imageView.setX(x);
                    imageView.setY(y);
                    this.layoutParams.width = (int)width;
                    this.layoutParams.height = (int)height;
                    imageView.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
                }
                float alpha = this.evaluator.evaluate(progress, (Number)Float.valueOf(WxImageDragger.this.mBackgroundAlpha), (Number)0).floatValue();
                WxImageDragger.this.setBackgroundAlpha((int)alpha);
                WxImageDragger.this.setImageDraggerState(7);
                WxImageDragger.this.setPreviewStatus(6, WxImageDragger.this.scaleImageView);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (WxImageDragger.this.checkAttacherNotNull()) {
                    WxImageDragger.this.mAttacher.exit();
                }
                WxImageDragger.this.mBackgroundAlpha = 255.0f;
                WxImageDragger.this.setImageDraggerState(8);
                imageView.setX(0.0f);
                imageView.setY(0.0f);
                ((WxImageDragger)WxImageDragger.this).mImageParams.width = (int)WxImageDragger.this.mPreviewWidth;
                ((WxImageDragger)WxImageDragger.this).mImageParams.height = (int)WxImageDragger.this.mPreviewHeight;
                imageView.setLayoutParams((ViewGroup.LayoutParams)WxImageDragger.this.mImageParams);
                WxImageDragger.this.setPreviewStatus(7, WxImageDragger.this.scaleImageView);
                WxImageDragger.this.setPreviewStatus(8, null);
            }
        });
        animator.start();
    }
}

