/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.widget;

import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.github.chrisbanes.photoview.PhotoView;
import com.liyi.viewer.Utils;
import com.liyi.viewer.widget.ImageViewer;
import java.util.ArrayList;
import java.util.List;

public class ImageAdapter
extends PagerAdapter {
    private List<Object> mImageList;
    private List<View> mActiveViews;
    private View currentView;
    private ImageViewer imageViewer;
    private int mStartPosition;

    public ImageAdapter(ImageViewer imageViewer) {
        this.imageViewer = imageViewer;
        this.mActiveViews = new ArrayList<View>();
    }

    public void setStartPosition(int position) {
        this.mStartPosition = position;
        View itemView = this.imageViewer.createItemView(position);
        this.imageViewer.initItemViewConfig(position, itemView);
        this.currentView = itemView;
    }

    public void setImageRes(List<Object> list) {
        this.mImageList = list;
    }

    public int getCount() {
        return this.mImageList != null ? this.mImageList.size() : 0;
    }

    public View instantiateItem(ViewGroup container, int position) {
        View itemView = null;
        if (this.mStartPosition == position) {
            itemView = this.currentView;
            this.mActiveViews.add(itemView);
            this.mStartPosition = -1;
        } else if (this.mActiveViews != null && this.mActiveViews.size() > 0) {
            int len = this.mActiveViews.size();
            for (int i = 0; i < len; ++i) {
                View view = this.mActiveViews.get(i);
                if (view.getParent() != null) continue;
                itemView = view;
                this.imageViewer.initItemViewConfig(position, itemView);
                break;
            }
        }
        if (itemView == null) {
            itemView = this.imageViewer.createItemView(position);
            this.imageViewer.initItemViewConfig(position, itemView);
            this.mActiveViews.add(itemView);
        }
        itemView.setId(position);
        container.addView(itemView);
        return itemView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (object != null) {
            PhotoView photoView = (PhotoView)((FrameLayout)object).getChildAt(0);
            Utils.recycleImage((ImageView)photoView);
        }
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public View getViewByPosition(int position) {
        int len = this.mActiveViews.size();
        for (int i = 0; i < len; ++i) {
            if (this.mActiveViews.get(i).getId() != position) continue;
            this.currentView = this.mActiveViews.get(i);
            break;
        }
        return this.currentView;
    }

    public PhotoView getPhotoViewByPosition(int position) {
        this.getViewByPosition(position);
        if (this.currentView != null) {
            return (PhotoView)((FrameLayout)this.currentView).getChildAt(0);
        }
        return null;
    }

    public void clear() {
        if (this.mActiveViews != null && this.mActiveViews.size() > 0) {
            int len = this.mActiveViews.size();
            for (int i = 0; i < len; ++i) {
                View itemView = this.mActiveViews.get(i);
                PhotoView photoView = (PhotoView)((FrameLayout)itemView).getChildAt(0);
                Utils.recycleImage((ImageView)photoView);
                Object var3_4 = null;
            }
            this.mActiveViews.clear();
        }
        if (this.currentView != null) {
            PhotoView photoView = (PhotoView)((FrameLayout)this.currentView).getChildAt(0);
            Utils.recycleImage((ImageView)photoView);
            this.currentView = null;
        }
    }
}

