/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.widget;

import android.animation.FloatEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.chrisbanes.photoview.OnViewTapListener;
import com.github.chrisbanes.photoview.PhotoView;
import com.liyi.viewer.R;
import com.liyi.viewer.Utils;
import com.liyi.viewer.data.ViewData;
import com.liyi.viewer.factory.ImageDragger;
import com.liyi.viewer.factory.ImageLoader;
import com.liyi.viewer.listener.OnImageChangedListener;
import com.liyi.viewer.listener.OnViewClickListener;
import com.liyi.viewer.listener.OnWatchStatusListener;
import com.liyi.viewer.widget.IImageViewer;
import com.liyi.viewer.widget.ImageAdapter;
import com.liyi.viewer.widget.ImagePager;
import java.util.ArrayList;
import java.util.List;

public class ImageViewer
extends FrameLayout
implements IImageViewer {
    private final FrameLayout.LayoutParams FRAME_LAYOUT_PARAMS_MATCH = new FrameLayout.LayoutParams(-2, -1);
    private final int DEF_ANIM_DURATION = 200;
    private View view_background;
    private ImagePager viewPager;
    private TextView tv_index;
    private PhotoView photoView_current;
    private ImageAdapter mImageAdapter;
    private int mStartPosition;
    private List<Object> mImageList;
    private List<ViewData> mViewDataList;
    private ImageLoader mImageLoader;
    private OnImageChangedListener mImageChangedListener;
    private OnViewClickListener mViewClickListener;
    private OnWatchStatusListener mWatchStatusListener;
    private boolean showIndex;
    private boolean doDragAction;
    private boolean doEnterAnim;
    private boolean doExitAnim;
    private int mAnimDuration;
    private ImageDragHandler mImageDragHandler;
    private Point mScreenSize;
    private List<View> mViews;
    private List<Object> mOldImageList;
    private boolean isPhotoClickalbe;
    private boolean isPhotoAnimRunning;
    private boolean isNeedUpdate;
    private boolean isImageZoomable;

    public ImageViewer(@NonNull Context context) {
        super(context);
        this.init(null);
    }

    public ImageViewer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ImageViewer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.initAttr(attrs);
        this.initView();
    }

    private void initAttr(AttributeSet attrs) {
        TypedArray a;
        this.showIndex = true;
        this.doDragAction = true;
        this.doEnterAnim = true;
        this.doExitAnim = true;
        this.mAnimDuration = 200;
        this.mScreenSize = Utils.getScreenSize(this.getContext());
        this.mViews = new ArrayList<View>();
        this.isPhotoClickalbe = true;
        this.isPhotoAnimRunning = false;
        this.isNeedUpdate = true;
        this.isImageZoomable = true;
        if (attrs != null && (a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ImageViewer)) != null) {
            this.showIndex = a.getBoolean(R.styleable.ImageViewer_ivr_show_index, true);
            this.doDragAction = a.getBoolean(R.styleable.ImageViewer_ivr_drag_enable, true);
            this.doEnterAnim = a.getBoolean(R.styleable.ImageViewer_ivr_enter_anim, true);
            this.doExitAnim = a.getBoolean(R.styleable.ImageViewer_ivr_exit_anim, true);
            this.mAnimDuration = a.getInteger(R.styleable.ImageViewer_ivr_anim_duration, 200);
            a.recycle();
        }
    }

    private void initView() {
        this.view_background = new View(this.getContext());
        this.view_background.setBackgroundColor(-16777216);
        this.view_background.setAlpha(0.0f);
        this.viewPager = new ImagePager(this.getContext());
        this.viewPager.setVisibility(8);
        this.addView(this.view_background, (ViewGroup.LayoutParams)this.FRAME_LAYOUT_PARAMS_MATCH);
        this.addView((View)this.viewPager, (ViewGroup.LayoutParams)this.FRAME_LAYOUT_PARAMS_MATCH);
        this.tv_index = new TextView(this.getContext());
        FrameLayout.LayoutParams textParams = new FrameLayout.LayoutParams(-2, -2);
        textParams.setMargins(0, Utils.dp2px(this.getContext(), 8.0f), 0, 0);
        textParams.gravity = 49;
        this.tv_index.setLayoutParams((ViewGroup.LayoutParams)textParams);
        this.tv_index.setIncludeFontPadding(false);
        this.tv_index.setTextSize(2, 16.0f);
        this.tv_index.setTextColor(-1);
        this.tv_index.setVisibility(8);
        this.addView((View)this.tv_index);
        this.viewPager.setOffscreenPageLimit(2);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (ImageViewer.this.tv_index.getVisibility() == 0) {
                    ImageViewer.this.tv_index.setText((CharSequence)(position + 1 + "/" + ImageViewer.this.mImageList.size()));
                }
                PhotoView photoView = (PhotoView)((FrameLayout)ImageViewer.this.mViews.get(position)).getChildAt(0);
                photoView.setScale(1.0f, true);
                photoView.setZoomable(ImageViewer.this.isImageZoomable);
                photoView.setOnViewTapListener((OnViewTapListener)new ViewTabListener(position));
                ImageViewer.this.photoView_current = photoView;
                if (ImageViewer.this.mImageChangedListener != null) {
                    ImageViewer.this.mImageChangedListener.onImageSelected(position, (ImageView)photoView);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    @Override
    @RequiresApi(api=16)
    public void setImageBackground(Drawable drawable) {
        this.view_background.setBackground(drawable);
    }

    @Override
    public void setImageBackgroundResource(@DrawableRes int resid) {
        this.view_background.setBackgroundResource(resid);
    }

    @Override
    public void setImageBackgroundColor(@ColorInt int color) {
        this.view_background.setBackgroundColor(color);
    }

    @Override
    public void setStartPosition(int position) {
        this.mStartPosition = position;
    }

    @Override
    public void setImageData(List<Object> list) {
        if (this.mOldImageList == null) {
            this.mOldImageList = list;
            this.mImageList = this.mOldImageList;
            this.isNeedUpdate = true;
        } else {
            this.isNeedUpdate = !this.mOldImageList.equals(list);
            this.mOldImageList = list;
            this.mImageList = this.mOldImageList;
        }
    }

    @Override
    public void setViewData(List<ViewData> list) {
        this.mViewDataList = list;
    }

    @Override
    public void setImageLoader(ImageLoader loader) {
        this.mImageLoader = loader;
    }

    @Override
    public void setOnImageChangedListener(OnImageChangedListener listener) {
        this.mImageChangedListener = listener;
    }

    @Override
    public void setOnViewClickListener(OnViewClickListener listener) {
        this.mViewClickListener = listener;
    }

    @Override
    public void setOnWatchStatusListener(OnWatchStatusListener listener) {
        this.mWatchStatusListener = listener;
    }

    @Override
    public void showIndex(boolean show) {
        this.showIndex = show;
    }

    @Override
    public void doDragAction(boolean isDo) {
        this.doDragAction = isDo;
    }

    @Override
    public void doEnterAnim(boolean isDo) {
        this.doEnterAnim = isDo;
    }

    @Override
    public void doExitAnim(boolean isDo) {
        this.doExitAnim = isDo;
    }

    @Override
    public void setAnimDuration(int duration) {
        this.mAnimDuration = duration;
    }

    @Override
    public void excuteEnterAnim() {
        boolean hasImageSize;
        float afterScale_heigt;
        float afterScale_width;
        float previewH;
        this.isPhotoClickalbe = false;
        this.isPhotoAnimRunning = true;
        ViewData viewData = this.mViewDataList.get(this.mStartPosition);
        final float beforeScale_width = viewData.getWidth();
        final float beforeScale_height = viewData.getHeight();
        final float from_x = viewData.getX();
        final float from_y = viewData.getY();
        float parentW = this.getWidth();
        float parentH = this.getHeight();
        float previewW = parentW != 0.0f ? parentW : (float)this.mScreenSize.x;
        float f = previewH = parentH != 0.0f ? parentH : (float)this.mScreenSize.y;
        if (viewData.getImageWidth() != 0.0f && viewData.getImageHeight() != 0.0f) {
            float scale = Math.min(previewW / viewData.getImageWidth(), previewH / viewData.getImageHeight());
            afterScale_width = viewData.getImageWidth() * scale;
            afterScale_heigt = viewData.getImageHeight() * scale;
            this.photoView_current.setScaleType(ImageView.ScaleType.CENTER_CROP);
            hasImageSize = true;
        } else {
            afterScale_width = previewW;
            afterScale_heigt = previewH;
            hasImageSize = false;
        }
        final float to_x = (previewW - afterScale_width) / 2.0f;
        final float to_y = (previewH - afterScale_heigt) / 2.0f;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            FloatEvaluator evaluator = new FloatEvaluator();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)ImageViewer.access$400(ImageViewer.this).getLayoutParams();

            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                float x = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(from_x), (Number)Float.valueOf(to_x)).floatValue();
                float y = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(from_y), (Number)Float.valueOf(to_y)).floatValue();
                float width = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(beforeScale_width), (Number)Float.valueOf(afterScale_width)).floatValue();
                float height = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(beforeScale_height), (Number)Float.valueOf(afterScale_heigt)).floatValue();
                ImageViewer.this.photoView_current.setX(x);
                ImageViewer.this.photoView_current.setY(y);
                this.layoutParams.width = (int)width;
                this.layoutParams.height = (int)height;
                ImageViewer.this.photoView_current.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
                ImageViewer.this.view_background.setAlpha(currentValue);
                if (currentValue == 1.0f) {
                    ImageViewer.this.handleImageIndex();
                    ImageViewer.this.isPhotoClickalbe = true;
                    ImageViewer.this.isPhotoAnimRunning = false;
                    ImageViewer.this.isNeedUpdate = true;
                    if (hasImageSize) {
                        ImageViewer.this.photoView_current.setX(0.0f);
                        ImageViewer.this.photoView_current.setY(0.0f);
                        this.layoutParams.width = ((ImageViewer)ImageViewer.this).mScreenSize.x;
                        this.layoutParams.height = ((ImageViewer)ImageViewer.this).mScreenSize.y;
                        ImageViewer.this.photoView_current.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
                        ImageViewer.this.photoView_current.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    }
                    if (ImageViewer.this.mWatchStatusListener != null) {
                        ImageViewer.this.mWatchStatusListener.onWatchStart(2, ImageViewer.this.mStartPosition, (ImageView)ImageViewer.this.photoView_current);
                    }
                }
            }
        });
        animator.setDuration((long)this.mAnimDuration);
        animator.start();
    }

    @Override
    public void excuteExitAnim() {
        PhotoView photoView;
        this.isPhotoClickalbe = false;
        this.isPhotoAnimRunning = true;
        int position = this.viewPager.getCurrentItem();
        ViewData viewData = this.mViewDataList.get(position);
        this.photoView_current = photoView = (PhotoView)((FrameLayout)this.mViews.get(position)).getChildAt(0);
        Drawable drawable = this.photoView_current.getDrawable();
        float oriImg_width = 0.0f;
        float oriImg_height = 0.0f;
        float curImg_width = 0.0f;
        float curImg_height = 0.0f;
        if (drawable != null) {
            oriImg_width = drawable.getIntrinsicWidth();
            oriImg_height = drawable.getIntrinsicHeight();
        } else if (viewData.getImageWidth() != 0.0f && viewData.getImageHeight() != 0.0f) {
            oriImg_width = viewData.getImageWidth();
            oriImg_height = viewData.getImageHeight();
        }
        float parentW = this.getWidth();
        float parentH = this.getHeight();
        if (oriImg_width != 0.0f && oriImg_height != 0.0f) {
            float scale = Math.min(parentW / oriImg_width, parentH / oriImg_height);
            curImg_width = oriImg_width * scale;
            curImg_height = oriImg_height * scale;
            float x = (parentW - curImg_width) / 2.0f;
            float y = (parentH - curImg_height) / 2.0f;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.photoView_current.getLayoutParams();
            lp.width = (int)curImg_width;
            lp.height = (int)curImg_height;
            this.photoView_current.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.photoView_current.setX(x);
            this.photoView_current.setY(y);
            this.photoView_current.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
        final float beforeScale_width = curImg_width != 0.0f ? curImg_width : (float)this.photoView_current.getWidth();
        final float beforeScale_height = curImg_height != 0.0f ? curImg_height : (float)this.photoView_current.getHeight();
        final float afterScale_width = viewData.getWidth();
        final float afterScale_heigt = viewData.getHeight();
        final float from_x = (parentW - beforeScale_width) / 2.0f;
        final float from_y = (parentH - beforeScale_height) / 2.0f;
        final float to_x = viewData.getX();
        final float to_y = viewData.getY();
        this.tv_index.setVisibility(8);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            FloatEvaluator evaluator = new FloatEvaluator();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)ImageViewer.access$400(ImageViewer.this).getLayoutParams();

            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                float x = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(from_x), (Number)Float.valueOf(to_x)).floatValue();
                float y = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(from_y), (Number)Float.valueOf(to_y)).floatValue();
                float width = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(beforeScale_width), (Number)Float.valueOf(afterScale_width)).floatValue();
                float height = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(beforeScale_height), (Number)Float.valueOf(afterScale_heigt)).floatValue();
                ImageViewer.this.photoView_current.setX(x);
                ImageViewer.this.photoView_current.setY(y);
                this.layoutParams.width = (int)width;
                this.layoutParams.height = (int)height;
                ImageViewer.this.photoView_current.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
                ImageViewer.this.view_background.setAlpha(1.0f - currentValue);
                if (currentValue == 1.0f) {
                    ImageViewer.this.viewPager.setVisibility(8);
                    ImageViewer.this.photoView_current.setX(from_x);
                    ImageViewer.this.photoView_current.setY(from_y);
                    this.layoutParams.width = (int)beforeScale_width;
                    this.layoutParams.height = (int)beforeScale_height;
                    ImageViewer.this.photoView_current.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
                    ImageViewer.this.photoView_current.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    ImageViewer.this.isPhotoClickalbe = true;
                    ImageViewer.this.isPhotoAnimRunning = false;
                    if (ImageViewer.this.mWatchStatusListener != null) {
                        ImageViewer.this.mWatchStatusListener.onWatchEnd(4);
                    }
                }
            }
        });
        animator.setDuration((long)this.mAnimDuration);
        animator.start();
    }

    private void addImageViews() {
        if (this.mImageList == null) {
            throw new NullPointerException(" ImageList cannot be empty. ");
        }
        int len = this.mImageList.size();
        for (int i = 0; i < len; ++i) {
            FrameLayout container = new FrameLayout(this.getContext());
            PhotoView photoView = new PhotoView(this.getContext());
            photoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            photoView.setZoomable(this.isImageZoomable);
            photoView.setOnViewTapListener((OnViewTapListener)new ViewTabListener(i));
            container.addView((View)photoView);
            if (this.mImageLoader != null) {
                this.mImageLoader.displayImage(i, this.mImageList.get(i), (ImageView)photoView);
            }
            if (i == this.mStartPosition) {
                this.photoView_current = photoView;
            }
            this.mViews.add((View)container);
        }
    }

    private void handleImageIndex() {
        if (this.showIndex) {
            if (this.mImageList != null && this.mImageList.size() > 1) {
                this.tv_index.setText((CharSequence)(this.mStartPosition + 1 + "/" + this.mImageList.size()));
                this.tv_index.setVisibility(0);
            } else {
                this.tv_index.setVisibility(8);
            }
        } else {
            this.tv_index.setVisibility(8);
        }
    }

    @Override
    public void watch() {
        boolean hasUpdate = false;
        if (this.isNeedUpdate || this.mViews == null || this.mViews.size() == 0) {
            hasUpdate = true;
            if (this.mViews == null) {
                this.mViews = new ArrayList<View>();
            }
            if (this.mViews.size() > 0) {
                this.mViews.clear();
            }
            this.addImageViews();
            this.viewPager.setMaxTranslateY(this.getHeight() != 0 ? (float)this.getHeight() : (float)this.mScreenSize.y);
        }
        if (this.mImageAdapter == null) {
            this.mImageAdapter = new ImageAdapter();
            this.mImageAdapter.setData(this.mViews);
            this.viewPager.setAdapter(this.mImageAdapter);
        } else if (hasUpdate) {
            this.mImageAdapter.setData(this.mViews);
            this.mImageAdapter.notifyDataSetChanged();
        }
        if (this.doDragAction) {
            if (this.mImageDragHandler == null) {
                this.mImageDragHandler = new ImageDragHandler();
            }
            this.viewPager.setImageDragger(this.mImageDragHandler);
        } else {
            this.viewPager.setImageDragger(null);
        }
        this.viewPager.setCurrentItem(this.mStartPosition, false);
        if (this.mWatchStatusListener != null) {
            this.mWatchStatusListener.onWatchStart(1, this.mStartPosition, (ImageView)this.photoView_current);
        }
        this.viewPager.setVisibility(0);
        if (this.doEnterAnim) {
            this.excuteEnterAnim();
        } else {
            this.view_background.setAlpha(1.0f);
            this.handleImageIndex();
            this.isNeedUpdate = true;
            if (this.mWatchStatusListener != null) {
                this.mWatchStatusListener.onWatchStart(2, this.mStartPosition, (ImageView)this.photoView_current);
            }
        }
    }

    @Override
    public void close() {
        if (this.mWatchStatusListener != null) {
            this.mWatchStatusListener.onWatchEnd(3);
        }
        if (this.doExitAnim) {
            this.excuteExitAnim();
        } else {
            this.view_background.setAlpha(0.0f);
            this.viewPager.setVisibility(8);
            this.tv_index.setVisibility(8);
            if (this.mWatchStatusListener != null) {
                this.mWatchStatusListener.onWatchEnd(4);
            }
        }
    }

    @Override
    public void clear() {
        if (this.mViews != null && this.mViews.size() > 0) {
            this.mViews.clear();
        }
        if (this.mViewDataList != null && this.mViewDataList.size() > 0) {
            this.mViewDataList.clear();
        }
        if (this.mImageList != null && this.mImageList.size() > 0) {
            this.mImageList.clear();
        }
        this.mImageDragHandler = null;
        this.mImageLoader = null;
        this.mImageChangedListener = null;
        this.mViewClickListener = null;
        this.mWatchStatusListener = null;
    }

    @Override
    public void setImageZoomable(boolean zoomable) {
        this.isImageZoomable = zoomable;
    }

    @Override
    public boolean isImageZoomable() {
        return this.isImageZoomable;
    }

    @Override
    public void setCurrentImageZoomable(boolean zoomable) {
        if (this.photoView_current != null) {
            this.photoView_current.setScale(1.0f, true);
            this.photoView_current.setZoomable(zoomable);
        }
    }

    @Override
    public boolean isCurrentImageZoomable() {
        if (this.photoView_current != null) {
            return this.photoView_current.isZoomable();
        }
        return false;
    }

    @Override
    public float getImageScale() {
        return this.photoView_current != null ? this.photoView_current.getScale() : 1.0f;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear();
    }

    public class ImageDragHandler
    implements ImageDragger {
        @Override
        public float getImageScale() {
            return ImageViewer.this.getImageScale();
        }

        @Override
        public void dragImage(float y1, float y2, float alphaBase) {
            if (ImageViewer.this.photoView_current != null && !ImageViewer.this.isPhotoAnimRunning) {
                ImageViewer.this.isPhotoClickalbe = false;
                float diff = y2 - y1;
                float curY = ImageViewer.this.photoView_current.getY() + diff;
                float value = Math.abs(curY) / alphaBase;
                float alpha = value < 1.0f ? 1.0f - value : 0.0f;
                ImageViewer.this.photoView_current.setY(curY);
                ImageViewer.this.view_background.setAlpha(alpha);
                if (ImageViewer.this.mWatchStatusListener != null) {
                    ImageViewer.this.mWatchStatusListener.onWatchDragging((ImageView)ImageViewer.this.photoView_current);
                }
            }
        }

        @Override
        public void releaseImage(float maxTranslateY) {
            if (ImageViewer.this.photoView_current != null && !ImageViewer.this.isPhotoAnimRunning) {
                if (ImageViewer.this.mWatchStatusListener != null) {
                    ImageViewer.this.mWatchStatusListener.onWatchReset(7, (ImageView)ImageViewer.this.photoView_current);
                }
                ImageViewer.this.isPhotoClickalbe = false;
                ImageViewer.this.isPhotoAnimRunning = true;
                final float curY = ImageViewer.this.photoView_current.getY();
                if (Math.abs(curY) <= maxTranslateY) {
                    ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                    animator.setDuration(150L);
                    animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                        FloatEvaluator evaluator = new FloatEvaluator();

                        public void onAnimationUpdate(ValueAnimator animation) {
                            float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                            float y = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(curY), (Number)0).floatValue();
                            float alpha = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(ImageViewer.this.view_background.getAlpha()), (Number)1).floatValue();
                            ImageViewer.this.photoView_current.setY(y);
                            ImageViewer.this.view_background.setAlpha(alpha);
                            if (currentValue == 1.0f) {
                                ImageViewer.this.isPhotoClickalbe = true;
                                ImageViewer.this.isPhotoAnimRunning = false;
                                if (ImageViewer.this.mWatchStatusListener != null) {
                                    ImageViewer.this.mWatchStatusListener.onWatchReset(8, (ImageView)ImageViewer.this.photoView_current);
                                }
                            }
                        }
                    });
                    animator.start();
                } else {
                    float cutImgY;
                    if (ImageViewer.this.mWatchStatusListener != null) {
                        ImageViewer.this.mWatchStatusListener.onWatchEnd(3);
                    }
                    int position = ImageViewer.this.viewPager.getCurrentItem();
                    ViewData viewData = (ViewData)ImageViewer.this.mViewDataList.get(position);
                    Drawable drawable = ImageViewer.this.photoView_current.getDrawable();
                    float curImg_height = 0.0f;
                    float oriImg_width = 0.0f;
                    float oriImg_height = 0.0f;
                    float imgY = 0.0f;
                    if (drawable != null) {
                        oriImg_width = drawable.getIntrinsicWidth();
                        oriImg_height = drawable.getIntrinsicHeight();
                    } else if (viewData.getImageWidth() != 0.0f && viewData.getImageHeight() != 0.0f) {
                        oriImg_width = viewData.getImageWidth();
                        oriImg_height = viewData.getImageHeight();
                    }
                    if (oriImg_width != 0.0f && oriImg_height != 0.0f) {
                        float scale = Math.min((float)((ImageViewer)ImageViewer.this).mScreenSize.x / oriImg_width, (float)((ImageViewer)ImageViewer.this).mScreenSize.y / oriImg_height);
                        curImg_height = oriImg_height * scale;
                        imgY = ((float)((ImageViewer)ImageViewer.this).mScreenSize.y - curImg_height) / 2.0f;
                    }
                    final float toY = (cutImgY = curY + imgY) > imgY ? curY + ((float)((ImageViewer)ImageViewer.this).mScreenSize.y - cutImgY + 10.0f) : curY - (cutImgY + curImg_height + 10.0f);
                    ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                    animator.setDuration(200L);
                    animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                        FloatEvaluator evaluator = new FloatEvaluator();

                        public void onAnimationUpdate(ValueAnimator animation) {
                            float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                            float y = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(curY), (Number)Float.valueOf(toY)).floatValue();
                            float alpha = this.evaluator.evaluate(currentValue, (Number)Float.valueOf(ImageViewer.this.view_background.getAlpha()), (Number)0).floatValue();
                            ImageViewer.this.photoView_current.setY(y);
                            ImageViewer.this.view_background.setAlpha(alpha);
                            if (currentValue == 1.0f) {
                                ImageViewer.this.isPhotoClickalbe = true;
                                ImageViewer.this.isPhotoAnimRunning = false;
                                ImageViewer.this.viewPager.setVisibility(8);
                                ImageViewer.this.photoView_current.setY(0.0f);
                                if (ImageViewer.this.mWatchStatusListener != null) {
                                    ImageViewer.this.mWatchStatusListener.onWatchEnd(4);
                                }
                            }
                        }
                    });
                    animator.start();
                }
            }
        }
    }

    private class ViewTabListener
    implements OnViewTapListener {
        private int position;

        public ViewTabListener(int position) {
            this.position = position;
        }

        public void onViewTap(View view, float x, float y) {
            if (ImageViewer.this.isPhotoClickalbe) {
                boolean b;
                if (ImageViewer.this.mViewClickListener != null && (b = ImageViewer.this.mViewClickListener.onViewClick(this.position, view, x, y))) {
                    return;
                }
                ImageViewer.this.close();
            }
        }
    }
}

