/*
 * Decompiled with CFR 0.152.
 */
package com.liyi.viewer.widget;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.liyi.viewer.factory.ImageDragger;

public class ImagePager
extends ViewPager {
    private float mMaxTranslateY;
    private float mAlphaBase;
    private float mTouchSlop;
    private float mDownX;
    private float mDownY;
    private ImageDragger mDragger;
    private boolean isDoDragging;

    public ImagePager(Context context) {
        super(context);
        this.init();
    }

    public ImagePager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mTouchSlop = ViewConfiguration.getTouchSlop();
        this.isDoDragging = false;
    }

    public void setMaxTranslateY(float height) {
        this.mMaxTranslateY = height / 5.0f;
        this.mAlphaBase = this.mMaxTranslateY * 2.0f;
    }

    public void setImageDragger(ImageDragger dragger) {
        this.mDragger = dragger;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean isIntercept = super.onInterceptTouchEvent(ev);
        switch (ev.getAction() & ev.getActionMasked()) {
            case 0: {
                this.mDownX = ev.getX();
                this.mDownY = ev.getY();
                break;
            }
            case 2: {
                float deltaY;
                if (ev.getPointerCount() != 1 || this.mDragger == null || !(this.mDragger.getImageScale() <= 1.0f)) break;
                float deltaX = Math.abs(ev.getX() - this.mDownX);
                if (deltaX < (deltaY = Math.abs(ev.getY() - this.mDownY))) {
                    isIntercept = deltaY > this.mTouchSlop;
                    this.isDoDragging = true;
                    break;
                }
                this.isDoDragging = false;
            }
        }
        return isIntercept;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction() & ev.getActionMasked()) {
            case 0: {
                this.mDownY = ev.getY();
                break;
            }
            case 2: {
                if (ev.getPointerCount() == 1 && this.mDragger != null && this.mDragger.getImageScale() <= 1.0f && this.isDoDragging) {
                    this.mDragger.dragImage(this.mDownY, ev.getY(), this.mAlphaBase);
                }
                this.mDownY = ev.getY();
                break;
            }
            case 1: {
                if (this.mDragger != null && this.mDragger.getImageScale() <= 1.0f && this.isDoDragging) {
                    this.mDragger.releaseImage(this.mMaxTranslateY);
                }
                this.isDoDragging = false;
                this.mDownY = 0.0f;
            }
        }
        return super.onTouchEvent(ev);
    }
}

