package com.livquik.qwcore.helper;


import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.common.BaseRequest;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.search.PlaceResponseBean;
import com.livquik.qwcore.pojo.response.search.SearchResponseBean;

import java.lang.reflect.Type;

/**
 * Created by test on 26/8/16.
 */

public class SearchHelper {

    private static final String TAG = SearchHelper.class.getName();

    public static SearchResponseBean searchPlaces(String query) throws QWException{
        BaseRequest baseRequest = new BaseRequest();
        Type finalType = new TypeToken<GenericResponse<SearchResponseBean>>() {
        }.getType();
        GenericResponse<SearchResponseBean> searchResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_SEARCH + query, Constants.Ajax.REQUEST_GET, baseRequest, finalType, null);
        return (SearchResponseBean) new ResponseProcessing<SearchResponseBean>(SearchResponseBean.class).processResponse(searchResponse);
    }

    public static PlaceResponseBean getPlace(String id) throws QWException{
        BaseRequest baseRequest = new BaseRequest();
        Type finalType = new TypeToken<GenericResponse<PlaceResponseBean>>() {
        }.getType();
        GenericResponse<PlaceResponseBean> placeResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PLACE, Constants.Ajax.REQUEST_POST, baseRequest, finalType, id);
        return (PlaceResponseBean) new ResponseProcessing<PlaceResponseBean>(PlaceResponseBean.class).processResponse(placeResponse);
    }
}
