package com.livquik.qwcore.helper;

import android.util.Log;

import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.response.common.BaseResponse;
import com.livquik.qwcore.pojo.response.common.GenericResponse;

/**
 * Created by turing on 3/8/15.
 */
public class ResponseProcessing<E> {
    private static final String TAG = ResponseProcessing.class.getName();

    Class responseClass = null;

    public ResponseProcessing(Class responseClass) {
        this.responseClass = responseClass;
    }

    public E createInstance() {
        try {
            return (E) this.responseClass.newInstance();
        } catch (InstantiationException e) {
            Log.e(TAG, "" + e);
        } catch (IllegalAccessException e) {
            Log.e(TAG, "" + e);
        }
        return null;
    }

    public BaseResponse processResponse(GenericResponse<E> response) throws QWException {
        Log.e(TAG, "In processing response function");
        if (response != null) {
            GenericResponse<BaseResponse> responseType = (GenericResponse<BaseResponse>) response;
            if (responseType.getData() != null) {
                responseType.getData().setMessage(response.getMessage());
                responseType.getData().setStatus(response.getStatus());
                return responseType.getData();
            } else {
                BaseResponse baseResponse = (BaseResponse) createInstance();
                if (baseResponse != null) {
                    baseResponse.setStatus(response.getStatus());
                    baseResponse.setMessage(response.getMessage());
                    return baseResponse;
                } else {
                    Log.e(TAG, "Please pass correct value while creating object of " + this.getClass().getName() + ".");
                    throw new QWException("Unable to process response.");
                }

            }
        } else {
            Log.e(TAG, "NULL SERVER RESPONSE");
            throw new QWException(Constants.Ajax.RESPONSE_NULL_RESPONSE);
        }
    }
}
