/*
 * Decompiled with CFR 0.152.
 */
package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.helper.AjaxHelper;
import com.livquik.qwcore.helper.RequestValidator;
import com.livquik.qwcore.helper.ResponseProcessing;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.request.others.CreditRequest;
import com.livquik.qwcore.pojo.request.others.GCMRegIdBean;
import com.livquik.qwcore.pojo.request.others.OffersRequest;
import com.livquik.qwcore.pojo.request.others.PendingPaymentRequest;
import com.livquik.qwcore.pojo.response.common.BaseResponse;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.others.CreditResponse;
import com.livquik.qwcore.pojo.response.others.OffersResponse;
import com.livquik.qwcore.pojo.response.payment.PendingPaymentsResponse;
import java.lang.reflect.Type;

public class UserHelper {
    public CreditResponse getCreditInfo(CreditRequest creditRequest) throws QWException {
        RequestValidator.validate(creditRequest);
        Type type = new TypeToken<GenericResponse<CreditResponse>>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("credit", "post", creditRequest, type, null);
        return (CreditResponse)new ResponseProcessing(CreditResponse.class).processResponse(genericResponse);
    }

    public OffersResponse getOffers(OffersRequest offersRequest) throws QWException {
        RequestValidator.validate(offersRequest);
        Type type = new TypeToken<GenericResponse<OffersResponse>>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("offers", "post", offersRequest, type, null);
        return (OffersResponse)new ResponseProcessing(OffersResponse.class).processResponse(genericResponse);
    }

    public BaseResponse registerGCMRegIDWithServer(GCMRegIdBean gCMRegIdBean) throws QWException {
        RequestValidator.validate(gCMRegIdBean);
        Type type = new TypeToken<GenericResponse>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("updatepush", "post", gCMRegIdBean, type, null);
        return new ResponseProcessing(BaseResponse.class).processResponse(genericResponse);
    }

    public PendingPaymentsResponse getPendingPayment(PendingPaymentRequest pendingPaymentRequest) throws QWException {
        RequestValidator.validate(pendingPaymentRequest);
        Type type = new TypeToken<GenericResponse<PendingPaymentsResponse>>(){}.getType();
        GenericResponse genericResponse = AjaxHelper.ajax("pendingpayments", "post", pendingPaymentRequest, type, null);
        return (PendingPaymentsResponse)new ResponseProcessing(PendingPaymentsResponse.class).processResponse(genericResponse);
    }
}

