package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.common.BaseRequest;
import com.livquik.qwcore.pojo.request.PartnerWallet.WalletConnectRequest;
import com.livquik.qwcore.pojo.request.others.AddBankRequestBean;
import com.livquik.qwcore.pojo.request.others.FullKycRequest;
import com.livquik.qwcore.pojo.request.others.KYCOtpRequest;
import com.livquik.qwcore.pojo.request.payment.WalletPayRequest;
import com.livquik.qwcore.pojo.response.PartnerWallet.OtpResponse;
import com.livquik.qwcore.pojo.response.PartnerWallet.PartnerLoggingResponse;
import com.livquik.qwcore.pojo.response.PartnerWallet.RechargeModeResponse;
import com.livquik.qwcore.pojo.response.PartnerWallet.WalletBalanceResponse;
import com.livquik.qwcore.pojo.response.common.BaseResponse;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.response.others.CreditResponse;
import com.livquik.qwcore.pojo.response.payment.PaymentUsingWalletResponse;

import java.lang.reflect.Type;

/**
 * Created by sachin on 21/8/17.
 */
public class PartnerWalletHelper {

    public static OtpResponse getOtpForWalletConnect(BaseRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type finalType = new TypeToken<GenericResponse<OtpResponse>>() {
        }.getType();
        GenericResponse<OtpResponse> getOtpResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_GENERATEOTP, Constants.Ajax.REQUEST_POST, baseRequest, finalType, null);
        return (OtpResponse)new ResponseProcessing<OtpResponse>(OtpResponse.class).processResponse(getOtpResponse);
    }

    public static PartnerLoggingResponse connectPartnerWallet(WalletConnectRequest walletConnectRequest) throws QWException {
        RequestValidator.validate(walletConnectRequest);
        Type finalType = new TypeToken<GenericResponse<PartnerLoggingResponse>>() {
        }.getType();
        GenericResponse<PartnerLoggingResponse> getConnectResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CONNECT, Constants.Ajax.REQUEST_POST, walletConnectRequest, finalType, null);
        return (PartnerLoggingResponse)new ResponseProcessing<PartnerLoggingResponse>(PartnerLoggingResponse.class).processResponse(getConnectResponse);
    }

    public static BaseResponse disconnectPartnerWallet(BaseRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type finalType = new TypeToken<GenericResponse>() {
        }.getType();
        GenericResponse getDisconnectResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_DISCONNECT, Constants.Ajax.REQUEST_POST, baseRequest, finalType, null);
        return new ResponseProcessing<BaseResponse>(BaseResponse.class).processResponse(getDisconnectResponse);
    }

    public static WalletBalanceResponse getWalletBalance(BaseRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type finalType = new TypeToken<GenericResponse<WalletBalanceResponse>>() {
        }.getType();
        GenericResponse<WalletBalanceResponse> getBalanceResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CHECK_BALANCE, Constants.Ajax.REQUEST_POST, baseRequest, finalType, null);
        return (WalletBalanceResponse) new ResponseProcessing<WalletBalanceResponse>(WalletBalanceResponse.class).processResponse(getBalanceResponse);
    }

    public static PaymentUsingWalletResponse payThroughWallet(WalletPayRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type finalType = new TypeToken<GenericResponse<PaymentUsingWalletResponse>>() {
        }.getType();
        GenericResponse<PaymentUsingWalletResponse> getPayResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_PAY, Constants.Ajax.REQUEST_POST, baseRequest, finalType, null);
        return (PaymentUsingWalletResponse) new ResponseProcessing<PaymentUsingWalletResponse>(PaymentUsingWalletResponse.class).processResponse(getPayResponse);
    }

    public static RechargeModeResponse getRechargeMode(BaseRequest baseRequest) throws QWException {
        RequestValidator.validate(baseRequest);
        Type finalType = new TypeToken<GenericResponse<RechargeModeResponse>>() {
        }.getType();
        GenericResponse<RechargeModeResponse> getModeResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_RECHARGE_MODE, Constants.Ajax.REQUEST_POST, baseRequest, finalType, null);
        return (RechargeModeResponse) new ResponseProcessing<RechargeModeResponse>(RechargeModeResponse.class).processResponse(getModeResponse);
    }

    public static BaseResponse getOtpForKYC(KYCOtpRequest kycOtpRequest) throws QWException {
        RequestValidator.validate(kycOtpRequest);
        Type finalType = new TypeToken<GenericResponse>() {
        }.getType();
        GenericResponse getKYCotpResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_KYC_OTP, Constants.Ajax.REQUEST_POST, kycOtpRequest, finalType, null);
        return new ResponseProcessing<BaseResponse>(BaseResponse.class).processResponse(getKYCotpResponse);
    }

    public static BaseResponse fullKyc(FullKycRequest fullKycRequest) throws QWException {
        RequestValidator.validate(fullKycRequest);
        Type finalType = new TypeToken<GenericResponse>() {
        }.getType();
        GenericResponse fullKycResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_UPDTE_FULL_KYC, Constants.Ajax.REQUEST_POST, fullKycRequest, finalType, null);
        return new ResponseProcessing<BaseResponse>(BaseResponse.class).processResponse(fullKycResponse);
    }

    public static BaseResponse addBank(AddBankRequestBean addBankRequestBean) throws QWException {
        RequestValidator.validate(addBankRequestBean);
        Type finalType = new TypeToken<GenericResponse>() {
        }.getType();
        GenericResponse addBankResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_ADD_BENEFICIARIES, Constants.Ajax.REQUEST_POST, addBankRequestBean, finalType, null);
        return new ResponseProcessing<BaseResponse>(BaseResponse.class).processResponse(addBankResponse);
    }
}
