package com.livquik.qwcore.helper;

import com.google.gson.reflect.TypeToken;
import com.livquik.qwcore.Constants;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.common.BaseRequest;
import com.livquik.qwcore.pojo.request.cards.AddCardRequest;
import com.livquik.qwcore.pojo.request.cards.ChangeDefaultCardRequest;
import com.livquik.qwcore.pojo.response.common.GenericResponse;
import com.livquik.qwcore.pojo.request.cards.AllCardsRequest;
import com.livquik.qwcore.pojo.request.cards.DeleteCardRequest;
import com.livquik.qwcore.pojo.response.cards.AddCardResponse;
import com.livquik.qwcore.pojo.response.cards.AllCardsResponse;
import com.livquik.qwcore.pojo.response.cards.ChangeDefaultCardResponse;
import com.livquik.qwcore.pojo.response.cards.DeleteCardResponse;

import java.lang.reflect.Type;

/**
 * Created by turing on 3/8/15.
 */
public class CardHelper {
    /**
     * @param addCardRequest
     * @return AddCardResponse
     * @throws QWException thrown in case of error
     */
    public static AddCardResponse addCard(AddCardRequest addCardRequest) throws QWException {
        RequestValidator.validate(addCardRequest);
        Type finalType = new TypeToken<GenericResponse<AddCardResponse>>() {
        }.getType();
        GenericResponse<AddCardResponse> addCardResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_ADD_CARD, Constants.Ajax.REQUEST_POST, addCardRequest, finalType, null);
        return (AddCardResponse) new ResponseProcessing<AddCardResponse>(AddCardResponse.class).processResponse(addCardResponse);
    }

    /**
     * @param deleteCardRequest
     * @return
     * @throws QWException
     */
    public static DeleteCardResponse deleteCard(DeleteCardRequest deleteCardRequest) throws QWException {
        RequestValidator.validate(deleteCardRequest);
        Type finalType = new TypeToken<GenericResponse<DeleteCardResponse>>() {
        }.getType();
        GenericResponse<DeleteCardResponse> deleteCardResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_DELETE_CARD, Constants.Ajax.REQUEST_POST, deleteCardRequest, finalType, null);
        return (DeleteCardResponse) new ResponseProcessing<DeleteCardResponse>(DeleteCardResponse.class).processResponse(deleteCardResponse);
    }

    /**
     * @param allCardsRequest
     * @return
     * @throws QWException
     */
    public static AllCardsResponse getCards(BaseRequest allCardsRequest) throws QWException {
        RequestValidator.validate(allCardsRequest);
        Type finalType = new TypeToken<GenericResponse<AllCardsResponse>>() {
        }.getType();
        GenericResponse<AllCardsResponse> allCardsResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CARDS, Constants.Ajax.REQUEST_POST, allCardsRequest, finalType, null);
        return (AllCardsResponse) new ResponseProcessing<AllCardsResponse>(AllCardsResponse.class).processResponse(allCardsResponse);
    }

    /**
     * @param changeDefaultCardRequest
     * @return
     * @throws QWException
     */
    public static ChangeDefaultCardResponse changeDefaultCard(ChangeDefaultCardRequest changeDefaultCardRequest) throws QWException {
        RequestValidator.validate(changeDefaultCardRequest);
        Type finalType = new TypeToken<GenericResponse<ChangeDefaultCardResponse>>() {
        }.getType();
        GenericResponse<ChangeDefaultCardResponse> changeDefaultCardResponse = AjaxHelper.ajax(Constants.Ajax.ENDPOINT_CHANGE_DEFAULT_CARD, Constants.Ajax.REQUEST_POST, changeDefaultCardRequest, finalType, null);
        return (ChangeDefaultCardResponse) new ResponseProcessing<ChangeDefaultCardResponse>(ChangeDefaultCardResponse.class).processResponse(changeDefaultCardResponse);
    }
}
