package com.livquik.qwcore;

import android.content.Context;

import com.livquik.qwcore.helper.CardHelper;
import com.livquik.qwcore.helper.ConfigurationHelper;
import com.livquik.qwcore.helper.LoginHelper;
import com.livquik.qwcore.helper.PaymentHelper;
import com.livquik.qwcore.helper.PlaceHelper;
import com.livquik.qwcore.helper.RegistrationHelper;
import com.livquik.qwcore.helper.SearchHelper;
import com.livquik.qwcore.helper.TransactionHelper;
import com.livquik.qwcore.helper.UserHelper;
import com.livquik.qwcore.pojo.QWException;
import com.livquik.qwcore.pojo.request.cards.AddCardRequest;
import com.livquik.qwcore.pojo.request.cards.AllCardsRequest;
import com.livquik.qwcore.pojo.request.cards.ChangeDefaultCardRequest;
import com.livquik.qwcore.pojo.request.cards.DeleteCardRequest;
import com.livquik.qwcore.pojo.request.login.ChangePasswordRequest;
import com.livquik.qwcore.pojo.request.login.LoginRequest;
import com.livquik.qwcore.pojo.request.others.CreditRequest;
import com.livquik.qwcore.pojo.request.others.GCMRegIdBean;
import com.livquik.qwcore.pojo.request.others.OffersRequest;
import com.livquik.qwcore.pojo.request.others.PendingPaymentRequest;
import com.livquik.qwcore.pojo.request.places.CheckinRequest;
import com.livquik.qwcore.pojo.request.places.PlacesRequest;
import com.livquik.qwcore.pojo.request.payment.BillRequest;
import com.livquik.qwcore.pojo.request.payment.CancelPaymentRequest;
import com.livquik.qwcore.pojo.request.payment.DropPaymentRequest;
import com.livquik.qwcore.pojo.request.payment.FindModesOfPaymentRequest;
import com.livquik.qwcore.pojo.request.payment.HowYouPaidRequest;
import com.livquik.qwcore.pojo.request.payment.PaymentFullFilledRequest;
import com.livquik.qwcore.pojo.request.payment.PaymentUsingNetBankingRequest;
import com.livquik.qwcore.pojo.request.payment.PaymentUsingNewPaymentCardRequest;
import com.livquik.qwcore.pojo.request.payment.PaymentUsingSavedPaymentCardRequest;
import com.livquik.qwcore.pojo.request.payment.RechargePrepaidCardUsingNetBankingRequest;
import com.livquik.qwcore.pojo.request.payment.RechargePrepaidCardUsingNewPaymentCardRequest;
import com.livquik.qwcore.pojo.request.payment.RechargePrepaidCardUsingSavedPaymentCardRequest;
import com.livquik.qwcore.pojo.request.payment.RejectPaymentRequest;
import com.livquik.qwcore.pojo.request.places.ReportRequest;
import com.livquik.qwcore.pojo.request.register.MobileNumberVerificationRequest;
import com.livquik.qwcore.pojo.request.register.RegisterUserRequest;
import com.livquik.qwcore.pojo.request.register.UpdateProfileRequest;
import com.livquik.qwcore.pojo.request.register.VerifyOTPRequest;
import com.livquik.qwcore.pojo.request.transaction.TransactionDetailsRequest;
import com.livquik.qwcore.pojo.request.transaction.TransactionHistoryRequest;
import com.livquik.qwcore.pojo.response.cards.AddCardResponse;
import com.livquik.qwcore.pojo.response.cards.AllCardsResponse;
import com.livquik.qwcore.pojo.response.cards.ChangeDefaultCardResponse;
import com.livquik.qwcore.pojo.response.cards.DeleteCardResponse;
import com.livquik.qwcore.pojo.response.common.BaseResponse;
import com.livquik.qwcore.pojo.response.login.ChangePasswordResponse;
import com.livquik.qwcore.pojo.response.login.LoginResponse;
import com.livquik.qwcore.pojo.response.others.CreditResponse;
import com.livquik.qwcore.pojo.response.others.OffersResponse;
import com.livquik.qwcore.pojo.response.payment.*;
import com.livquik.qwcore.pojo.response.places.CheckinResponse;
import com.livquik.qwcore.pojo.response.places.PlaceResponse;
import com.livquik.qwcore.pojo.response.places.PlacesResponse;
import com.livquik.qwcore.pojo.response.payment.BillResponse;
import com.livquik.qwcore.pojo.response.payment.CancelPaymentResponse;
import com.livquik.qwcore.pojo.response.payment.DropPaymentResponse;
import com.livquik.qwcore.pojo.response.payment.FindModesOfPaymentResponse;
import com.livquik.qwcore.pojo.response.payment.HowYouPaidResponse;
import com.livquik.qwcore.pojo.response.payment.PaymentFullFilledResponse;
import com.livquik.qwcore.pojo.response.payment.PaymentUsingNetBankingResponse;
import com.livquik.qwcore.pojo.response.payment.PaymentUsingNewPaymentCardResponse;
import com.livquik.qwcore.pojo.response.payment.PaymentUsingSavedPaymentCardResponse;
import com.livquik.qwcore.pojo.response.payment.RechargePrepaidCardUsingNetBankingResponse;
import com.livquik.qwcore.pojo.response.payment.RechargePrepaidCardUsingNewPaymentCardResponse;
import com.livquik.qwcore.pojo.response.payment.RechargePrepaidCardUsingSavedPaymentCardResponse;
import com.livquik.qwcore.pojo.response.payment.RejectPaymentResponse;
import com.livquik.qwcore.pojo.response.register.MobileNumberVerificationResponse;
import com.livquik.qwcore.pojo.response.register.RegisterUserResponse;
import com.livquik.qwcore.pojo.response.register.UpdateProfileResponse;
import com.livquik.qwcore.pojo.response.register.VerifyOTPResponse;
import com.livquik.qwcore.pojo.response.search.PlaceResponseBean;
import com.livquik.qwcore.pojo.response.search.SearchResponseBean;
import com.livquik.qwcore.pojo.response.transaction.TransactionDetailsResponse;
import com.livquik.qwcore.pojo.response.transaction.TransactionHistoryResponse;

/**
 * Created by turing on 3/8/15.
 */
public class QWSDK {
    public QWSDK() {
        ConfigurationHelper.init();
    }

    /**
     * @param config
     */
    public QWSDK(String config) {
        ConfigurationHelper.init(config);
    }

    public QWSDK(Context context) {
        ConfigurationHelper.init(context);
    }

    public QWSDK(String config, Context context) {
        ConfigurationHelper.init(config, context);
    }

    public MobileNumberVerificationResponse verifyMobileNumber(MobileNumberVerificationRequest mobileNumberVerificationRequest) throws QWException {
        return new RegistrationHelper().verifyMobileNumber(mobileNumberVerificationRequest);
    }

    public VerifyOTPResponse verifyOTP(VerifyOTPRequest verifyOTPRequest) throws QWException {
        return new RegistrationHelper().verifyOTP(verifyOTPRequest);
    }

    public CreditResponse getCreditInfo(CreditRequest getCreditRequest) throws QWException {
        return new UserHelper().getCreditInfo(getCreditRequest);
    }

    public OffersResponse getOffers(OffersRequest offerRequest) throws QWException {
        return new UserHelper().getOffers(offerRequest);
    }

    public ChangePasswordResponse changePassword(ChangePasswordRequest changePasswordRequest) throws QWException {
        return new LoginHelper().changePassword(changePasswordRequest);
    }

    public TransactionDetailsResponse getTransactionDetails(TransactionDetailsRequest transactionDetailsRequest) throws QWException {
        return new TransactionHelper().getTransactionDetails(transactionDetailsRequest);
    }

    public TransactionHistoryResponse getTransactionHistory(TransactionHistoryRequest transactionHistoryRequest) throws QWException {
        return new TransactionHelper().getTransactionHistory(transactionHistoryRequest);
    }

    public AddCardResponse addCard(AddCardRequest addCardRequest) throws QWException {
        return CardHelper.addCard(addCardRequest);
    }

    public DeleteCardResponse deleteCard(DeleteCardRequest deleteCardRequest) throws QWException {
        return CardHelper.deleteCard(deleteCardRequest);
    }

    public AllCardsResponse getCards(AllCardsRequest allCardsRequest) throws QWException {
        return CardHelper.getCards(allCardsRequest);
    }

    public ChangeDefaultCardResponse changeDefaultCard(ChangeDefaultCardRequest defaultCardRequest) throws QWException {
        return CardHelper.changeDefaultCard(defaultCardRequest);
    }

    public RejectPaymentResponse rejectPayment(RejectPaymentRequest rejectPaymentRequest) throws QWException {
        return PaymentHelper.rejectPayment(rejectPaymentRequest);
    }

    public CancelPaymentResponse cancelPayment(CancelPaymentRequest cancelPaymentRequest) throws QWException {
        return PaymentHelper.cancelPayment(cancelPaymentRequest);
    }

    public DropPaymentResponse dropPayment(DropPaymentRequest dropPaymentRequest) throws QWException {
        return PaymentHelper.dropPayment(dropPaymentRequest);
    }

    public PaymentUsingNetBankingResponse paymentUsingNetBanking(PaymentUsingNetBankingRequest paymentUsingNetBankingRequest) throws QWException {
        paymentUsingNetBankingRequest.setPaymentmode(Constants.PAYMENT_TYPES.NETBANKING);
        return PaymentHelper.paymentUsingNetBanking(paymentUsingNetBankingRequest);
    }

    public PaymentFullFilledResponse paymentFullFilled(PaymentFullFilledRequest paymentFullFilledRequest) throws QWException {
        return PaymentHelper.paymentFullFilled(paymentFullFilledRequest);
    }


    public PaymentUsingSavedPaymentCardResponse paymentUsingSavedPaymentCard(PaymentUsingSavedPaymentCardRequest paymentUsingSavedPaymentCardRequest) throws QWException {
        paymentUsingSavedPaymentCardRequest.setPaymentmode(Constants.PAYMENT_TYPES.PAYMENTCARD);
        return PaymentHelper.paymentUsingSavedPaymentCard(paymentUsingSavedPaymentCardRequest);
    }

    public PaymentUsingNewPaymentCardResponse paymentUsingNewPaymentCard(PaymentUsingNewPaymentCardRequest paymentUsingNewPaymentCardRequest) throws QWException {
        paymentUsingNewPaymentCardRequest.setPaymentmode(Constants.PAYMENT_TYPES.PAYMENTCARD);
        return PaymentHelper.paymentUsingNewPaymentCard(paymentUsingNewPaymentCardRequest);
    }

    public RechargePrepaidCardUsingNewPaymentCardResponse rechargePrepaidCardUsingNewPaymentCard(RechargePrepaidCardUsingNewPaymentCardRequest rechargePrepaidCardUsindNewPaymentCardRequest) throws QWException {
        rechargePrepaidCardUsindNewPaymentCardRequest.setType(Constants.PAYMENT_TYPES.RECHARGE);
        rechargePrepaidCardUsindNewPaymentCardRequest.setCardtype(Constants.CARD_TYPE.PAYMENT);
        return PaymentHelper.rechargePrepaidCardUsindNewPaymentCard(rechargePrepaidCardUsindNewPaymentCardRequest);
    }

    public RechargePrepaidCardUsingSavedPaymentCardResponse rechargePrepaidCardUsingSavedPaymentCard(RechargePrepaidCardUsingSavedPaymentCardRequest rechargePrepaidCardUsingSavedPaymentCardRequest) throws QWException {
        rechargePrepaidCardUsingSavedPaymentCardRequest.setType(Constants.PAYMENT_TYPES.RECHARGE);
        rechargePrepaidCardUsingSavedPaymentCardRequest.setCardtype(Constants.CARD_TYPE.PAYMENT);
        return PaymentHelper.rechargePrepaidCardUsingSavedPaymentCard(rechargePrepaidCardUsingSavedPaymentCardRequest);
    }

    public RechargePrepaidCardUsingNetBankingResponse rechargePrepaidCardUsingNetBanking(RechargePrepaidCardUsingNetBankingRequest rechargePrepaidCardUsingNetBankingRequest) throws QWException {
        return PaymentHelper.rechargePrepaidCardUsingNetBanking(rechargePrepaidCardUsingNetBankingRequest);
    }

    public FindModesOfPaymentResponse findModesOfPayment(FindModesOfPaymentRequest findModesOfPaymentRequest) throws QWException {
        return PaymentHelper.findModesOfPayment(findModesOfPaymentRequest);
    }

    public HowYouPaidResponse getHowYouPaid(HowYouPaidRequest howYouPaidRequest) throws QWException {
        return PaymentHelper.getHowYouPaid(howYouPaidRequest);
    }

    public PaymentByHashResponse getPaymentByHash(String hash) throws QWException {
        return PaymentHelper.getPaymentByHash(hash);
    }

    public RegisterUserResponse registerUser(RegisterUserRequest registerUserRequest) throws QWException {
        return new RegistrationHelper().registerUser(registerUserRequest);
    }

    public LoginResponse login(LoginRequest loginRequest) throws QWException {
        return new LoginHelper().login(loginRequest);
    }

    //passing user id is mandatory
    public UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws QWException {
        return new RegistrationHelper().updateProfile(updateProfileRequest);
    }

    public BillResponse requestBill(BillRequest request) throws QWException {
        return new PaymentHelper().requestBill(request);
    }

    /**
     * @param mobileNumber Mobile number to be verified
     * @param uuid
     * @param pushid
     * @param platform     Platform like android, ios etc
     * @return MobileNumberVerificationResponse Holds response from server
     * @throws QWException
     */
    public MobileNumberVerificationResponse verifyMobileNumber(String mobileNumber, String uuid, String pushid, String platform) throws QWException {
        MobileNumberVerificationRequest verifyMobileNumberRequest = new MobileNumberVerificationRequest(null, null, mobileNumber, null, null, null, null, null, uuid, platform, pushid);
        return new RegistrationHelper().verifyMobileNumber(verifyMobileNumberRequest);
    }

    /**
     * @param mobileNumber Mobile number to be verified
     * @param uuid
     * @param pushid
     * @param platform     Platform like android, ios etc
     * @param qwversion    QuikWallet version
     * @param latitude     Latitude
     * @param longitude    Longitude
     * @return MobileNumberVerificationResponse -> Holds response from server
     * @throws QWException
     */
    public MobileNumberVerificationResponse verifyMobileNumber(String mobileNumber, String uuid, String pushid, String platform, String qwversion, String latitude, String longitude) throws QWException {
        MobileNumberVerificationRequest verifyMobileNumberRequest = new MobileNumberVerificationRequest(null, null, mobileNumber, latitude, longitude, qwversion, null, null, uuid, platform, pushid);
        return new RegistrationHelper().verifyMobileNumber(verifyMobileNumberRequest);
    }

    /**
     * @param otp   one time password
     * @param token
     * @param uuid
     * @return VerifyOTPResponse -> Holds response from server
     * @throws QWException
     */
    public VerifyOTPResponse verifyOTP(String otp, String token, String uuid) throws QWException {
        VerifyOTPRequest verifyOTPRequest = new VerifyOTPRequest(null, null, null, null, null, null, null, null, otp, token, uuid);
        return new RegistrationHelper().verifyOTP(verifyOTPRequest);
    }

    /**
     * @param otp       one time password
     * @param token
     * @param uuid
     * @param qwversion Quikwallet version
     * @param latitude  latitude
     * @param longitude longitude
     * @return VerifyOTPResponse Holds Response from server
     * @throws QWException
     */
    public VerifyOTPResponse verifyOTP(String otp, String token, String uuid, String qwversion, String latitude, String longitude) throws QWException {
        VerifyOTPRequest verifyOTPRequest = new VerifyOTPRequest(null, null, null, latitude, longitude, qwversion, null, null, otp, token, uuid);
        return new RegistrationHelper().verifyOTP(verifyOTPRequest);
    }

    /**
     * @param device          Model name
     * @param email           User email address
     * @param firstname       First name
     * @param lastname        Lase Name
     * @param imsi            IMSI number
     * @param mobile          mobile number
     * @param network         network provider
     * @param networktype     network type "gsm/cdma"
     * @param password        user password
     * @param platform        PLatform name like android, ios etc
     * @param platformversion platform version
     * @param pushid
     * @param simserial       sim serial number
     * @param token
     * @param uuid
     * @param qwversion       quik wallet version
     * @param latitude        latitude
     * @param longitude       longitude
     * @return RegisterUserResponse
     * @throws QWException
     */
    public RegisterUserResponse registerUser(String device, String email, String firstname, String lastname, String imsi, String mobile, String network, String networktype, String password, String platform, String platformversion, String pushid, String simserial, String token, String uuid, String qwversion, String latitude, String longitude) throws QWException {
        RegisterUserRequest registerUserRequest = new RegisterUserRequest(device, email, firstname, lastname, imsi, mobile, network, networktype, password, platform, platformversion, pushid, simserial, token, uuid, latitude, longitude, qwversion);
        return new RegistrationHelper().registerUser(registerUserRequest);
    }

    /**
     * @param device          Model name
     * @param email           User email address
     * @param firstname       First name
     * @param lastname        Lase Name
     * @param imsi            IMSI number
     * @param mobile          mobile number
     * @param network         network provider
     * @param networktype     network type "gsm/cdma"
     * @param password        user password
     * @param platform        PLatform name like android, ios etc
     * @param platformversion platform version
     * @param pushid
     * @param simserial       sim serial number
     * @param token
     * @param uuid
     * @return RegisterUserResponse
     * @throws QWException
     */
    public RegisterUserResponse registerUser(String device, String email, String firstname, String lastname, String imsi, String mobile, String network, String networktype, String password, String platform, String platformversion, String pushid, String simserial, String token, String uuid) throws QWException {
        RegisterUserRequest registerUserRequest = new RegisterUserRequest(device, email, firstname, lastname, imsi, mobile, network, networktype, password, platform, platformversion, pushid, simserial, token, uuid, null, null, null);
        return new RegistrationHelper().registerUser(registerUserRequest);
    }

    /**
     * @param userid
     * @param address1
     * @param address2
     * @param city
     * @param dob
     * @param firstname
     * @param lastname
     * @param gender
     * @param network
     * @param pincode
     * @param primaryemail
     * @param state
     * @param passphrase
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return
     * @throws QWException
     */
    //UserId is mandatory here
    public UpdateProfileResponse updateProfile(String userid, String address1, String address2, String city, String dob, String firstname, String lastname, String gender, String network, String pincode, String primaryemail, String state, String passphrase, String qwversion, String latitude, String longitude) throws QWException {
        UpdateProfileRequest updateProfileRequest = new UpdateProfileRequest(userid, address1, address2, city, dob, firstname, lastname, gender, network, pincode, primaryemail, state, passphrase, qwversion, latitude, longitude);
        return new RegistrationHelper().updateProfile(updateProfileRequest);
    }

    /**
     * @param userid
     * @param address1
     * @param address2
     * @param city
     * @param dob
     * @param firstname
     * @param lastname
     * @param gender
     * @param network
     * @param pincode
     * @param primaryemail
     * @param state
     * @param passphrase
     * @return
     * @throws QWException
     */
    //UserId is mandatory here
    public UpdateProfileResponse updateProfile(String userid, String address1, String address2, String city, String dob, String firstname, String lastname, String gender, String network, String pincode, String primaryemail, String state, String passphrase) throws QWException {
        UpdateProfileRequest updateProfileRequest = new UpdateProfileRequest(userid, address1, address2, city, dob, firstname, lastname, gender, network, pincode, primaryemail, state, passphrase, null, null, null);
        return new RegistrationHelper().updateProfile(updateProfileRequest);
    }

    /**
     * @param userid     User id
     * @param passphrase Passphrase of the user
     * @return CreditResponse Object holding response from server
     * @throws QWException
     */
    public CreditResponse getCreditInfo(String userid, String passphrase) throws QWException {
        CreditRequest getCreditRequest = new CreditRequest(passphrase, userid);
        return new UserHelper().getCreditInfo(getCreditRequest);
    }

    /**
     * @param userid     User id
     * @param passphrase passphrase of the user
     * @param qwversion  quikwallet version
     * @param latitude   latitude
     * @param longitude  longitude
     * @return CreditResponse Object holding response from server
     * @throws QWException
     */
    public CreditResponse getCreditInfo(String userid, String passphrase, String qwversion, String latitude, String longitude) throws QWException {
        CreditRequest getcreditRequest = new CreditRequest(latitude, longitude, passphrase, qwversion, userid);
        return new UserHelper().getCreditInfo(getcreditRequest);
    }

    //TODO fields to be checked .. server returns message":"Missing important data."

    /**
     * @param partnerid is your partner id provided by QuikWallet.
     * @param secret    is the signature generated using the users mobile number & the Secret Key provided by QuikWallet.
     * @param mobile    is the users registered mobile number (without the '+91' prefix).
     * @return CreditResponse Object holding response from server
     * @throws QWException in case of failure
     */
    public CreditResponse getCreditInfo(String partnerid, String secret, String mobile) throws QWException {
        CreditRequest getcreditRequest = new CreditRequest(partnerid, secret, mobile);
        return new UserHelper().getCreditInfo(getcreditRequest);
    }


    /**
     * @param userid     User id
     * @param passphrase passphrase of the user
     * @return OffersResponse  Object holding response from server
     * @throws QWException
     */
    public OffersResponse getOffers(String userid, String passphrase) throws QWException {
        OffersRequest offerRequest = new OffersRequest(null, null, passphrase, null, userid);
        return new UserHelper().getOffers(offerRequest);
    }

    /**
     * @param userid     User id
     * @param passphrase passphrase of the user
     * @param qwversion  qwikwallet version
     * @param longitude  longitude
     * @param latitude   latitude
     * @return OffersResponse Object holding response from server
     * @throws QWException
     */
    public OffersResponse getOffers(String userid, String passphrase, String qwversion, String longitude, String latitude) throws QWException {
        OffersRequest offerRequest = new OffersRequest(latitude, longitude, passphrase, qwversion, userid);
        return new UserHelper().getOffers(offerRequest);
    }

    /**
     * @param partnerid is your partner id provided by QuikWallet.
     * @param secret    is the signature generated using the users mobile number & the Secret Key provided by QuikWallet.
     * @param mobile    is the users registered mobile number (without the '+91' prefix).
     * @return CreditResponse Object holding response from server
     * @throws QWException in case of failure
     */
    public OffersResponse getOffers(String partnerid, String secret, String mobile) throws QWException {
        OffersRequest offerRequest = new OffersRequest(partnerid, secret, mobile);
        return new UserHelper().getOffers(offerRequest);
    }

    /**
     * @param new_password     New Password
     * @param current_password old passowrd
     * @param userid           user id
     * @param passphrase       passphrase
     * @return ChangePasswordResponse
     * @throws QWException
     */
    public ChangePasswordResponse changePassword(String new_password, String current_password, String userid, String passphrase) throws QWException {
        ChangePasswordRequest changePasswordRequest = new ChangePasswordRequest(null, null, passphrase, null, userid, new_password, current_password);
        return new LoginHelper().changePassword(changePasswordRequest);
    }

    /**
     * @param new_password
     * @param current_password
     * @param userid
     * @param passphrase
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return ChangePasswordResponse
     * @throws QWException
     */
    public ChangePasswordResponse changePassword(String new_password, String current_password, String userid, String passphrase, String qwversion, String latitude, String longitude) throws QWException {
        ChangePasswordRequest changePasswordRequest = new ChangePasswordRequest(latitude, longitude, passphrase, qwversion, userid, new_password, current_password);
        return new LoginHelper().changePassword(changePasswordRequest);
    }

//TODO to be checked , server response is message":"Insufficient Data"

    /**
     * @param new_password
     * @param current_password
     * @param partnerid
     * @param secret
     * @param mobilenumber
     * @return ChangePasswordResponse
     * @throws QWException
     */
    public ChangePasswordResponse changePassword(String new_password, String current_password, String partnerid, String secret, String mobilenumber) throws QWException {
        ChangePasswordRequest changePasswordRequest = new ChangePasswordRequest(partnerid, secret, mobilenumber, new_password, current_password);
        return new LoginHelper().changePassword(changePasswordRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param device
     * @param imsi
     * @param uuid
     * @param network
     * @param networktype
     * @param platform
     * @param platformversion
     * @param pushid
     * @param simserial
     * @param isFirstLogin
     * @param qwversion
     * @return LoginResponse
     * @throws QWException
     */
    public LoginResponse login(String userid, String passphrase, String device, String imsi, String uuid, String network, String networktype, String platform, String platformversion, String pushid, String
            simserial, String isFirstLogin, String qwversion) throws QWException {
        LoginRequest loginRequest = new LoginRequest(device, imsi, uuid, network, networktype, platform, platformversion, pushid, simserial, isFirstLogin, null, null, passphrase, qwversion, userid);
        return new LoginHelper().login(loginRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param device
     * @param imsi
     * @param uuid
     * @param network
     * @param networktype
     * @param platform
     * @param platformversion
     * @param pushid
     * @param simserial
     * @param isFirstLogin
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return LoginResponse
     * @throws QWException
     */
    public LoginResponse login(String userid, String passphrase, String device, String imsi, String uuid, String network, String networktype, String platform, String platformversion, String pushid, String
            simserial, String isFirstLogin, String qwversion, String latitude, String longitude) throws QWException {
        LoginRequest loginRequest = new LoginRequest(device, imsi, uuid, network, networktype, platform, platformversion, pushid, simserial, isFirstLogin, latitude, longitude, passphrase, qwversion, userid);
        return new LoginHelper().login(loginRequest);
    }

    /**
     * @param id
     * @param userid
     * @param passphrase
     * @return TransactionDetailsResponse
     * @throws QWException
     */
    public TransactionDetailsResponse getTransactionDetails(String id, String userid, String passphrase) throws QWException {
        TransactionDetailsRequest transactionDetailsRequest = new TransactionDetailsRequest(id, null, null, passphrase, null, userid);
        return new TransactionHelper().getTransactionDetails(transactionDetailsRequest);
    }

    /**
     * @param id
     * @param userid
     * @param passphrase
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return TransactionDetailsResponse
     * @throws QWException
     */
    public TransactionDetailsResponse getTransactionDetails(String id, String userid, String passphrase, String qwversion, String latitude, String longitude) throws QWException {
        TransactionDetailsRequest transactionDetailsRequest = new TransactionDetailsRequest(id, latitude, longitude, passphrase, qwversion, userid);
        return new TransactionHelper().getTransactionDetails(transactionDetailsRequest);
    }

    /**
     * For Partners
     *
     * @param id
     * @param partnerid
     * @param secret
     * @param mobile
     * @return TransactionDetailsResponse
     * @throws QWException
     */
    public TransactionDetailsResponse getTransactionDetails(String id, String partnerid, String secret, String mobile) throws QWException {
        TransactionDetailsRequest transactionDetailsRequest = new TransactionDetailsRequest(partnerid, secret, mobile, id);
        return new TransactionHelper().getTransactionDetails(transactionDetailsRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param page
     * @return TransactionHistoryResponse
     * @throws QWException
     */
    public TransactionHistoryResponse getTransactionHistory(String userid, String passphrase, String page) throws QWException {
        TransactionHistoryRequest transactionHistoryRequest = new TransactionHistoryRequest(passphrase, userid, page);
        return new TransactionHelper().getTransactionHistory(transactionHistoryRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param page
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return TransactionHistoryResponse
     * @throws QWException
     */
    public TransactionHistoryResponse getTransactionHistory(String userid, String passphrase, String page, String qwversion, String latitude, String longitude) throws QWException {
        TransactionHistoryRequest transactionHistoryRequest = new TransactionHistoryRequest(page, latitude, longitude, passphrase, qwversion, userid);
        return new TransactionHelper().getTransactionHistory(transactionHistoryRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param page
     * @return TransactionHistoryResponse
     * @throws QWException
     */
    public TransactionHistoryResponse getTransactionHistory(String partnerid, String secret, String mobile, String page) throws QWException {
        TransactionHistoryRequest transactionHistoryRequest = new TransactionHistoryRequest(partnerid, secret, mobile, page);
        return new TransactionHelper().getTransactionHistory(transactionHistoryRequest);
    }

    /**
     * @param userid     User id
     * @param passphrase passphrase
     * @param ccno       card number
     * @param cardtype   cadtype "payment"
     * @param expmm      expiry month like 02, 12 etc
     * @param expyyyy    expiry year like 2045"
     * @param isdefault  wether card is default or not true or false
     * @param name       Name of card holder
     * @param tail       last four digit
     * @param type       card type like master visa etc
     * @return AddCardResponse
     * @throws QWException
     */
    public AddCardResponse addCard(String userid, String passphrase, String ccno, String cardtype, String expmm, String expyyyy, String isdefault, String name, String tail, String type) throws QWException {
        AddCardRequest addCardRequest = new AddCardRequest(cardtype, ccno, expmm, expyyyy, isdefault, name, tail, type, null, null, passphrase, null, userid);
        return CardHelper.addCard(addCardRequest);
    }

    /**
     * @param userid     User id
     * @param passphrase passphrase
     * @param ccno       card number
     * @param cardtype   cadtype "payment"
     * @param expmm      expiry month like 02, 12 etc
     * @param expyyyy    expiry year like 2045"
     * @param isdefault  wether card is default or not true or false
     * @param name       Name of card holder
     * @param tail       last four digit
     * @param type       card type like master visa etc
     * @param qwversion  qwikwallet version
     * @param latitude   latitude
     * @param longitude  longitude
     * @return AddCardResponse
     * @throws QWException
     */
    public AddCardResponse addCard(String userid, String passphrase, String ccno, String cardtype, String expmm, String expyyyy, String isdefault, String name, String tail, String type, String qwversion, String latitude, String longitude) throws QWException {
        AddCardRequest addCardRequest = new AddCardRequest(cardtype, ccno, expmm, expyyyy, isdefault, name, tail, type, latitude, longitude, passphrase, qwversion, userid);
        return CardHelper.addCard(addCardRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param ccno
     * @param cardtype
     * @param expmm
     * @param expyyyy
     * @param isdefault
     * @param name
     * @param tail
     * @param type
     * @return
     * @throws QWException
     */
    public AddCardResponse addCard(String partnerid, String secret, String mobile, String ccno, String cardtype, String expmm, String expyyyy, String isdefault, String name, String tail, String type) throws QWException {
        AddCardRequest addCardRequest = new AddCardRequest(partnerid, secret, mobile, cardtype, ccno, expmm, expyyyy, isdefault, name, tail, type);
        return CardHelper.addCard(addCardRequest);
    }

    /**
     * @param userid     userid
     * @param passphrase passphrase
     * @param token      card token
     * @param card_id    card id
     * @return DeleteCardResponse
     * @throws QWException
     */
    public DeleteCardResponse deleteCard(String userid, String passphrase, String token, String card_id) throws QWException {
        DeleteCardRequest deleteCardRequest = new DeleteCardRequest(token, card_id, null, null, passphrase, null, userid);
        return CardHelper.deleteCard(deleteCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param token
     * @param card_id
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return DeleteCardResponse
     * @throws QWException
     */
    public DeleteCardResponse deleteCard(String userid, String passphrase, String token, String card_id, String qwversion, String latitude, String longitude) throws QWException {
        DeleteCardRequest deleteCardRequest = new DeleteCardRequest(token, card_id, latitude, longitude, passphrase, qwversion, userid);
        return CardHelper.deleteCard(deleteCardRequest);
    }

    /**
     * Delete card for patners
     *
     * @param partnerid
     * @param secret
     * @param mobile
     * @param token
     * @param card_id
     * @return DeleteCardResponse
     * @throws QWException
     */
    public DeleteCardResponse deleteCard(String partnerid, String secret, String mobile, String token, String card_id) throws QWException {
        DeleteCardRequest deleteCardResponse = new DeleteCardRequest(partnerid, secret, mobile, token, card_id);
        return CardHelper.deleteCard(deleteCardResponse);
    }

    /**
     * @param userid     Userid
     * @param passphrase Passphrase
     * @return AllCardsResponse
     * @throws QWException
     */
    public AllCardsResponse getCards(String userid, String passphrase) throws QWException {
        AllCardsRequest allCardsRequest = new AllCardsRequest(passphrase, userid);
        return CardHelper.getCards(allCardsRequest);
    }

    /**
     * @param userid     UserID
     * @param passphrase Pasphrase
     * @param qwversion  quikwallet version
     * @param latitude   Latitude
     * @param longitude  Longitude
     * @return AllCardsResponse
     * @throws QWException
     */
    public AllCardsResponse getCards(String userid, String passphrase, String qwversion, String latitude, String longitude) throws QWException {
        AllCardsRequest allCardsRequest = new AllCardsRequest(userid, passphrase, qwversion, latitude, longitude);
        return CardHelper.getCards(allCardsRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @return AllCardsResponse
     * @throws QWException
     */
    public AllCardsResponse getCards(String partnerid, String secret, String mobile) throws QWException {
        AllCardsRequest allCardsRequest = new AllCardsRequest(partnerid, secret, mobile);
        return CardHelper.getCards(allCardsRequest);
    }

    /**
     * @param userid      user id
     * @param passphrase  encrypted password
     * @param defaultflag card token
     * @param card_id     card id
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return ChangeDefaultCardResponse
     * @throws QWException
     */
    public ChangeDefaultCardResponse changeDefaultCard(String userid, String passphrase, String defaultflag, String card_id, String qwversion, String latitude, String longitude) throws QWException {
        ChangeDefaultCardRequest defaultCardRequest = new ChangeDefaultCardRequest(userid, latitude, longitude, passphrase, qwversion, defaultflag, card_id);
        return CardHelper.changeDefaultCard(defaultCardRequest);
    }

    /**
     * @param userid      user id
     * @param passphrase  encrypted password
     * @param defaultflag card token
     * @param card_id     card id
     * @return ChangeDefaultCardResponse
     * @throws QWException
     */
    public ChangeDefaultCardResponse changeDefaultCard(String userid, String passphrase, String defaultflag, String card_id) throws QWException {
        ChangeDefaultCardRequest defaultCardRequest = new ChangeDefaultCardRequest(passphrase, userid, defaultflag, card_id);
        return CardHelper.changeDefaultCard(defaultCardRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param defaultflag
     * @param card_id
     * @return ChangeDefaultCardResponse
     * @throws QWException
     */
    public ChangeDefaultCardResponse changeDefaultCard(String partnerid, String secret, String mobile, String defaultflag, String card_id) throws QWException {
        ChangeDefaultCardRequest defaultCardRequest = new ChangeDefaultCardRequest(partnerid, secret, mobile, defaultflag, card_id);
        return CardHelper.changeDefaultCard(defaultCardRequest);
    }

    /**
     * @param userid     user id
     * @param passphrase encrypted password
     * @param amount     amount to be paid
     * @param id
     * @param outletid   outletid
     * @param retailerid retailer id
     * @param type       payment type pull, push etc
     * @return RejectPaymentResponse
     * @throws QWException
     */
    public RejectPaymentResponse rejectPayment(String userid, String passphrase, String amount, String id, String outletid, String retailerid, String type) throws QWException {
        RejectPaymentRequest rejectPaymentRequest = new RejectPaymentRequest(amount, id, outletid, retailerid, type, null, null, passphrase, null, userid);
        return PaymentHelper.rejectPayment(rejectPaymentRequest);
    }

    /**
     * @param userid     user id
     * @param passphrase encrypted password
     * @param amount     amount to be paid
     * @param id
     * @param outletid   outletid
     * @param retailerid retailer id
     * @param type       payment type pull, push etc
     * @param qwversion  quikwallet version
     * @param latitude   latitude
     * @param longitude  longitude
     * @return RejectPaymentResponse
     * @throws QWException
     */
    public RejectPaymentResponse rejectPayment(String userid, String passphrase, String amount, String id, String outletid, String retailerid, String type, String qwversion, String latitude, String longitude) throws QWException {
        RejectPaymentRequest rejectPaymentRequest = new RejectPaymentRequest(amount, id, outletid, retailerid, type, latitude, longitude, passphrase, qwversion, userid);
        return PaymentHelper.rejectPayment(rejectPaymentRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param amount
     * @param id
     * @param outletid
     * @param retailerid
     * @param type
     * @return RejectPaymentResponse
     * @throws QWException
     */
    public RejectPaymentResponse rejectPayment(String partnerid, String secret, String mobile, String amount, String id, String outletid, String retailerid, String type) throws QWException {
        RejectPaymentRequest rejectPaymentRequest = new RejectPaymentRequest(partnerid, secret, mobile, amount, id, outletid, retailerid, type);
        return PaymentHelper.rejectPayment(rejectPaymentRequest);
    }

    /**
     * @param userid     userid
     * @param passphrase encrypted user password
     * @param paymentid  paymentid to cancel
     * @return CancelPaymentResponse
     * @throws QWException
     */
    public CancelPaymentResponse cancelPayment(String userid, String passphrase, String paymentid) throws QWException {
        CancelPaymentRequest cancelPaymentRequest = new CancelPaymentRequest(paymentid, userid, null, null, passphrase, null);
        return PaymentHelper.cancelPayment(cancelPaymentRequest);
    }

    /**
     * @param userid     userid
     * @param passphrase encrypted user password
     * @param paymentid  paymentid to cancel
     * @param qwversion  quikwallet version
     * @param latitude   latitude
     * @param longitude  longitude
     * @return CancelPaymentResponse
     * @throws QWException
     */
    public CancelPaymentResponse cancelPayment(String userid, String passphrase, String paymentid, String qwversion, String latitude, String longitude) throws QWException {
        CancelPaymentRequest cancelPaymentRequest = new CancelPaymentRequest(paymentid, userid, latitude, longitude, passphrase, qwversion);
        return PaymentHelper.cancelPayment(cancelPaymentRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param paymentid
     * @return CancelPaymentResponse
     * @throws QWException
     */
    public CancelPaymentResponse cancelPayment(String partnerid, String secret, String mobile, String paymentid) throws QWException {
        CancelPaymentRequest cancelPaymentRequest = new CancelPaymentRequest(partnerid, secret, mobile, paymentid);
        return PaymentHelper.cancelPayment(cancelPaymentRequest);
    }

    /**
     * @param userid     User id
     * @param passphrase Encrypted password
     * @param paymentid  payment id
     * @return DropPaymentResponse
     * @throws QWException
     */
    public DropPaymentResponse dropPayment(String userid, String passphrase, String paymentid) throws QWException {
        DropPaymentRequest dropPaymentRequest = new DropPaymentRequest(paymentid, null, null, passphrase, null, userid);
        return PaymentHelper.dropPayment(dropPaymentRequest);
    }

    /**
     * @param userid     User id
     * @param passphrase Encrypted password
     * @param paymentid  payment id
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return
     * @throws QWException
     */
    public DropPaymentResponse dropPayment(String userid, String passphrase, String paymentid, String qwversion, String latitude, String longitude) throws QWException {
        DropPaymentRequest dropPaymentRequest = new DropPaymentRequest(paymentid, latitude, longitude, passphrase, qwversion, userid);
        return PaymentHelper.dropPayment(dropPaymentRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param paymentid
     * @return DropPaymentResponse
     * @throws QWException
     */
    public DropPaymentResponse dropPayment(String partnerid, String secret, String mobile, String paymentid) throws QWException {
        DropPaymentRequest dropPaymentRequest = new DropPaymentRequest(partnerid, secret, mobile, paymentid);
        return PaymentHelper.dropPayment(dropPaymentRequest);
    }

    /**
     * @param userid         user id
     * @param passphrase     encrypted password
     * @param amount         amount to be paid
     * @param netbankingcode net banking code
     * @param outletid       outlet id
     * @param tip            tip to be paid
     * @return PaymentUsingNetBankingResponse
     * @throws QWException
     */
    public PaymentUsingNetBankingResponse paymentUsingNetBanking(String userid, String passphrase, String amount, String netbankingcode, String outletid, String tip) throws QWException {
        PaymentUsingNetBankingRequest paymentUsingNetBankingRequest = new PaymentUsingNetBankingRequest(amount, netbankingcode, outletid, Constants.PAYMENT_TYPES.NETBANKING, tip, null, null, passphrase, null, userid);
        return PaymentHelper.paymentUsingNetBanking(paymentUsingNetBankingRequest);
    }

    /**
     * @param userid         user id
     * @param passphrase     encrypted password
     * @param amount         amount to be paid
     * @param netbankingcode net banking code
     * @param outletid       outlet id
     * @param tip            tip to be paid
     * @param qwversion      quikwallet version
     * @param latitude       latitude
     * @param longitude      longitude
     * @return PaymentUsingNetBankingResponse
     * @throws QWException
     */
    public PaymentUsingNetBankingResponse paymentUsingNetBanking(String userid, String passphrase, String amount, String netbankingcode, String outletid, String tip, String qwversion, String latitude, String longitude) throws QWException {
        PaymentUsingNetBankingRequest paymentUsingNetBankingRequest = new PaymentUsingNetBankingRequest(amount, netbankingcode, outletid, Constants.PAYMENT_TYPES.NETBANKING, tip, latitude, longitude, passphrase, qwversion, userid);
        return PaymentHelper.paymentUsingNetBanking(paymentUsingNetBankingRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param amount
     * @param netbankingcode
     * @param outletid
     * @param tip
     * @return PaymentUsingNetBankingResponse
     * @throws QWException
     */
    public PaymentUsingNetBankingResponse paymentUsingNetBanking(String partnerid, String secret, String mobile, String amount, String netbankingcode, String outletid, String tip) throws QWException {
        PaymentUsingNetBankingRequest paymentUsingNetBankingRequest = new PaymentUsingNetBankingRequest(partnerid, secret, mobile, amount, netbankingcode, outletid, Constants.PAYMENT_TYPES.NETBANKING, tip);
        return PaymentHelper.paymentUsingNetBanking(paymentUsingNetBankingRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param amount
     * @param card_id
     * @param cardtype
     * @param cvv2
     * @param outletid
     * @param tip
     * @return PaymentUsingSavedPaymentCardRespone
     * @throws QWException
     */
    public PaymentUsingSavedPaymentCardResponse paymentUsingSavedPaymentCard(String userid, String passphrase, String amount, String card_id, String cardtype, String cvv2, String outletid, String tip) throws QWException {
        PaymentUsingSavedPaymentCardRequest paymentUsingSavedPaymentCardRequest = new PaymentUsingSavedPaymentCardRequest(amount, card_id, cardtype, cvv2, outletid, Constants.PAYMENT_TYPES.PAYMENTCARD, tip, null, null, passphrase, null, userid);
        return PaymentHelper.paymentUsingSavedPaymentCard(paymentUsingSavedPaymentCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param amount
     * @param card_id
     * @param cardtype
     * @param cvv2
     * @param outletid
     * @param tip
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return PaymentUsingSavedPaymentCardRespone
     * @throws QWException
     */
    public PaymentUsingSavedPaymentCardResponse paymentUsingSavedPaymentCard(String userid, String passphrase, String amount, String card_id, String cardtype, String cvv2, String outletid, String tip, String qwversion, String latitude, String longitude) throws QWException {
        PaymentUsingSavedPaymentCardRequest paymentUsingSavedPaymentCardRequest = new PaymentUsingSavedPaymentCardRequest(amount, card_id, cardtype, cvv2, outletid, Constants.PAYMENT_TYPES.PAYMENTCARD, tip, latitude, longitude, passphrase, qwversion, userid);
        return PaymentHelper.paymentUsingSavedPaymentCard(paymentUsingSavedPaymentCardRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param amount
     * @param card_id
     * @param cardtype
     * @param cvv2
     * @param outletid
     * @param tip
     * @return PaymentUsingSavedPaymentCardRespone
     * @throws QWException
     */
    public PaymentUsingSavedPaymentCardResponse paymentUsingSavedPaymentCard(String partnerid, String secret, String mobile, String amount, String card_id, String cardtype, String cvv2, String outletid, String tip) throws QWException {
        PaymentUsingSavedPaymentCardRequest paymentUsingSavedPaymentCardRequest = new PaymentUsingSavedPaymentCardRequest(partnerid, secret, mobile, amount, card_id, cardtype, cvv2, outletid, Constants.PAYMENT_TYPES.PAYMENTCARD, tip);
        return PaymentHelper.paymentUsingSavedPaymentCard(paymentUsingSavedPaymentCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param ccno
     * @param expmm
     * @param expyyyy
     * @param last_four_digits
     * @param name
     * @param visaormaster
     * @param amount
     * @param cardtype
     * @param cvv2
     * @param outletid
     * @param tip
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return PaymentUsingNewPaymentCardResponse
     * @throws QWException
     */
    public PaymentUsingNewPaymentCardResponse paymentUsingNewPaymentCard(String userid, String passphrase, String ccno, String expmm, String expyyyy, String last_four_digits, String name, String visaormaster, String amount, String cardtype, String cvv2, String outletid, String tip, String qwversion, String latitude, String longitude) throws QWException {
        PaymentUsingNewPaymentCardRequest paymentUsingNewPaymentCardRequest = new PaymentUsingNewPaymentCardRequest(userid, latitude, longitude, passphrase, qwversion, ccno, expmm, expyyyy, last_four_digits, name, visaormaster, amount, cardtype, cvv2, outletid, Constants.PAYMENT_TYPES.PAYMENTCARD, tip);
        return PaymentHelper.paymentUsingNewPaymentCard(paymentUsingNewPaymentCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param ccno
     * @param expmm
     * @param expyyyy
     * @param last_four_digits
     * @param name
     * @param visaormaster
     * @param amount
     * @param cardtype
     * @param cvv2
     * @param outletid
     * @param tip
     * @return PaymentUsingNewPaymentCardResponse
     * @throws QWException
     */
    public PaymentUsingNewPaymentCardResponse paymentUsingNewPaymentCard(String userid, String passphrase, String ccno, String expmm, String expyyyy, String last_four_digits, String name, String visaormaster, String amount, String cardtype, String cvv2, String outletid, String tip) throws QWException {
        PaymentUsingNewPaymentCardRequest paymentUsingNewPaymentCardRequest = new PaymentUsingNewPaymentCardRequest(userid, null, null, passphrase, null, ccno, expmm, expyyyy, last_four_digits, name, visaormaster, amount, cardtype, cvv2, outletid, Constants.PAYMENT_TYPES.PAYMENTCARD, tip);
        return PaymentHelper.paymentUsingNewPaymentCard(paymentUsingNewPaymentCardRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param ccno
     * @param expmm
     * @param expyyyy
     * @param last_four_digits
     * @param name
     * @param visaormaster
     * @param amount
     * @param cardtype
     * @param cvv2
     * @param outletid
     * @param tip
     * @return PaymentUsingNewPaymentCardResponse
     * @throws QWException
     */
    public PaymentUsingNewPaymentCardResponse paymentUsingNewPaymentCard(String partnerid, String secret, String mobile, String ccno, String expmm, String expyyyy, String last_four_digits, String name, String visaormaster, String amount, String cardtype, String cvv2, String outletid, String tip) throws QWException {
        PaymentUsingNewPaymentCardRequest paymentUsingNewPaymentCardRequest = new PaymentUsingNewPaymentCardRequest(partnerid, secret, mobile, ccno, expmm, expyyyy, last_four_digits, name, visaormaster, amount, cardtype, cvv2, outletid, Constants.PAYMENT_TYPES.PAYMENTCARD, tip);
        return PaymentHelper.paymentUsingNewPaymentCard(paymentUsingNewPaymentCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param amount
     * @param cardtype
     * @param ccno
     * @param companyid
     * @param cvv2
     * @param expmm
     * @param expyyyy
     * @param name
     * @param network
     * @param type
     * @param retailerid
     * @param tail
     * @param retailer_card_id
     * @return RechargePrepaidCardUsingNewPaymentCardResponse
     * @throws QWException
     */
    public RechargePrepaidCardUsingNewPaymentCardResponse rechargePrepaidCardUsingNewPaymentCard(String userid, String passphrase, String amount, String cardtype, String ccno, String companyid, String cvv2, String expmm, String expyyyy, String name, String network, String type, String retailerid, String tail, String retailer_card_id) throws QWException {
        RechargePrepaidCardUsingNewPaymentCardRequest rechargePrepaidCardUsindNewPaymentCardRequest = new RechargePrepaidCardUsingNewPaymentCardRequest(amount, cardtype, ccno, companyid, cvv2, expmm, expyyyy, name, network, type, retailerid, tail, retailer_card_id, null, null, passphrase, null, userid);
        return PaymentHelper.rechargePrepaidCardUsindNewPaymentCard(rechargePrepaidCardUsindNewPaymentCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param amount
     * @param cardtype
     * @param ccno
     * @param companyid
     * @param cvv2
     * @param expmm
     * @param expyyyy
     * @param name
     * @param network
     * @param type
     * @param retailerid
     * @param tail
     * @param retailer_card_id
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return RechargePrepaidCardUsingNewPaymentCardResponse
     * @throws QWException
     */
    public RechargePrepaidCardUsingNewPaymentCardResponse rechargePrepaidCardUsingNewPaymentCard(String userid, String passphrase, String amount, String cardtype, String ccno, String companyid, String cvv2, String expmm, String expyyyy, String name, String network, String type, String retailerid, String tail, String retailer_card_id, String qwversion, String latitude, String longitude) throws QWException {
        RechargePrepaidCardUsingNewPaymentCardRequest rechargePrepaidCardUsindNewPaymentCardRequest = new RechargePrepaidCardUsingNewPaymentCardRequest(amount, cardtype, ccno, companyid, cvv2, expmm, expyyyy, name, network, type, retailerid, tail, retailer_card_id, latitude, longitude, passphrase, qwversion, userid);
        return PaymentHelper.rechargePrepaidCardUsindNewPaymentCard(rechargePrepaidCardUsindNewPaymentCardRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param amount
     * @param cardtype
     * @param ccno
     * @param companyid
     * @param cvv2
     * @param expmm
     * @param expyyyy
     * @param name
     * @param network
     * @param type
     * @param retailerid
     * @param tail
     * @param retailer_card_id
     * @return RechargePrepaidCardUsingNewPaymentCardResponse
     * @throws QWException
     */
    public RechargePrepaidCardUsingNewPaymentCardResponse rechargePrepaidCardUsingNewPaymentCard(String partnerid, String secret, String mobile, String amount, String cardtype, String ccno, String companyid, String cvv2, String expmm, String expyyyy, String name, String network, String type, String retailerid, String tail, String retailer_card_id) throws QWException {
        RechargePrepaidCardUsingNewPaymentCardRequest rechargePrepaidCardUsindNewPaymentCardRequest = new RechargePrepaidCardUsingNewPaymentCardRequest(partnerid, secret, mobile, amount, cardtype, ccno, companyid, cvv2, expmm, expyyyy, name, network, type, retailerid, tail, retailer_card_id);
        return PaymentHelper.rechargePrepaidCardUsindNewPaymentCard(rechargePrepaidCardUsindNewPaymentCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param amount
     * @param card_id
     * @param cardtype
     * @param cvv2
     * @param type
     * @param retailerid
     * @param token
     * @param retailer_card_id
     * @return RechargePrepaidCardUsindSavedPaymentCardResponse
     * @throws QWException
     */
    public RechargePrepaidCardUsingSavedPaymentCardResponse rechargePrepaidCardUsingSavedPaymentCard(String userid, String passphrase, String amount, String card_id, String cardtype, String cvv2, String type, String retailerid, String token, String retailer_card_id) throws QWException {
        RechargePrepaidCardUsingSavedPaymentCardRequest rechargePrepaidCardUsingSavedPaymentCardRequest = new RechargePrepaidCardUsingSavedPaymentCardRequest(amount, card_id, cardtype, cvv2, type, retailerid, token, retailer_card_id, null, null, passphrase, null, userid);
        return PaymentHelper.rechargePrepaidCardUsingSavedPaymentCard(rechargePrepaidCardUsingSavedPaymentCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param amount
     * @param card_id
     * @param cardtype
     * @param cvv2
     * @param type
     * @param retailerid
     * @param token
     * @param retailer_card_id
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return RechargePrepaidCardUsindSavedPaymentCardResponse
     * @throws QWException
     */
    public RechargePrepaidCardUsingSavedPaymentCardResponse rechargePrepaidCardUsingSavedPaymentCard(String userid, String passphrase, String amount, String card_id, String cardtype, String cvv2, String type, String retailerid, String token, String retailer_card_id, String qwversion, String latitude, String longitude) throws QWException {
        RechargePrepaidCardUsingSavedPaymentCardRequest rechargePrepaidCardUsindNewPaymentCardRequest = new RechargePrepaidCardUsingSavedPaymentCardRequest(amount, card_id, cardtype, cvv2, type, retailerid, token, retailer_card_id, latitude, longitude, passphrase, qwversion, userid);
        return PaymentHelper.rechargePrepaidCardUsingSavedPaymentCard(rechargePrepaidCardUsindNewPaymentCardRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param amount
     * @param card_id
     * @param cardtype
     * @param cvv2
     * @param type
     * @param retailerid
     * @param token
     * @param retailer_card_id
     * @return RechargePrepaidCardUsingSavedPaymentCardResponse
     * @throws QWException
     */
    public RechargePrepaidCardUsingSavedPaymentCardResponse rechargePrepaidCardUsingSavedPaymentCard(String partnerid, String secret, String mobile, String amount, String card_id, String cardtype, String cvv2, String type, String retailerid, String token, String retailer_card_id) throws QWException {
        RechargePrepaidCardUsingSavedPaymentCardRequest rechargePrepaidCardUsindSavedPaymentCardRequest = new RechargePrepaidCardUsingSavedPaymentCardRequest(partnerid, secret, mobile, amount, card_id, cardtype, cvv2, type, retailerid, token, retailer_card_id);
        return PaymentHelper.rechargePrepaidCardUsingSavedPaymentCard(rechargePrepaidCardUsindSavedPaymentCardRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param outletid
     * @param amount
     * @param tip
     * @return FindModesOfPaymentResponse
     * @throws QWException
     */
    public FindModesOfPaymentResponse findModesOfPayment(String userid, String passphrase, String outletid, String amount, String tip) throws QWException {
        FindModesOfPaymentRequest findModesOfPaymentRequest = new FindModesOfPaymentRequest(outletid, amount, tip, null, null, passphrase, null, userid);
        return PaymentHelper.findModesOfPayment(findModesOfPaymentRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param outletid
     * @param amount
     * @param tip
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return FindModesOfPaymentResponse
     * @throws QWException
     */
    public FindModesOfPaymentResponse findModesOfPayment(String userid, String passphrase, String outletid, String amount, String tip, String qwversion, String latitude, String longitude) throws QWException {
        FindModesOfPaymentRequest findModesOfPaymentRequest = new FindModesOfPaymentRequest(outletid, amount, tip, latitude, longitude, passphrase, qwversion, userid);
        return PaymentHelper.findModesOfPayment(findModesOfPaymentRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param outletid
     * @param amount
     * @param tip
     * @return FindModesOfPaymentResponse
     * @throws QWException
     */
    public FindModesOfPaymentResponse findModesOfPayment(String partnerid, String secret, String mobile, String outletid, String amount, String tip) throws QWException {
        FindModesOfPaymentRequest findModesOfPaymentRequest = new FindModesOfPaymentRequest(partnerid, secret, mobile, outletid, amount, tip);
        return PaymentHelper.findModesOfPayment(findModesOfPaymentRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param id
     * @return HowYouPaidResponse
     * @throws QWException
     */
    public HowYouPaidResponse getHowYouPaid(String userid, String passphrase, String id) throws QWException {
        HowYouPaidRequest howYouPaidRequest = new HowYouPaidRequest(id, null, null, passphrase, null, userid);
        return PaymentHelper.getHowYouPaid(howYouPaidRequest);
    }

    /**
     * @param userid
     * @param passphrase
     * @param id
     * @param qwversion
     * @param latitude
     * @param longitude
     * @return HowYouPaidResponse
     * @throws QWException
     */
    public HowYouPaidResponse getHowYouPaid(String userid, String passphrase, String id, String qwversion, String latitude, String longitude) throws QWException {
        HowYouPaidRequest howYouPaidRequest = new HowYouPaidRequest(id, latitude, longitude, passphrase, qwversion, userid);
        return PaymentHelper.getHowYouPaid(howYouPaidRequest);
    }

    /**
     * @param partnerid
     * @param secret
     * @param mobile
     * @param id
     * @return HowYouPaidResponse
     * @throws QWException
     */
    public HowYouPaidResponse getHowYouPaid(String partnerid, String secret, String mobile, String id) throws QWException {
        HowYouPaidRequest howYouPaidRequest = new HowYouPaidRequest(partnerid, secret, mobile, id);
        return PaymentHelper.getHowYouPaid(howYouPaidRequest);
    }


    public PlacesResponse getPlaces(PlacesRequest allPlacesRequest) throws QWException {
        return PlaceHelper.getPlaces(allPlacesRequest);
    }

    public PlaceResponse getPlace(String placeId) throws QWException {
        return PlaceHelper.getPlace(placeId);
    }

    public CheckinResponse checkin(CheckinRequest checkinRequest) throws QWException {
        return PlaceHelper.checkin(checkinRequest);
    }

    public CheckinResponse checkout(CheckinRequest checkinRequest) throws QWException {
        return PlaceHelper.checkout(checkinRequest);
    }

    public BaseResponse reportIssue(ReportRequest checkinRequest) throws QWException {
        return new PlaceHelper().reportIssue(checkinRequest);
    }

    public BaseResponse registerPushIdWithServer(GCMRegIdBean gcmRegIdBeanRequest) throws QWException {
        return new UserHelper().registerGCMRegIDWithServer(gcmRegIdBeanRequest);
    }

    public PendingPaymentsResponse getPendingPayments(PendingPaymentRequest pendingPaymentRequest) throws QWException {
        return new UserHelper().getPendingPayment(pendingPaymentRequest);
    }

    public SearchResponseBean getSearchResults(String quary) throws QWException {
        return SearchHelper.searchPlaces(quary);
    }

    public PlaceResponseBean getSearchPlace(String id) throws QWException {
        return SearchHelper.getPlace(id);
    }

}
