/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.vh;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.liuxiangdong.jsonview.ElementProvider;
import com.liuxiangdong.jsonview.IndentationView;
import com.liuxiangdong.jsonview.vh.Bindable;
import com.liuxiangdong.jsonview.vm.JsonViewModel;

public class JsonViewHolder<T extends JsonViewModel>
extends RecyclerView.ViewHolder
implements Bindable<T> {
    private T viewModel;
    private final IndentationView indentationView;
    private final TextView indexView;
    final LinearLayout linearLayout;
    private final ElementProvider elementProvider;

    JsonViewHolder(Context context, ElementProvider elementProvider) {
        super((View)new LinearLayout(context));
        this.elementProvider = elementProvider;
        this.linearLayout = (LinearLayout)this.itemView;
        this.linearLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-2, -2));
        this.linearLayout.setOrientation(0);
        this.linearLayout.setGravity(16);
        this.indentationView = new IndentationView(context);
        this.indentationView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        this.indentationView.setLineColor(elementProvider.indentationViewLineColor(context));
        this.indentationView.setLineWidth(elementProvider.indentationViewLineWidth(context));
        this.indentationView.setIndentation(elementProvider.indentationWidth(context));
        this.linearLayout.addView((View)this.indentationView);
        this.indexView = elementProvider.createIndexView((ViewGroup)this.linearLayout);
        if (this.indexView != null) {
            this.linearLayout.addView((View)this.indexView);
        }
    }

    @Override
    public void onBind(T t) {
        this.viewModel = t;
        this.indentationView.setDepth(((JsonViewModel)t).getDepth());
        if (this.indexView != null) {
            if (this.elementProvider.shouldDisplayIndex(this.itemView.getContext(), t)) {
                CharSequence indexText = ((JsonViewModel)t).getIndexText();
                if (!TextUtils.isEmpty((CharSequence)indexText)) {
                    this.indexView.setText(((JsonViewModel)t).getIndexText());
                    this.indexView.setVisibility(0);
                } else {
                    this.indexView.setVisibility(8);
                }
            } else {
                this.indexView.setVisibility(8);
            }
        }
    }

    T getViewModel() {
        return this.viewModel;
    }
}

