/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.renderer;

import android.util.SparseArray;
import com.liuxiangdong.jsonview.renderer.Renderer;
import com.liuxiangdong.jsonview.vh.JsonViewHolder;
import com.liuxiangdong.jsonview.vm.JsonViewModel;

public class RendererRegistry {
    private final SparseArray<Renderer<? extends JsonViewModel, ? extends JsonViewHolder<?>>> renderers = new SparseArray();
    private final SparseArray<Class<? extends JsonViewModel>> viewTypeViewModelMapping = new SparseArray();

    public final <VM extends JsonViewModel, VH extends JsonViewHolder<VM>> Renderer<VM, VH> getRenderer(int viewType) {
        return (Renderer)this.renderers.get(viewType);
    }

    public <VM extends JsonViewModel, VH extends JsonViewHolder<VM>> void registerRender(Renderer<VM, VH> renderer) {
        this.renderers.put(renderer.getItemViewType(), renderer);
        this.viewTypeViewModelMapping.put(renderer.getItemViewType(), renderer.getViewModelClass());
    }

    public int getItemViewType(Class<? extends JsonViewModel> clazz) {
        int index = this.viewTypeViewModelMapping.indexOfValue(clazz);
        if (index == -1) {
            return 0;
        }
        return this.viewTypeViewModelMapping.keyAt(index);
    }
}

