/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.entry;

import com.liuxiangdong.jsonview.entry.JsonCompoundEntry;
import com.liuxiangdong.jsonview.entry.JsonEntry;
import com.liuxiangdong.jsonview.entry.converter.JsonEntryConverterRegistry;
import com.liuxiangdong.jsonview.vm.JsonViewModel;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class JsonObjectEntry
extends JsonCompoundEntry<JSONObject> {
    public JsonObjectEntry(String key, JSONObject value, int depth, int index, JsonEntryConverterRegistry registry) {
        super(key, value, depth, index, registry);
    }

    @Override
    protected void inflateChildren() {
        JSONObject jsonObject = (JSONObject)this.getValue();
        Iterator keys = jsonObject.keys();
        int index = 0;
        while (keys.hasNext()) {
            String k = (String)keys.next();
            JsonEntry<?> child = this.createJsonEntry(k, jsonObject.opt(k), index);
            if (child != null) {
                this.addChild(child);
            }
            ++index;
        }
    }

    @Override
    public int getEntryCount() {
        return ((JSONObject)this.getValue()).length();
    }

    @Override
    protected List<? extends JsonViewModel> provideViewModels() {
        return this.getRegistry().getJsonEntryConverter(JsonObjectEntry.class).convert(this);
    }
}

