/*
 * Decompiled with CFR 0.152.
 */
package com.liuxiangdong.jsonview.entry;

import com.liuxiangdong.jsonview.entry.JsonParent;
import com.liuxiangdong.jsonview.entry.converter.JsonEntryConverterRegistry;
import com.liuxiangdong.jsonview.vm.JsonViewModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class JsonEntry<T> {
    private final String key;
    private final T value;
    List<JsonViewModel> viewModels;
    private final int depth;
    private final int index;
    private JsonParent parent;
    private final JsonEntryConverterRegistry registry;

    JsonEntry(String key, T value, int depth, int index, JsonEntryConverterRegistry registry) {
        this.key = key;
        this.value = value;
        this.depth = depth;
        this.index = index;
        this.registry = registry;
    }

    void setParent(JsonParent parent) {
        this.parent = parent;
    }

    public int getIndex() {
        return this.index;
    }

    JsonParent getParent() {
        return this.parent;
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public int getDepth() {
        return this.depth;
    }

    public List<JsonViewModel> getViewModels() {
        if (this.viewModels == null) {
            this.viewModels = new ArrayList<JsonViewModel>();
            List<JsonViewModel> jsonViewModels = this.provideViewModels();
            if (jsonViewModels != null && !jsonViewModels.isEmpty()) {
                this.viewModels.addAll(jsonViewModels);
            }
        }
        return Collections.unmodifiableList(this.viewModels);
    }

    public int getParentEntryCount() {
        if (this.parent != null) {
            return this.parent.getEntryCount();
        }
        return 1;
    }

    protected abstract List<? extends JsonViewModel> provideViewModels();

    public JsonEntryConverterRegistry getRegistry() {
        return this.registry;
    }
}

